/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.FunctionNode;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.StringValue;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class UcaFunction
extends FunctionNode {
    private final String locale;
    private final String strength;

    public UcaFunction(GroupingExpression exp, String locale) {
        this(null, null, Arrays.asList(exp, new StringValue(locale)));
    }

    public UcaFunction(GroupingExpression exp, String locale, String strength) {
        this(null, null, Arrays.asList(exp, new StringValue(locale), new StringValue(strength)));
        if (!this.validStrength(strength)) {
            throw new IllegalArgumentException("Not a valid UCA strength: " + strength);
        }
    }

    private UcaFunction(String label, Integer level, List<GroupingExpression> args) {
        super("uca", label, level, args);
        this.locale = (String)((StringValue)args.get(1)).getValue();
        this.strength = args.size() > 2 ? (String)((StringValue)args.get(2)).getValue() : "TERTIARY";
    }

    @Override
    public UcaFunction copy() {
        return new UcaFunction(this.getLabel(), this.getLevelOrNull(), this.args().stream().map(arg -> arg.copy()).collect(Collectors.toList()));
    }

    private boolean validStrength(String strength) {
        return strength.equals("PRIMARY") || strength.equals("SECONDARY") || strength.equals("TERTIARY") || strength.equals("QUATERNARY") || strength.equals("IDENTICAL");
    }

    public String getLocale() {
        return this.locale;
    }

    public String getStrength() {
        return this.strength;
    }
}

