/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.AddFunction;
import com.yahoo.search.grouping.request.DivFunction;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.ModFunction;
import com.yahoo.search.grouping.request.MulFunction;
import com.yahoo.search.grouping.request.SubFunction;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class MathResolver {
    private final List<Item> items = new LinkedList<Item>();

    public void push(Type type, GroupingExpression exp) {
        if (this.items.isEmpty() && type != Type.ADD) {
            throw new IllegalArgumentException("First item in an arithmetic operation must be an addition.");
        }
        this.items.add(new Item(type, exp));
    }

    public GroupingExpression resolve() {
        if (this.items.size() == 1) {
            return this.items.remove((int)0).exp;
        }
        Stack<Item> stack = new Stack<Item>();
        stack.push(this.items.remove(0));
        while (!this.items.isEmpty()) {
            Item item = this.items.remove(0);
            while (stack.size() > 1 && stack.peek().type.pre >= item.type.pre) {
                this.pop(stack);
            }
            stack.push(item);
        }
        while (stack.size() > 1) {
            this.pop(stack);
        }
        return ((Item)stack.remove((int)0)).exp;
    }

    private void pop(Stack<Item> stack) {
        Item rhs = stack.pop();
        Item lhs = stack.peek();
        switch (rhs.type) {
            case ADD: {
                lhs.exp = new AddFunction(lhs.exp, rhs.exp, new GroupingExpression[0]);
                break;
            }
            case DIV: {
                lhs.exp = new DivFunction(lhs.exp, rhs.exp, new GroupingExpression[0]);
                break;
            }
            case MOD: {
                lhs.exp = new ModFunction(lhs.exp, rhs.exp, new GroupingExpression[0]);
                break;
            }
            case MUL: {
                lhs.exp = new MulFunction(lhs.exp, rhs.exp, new GroupingExpression[0]);
                break;
            }
            case SUB: {
                lhs.exp = new SubFunction(lhs.exp, rhs.exp, new GroupingExpression[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operator " + rhs.type + " not supported.");
            }
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        int len = this.items.size();
        for (int i = 0; i < len; ++i) {
            Item item = this.items.get(i);
            if (i != 0) {
                ret.append(" ").append(item.type.image).append(" ");
            }
            ret.append(item.exp.toString());
        }
        return ret.toString();
    }

    private static class Item {
        final Type type;
        GroupingExpression exp;

        Item(Type type, GroupingExpression exp) {
            this.type = type;
            this.exp = exp;
        }
    }

    public static enum Type {
        ADD(0, "+"),
        SUB(1, "-"),
        DIV(2, "/"),
        MOD(3, "%"),
        MUL(4, "*");

        private final int pre;
        private final String image;

        private Type(int pre, String image) {
            this.pre = pre;
            this.image = image;
        }
    }
}

