/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.searchchain.Execution;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
@Provides(value={"SelectParameterParsing"})
public class GroupingQueryParser
extends Searcher {
    public static final String SELECT_PARAMETER_PARSING = "SelectParameterParsing";
    public static final CompoundName PARAM_CONTINUE = new CompoundName("continue");
    public static final CompoundName PARAM_REQUEST = new CompoundName("select");
    public static final CompoundName PARAM_TIMEZONE = new CompoundName("timezone");
    private static final ThreadLocal<ZoneCache> zoneCache = new ThreadLocal();

    @Override
    public Result search(Query query, Execution execution) {
        String reqParam = query.properties().getString(PARAM_REQUEST);
        if (reqParam == null) {
            return execution.search(query);
        }
        List<Continuation> continuations = this.getContinuations(query.properties().getString(PARAM_CONTINUE));
        TimeZone zone = this.getTimeZone(query.properties().getString(PARAM_TIMEZONE, "utc"));
        for (GroupingOperation op : GroupingOperation.fromStringAsList(reqParam)) {
            GroupingRequest grpRequest = GroupingRequest.newInstance(query);
            grpRequest.setRootOperation(op);
            grpRequest.setTimeZone(zone);
            grpRequest.continuations().addAll(continuations);
        }
        return execution.search(query);
    }

    private List<Continuation> getContinuations(String param) {
        if (param == null) {
            return Collections.emptyList();
        }
        LinkedList<Continuation> ret = new LinkedList<Continuation>();
        for (String str : param.split(" ")) {
            ret.add(Continuation.fromString(str));
        }
        return ret;
    }

    private TimeZone getTimeZone(String name) {
        TimeZone timeZone;
        ZoneCache cache = zoneCache.get();
        if (cache == null) {
            cache = new ZoneCache();
            zoneCache.set(cache);
        }
        if ((timeZone = (TimeZone)cache.get(name)) == null) {
            timeZone = TimeZone.getTimeZone(name);
            cache.put(name, timeZone);
        }
        return timeZone;
    }

    private static class ZoneCache
    extends LinkedHashMap<String, TimeZone> {
        ZoneCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimeZone> entry) {
            return this.size() > 128;
        }
    }
}

