/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.selection;

import com.google.common.base.Preconditions;
import com.yahoo.component.chain.Chain;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.model.federation.FederationOptions;

public final class FederationTarget<T> {
    private final Chain<Searcher> chain;
    private final FederationOptions federationOptions;
    private final T customData;

    public FederationTarget(Chain<Searcher> chain, FederationOptions federationOptions, T customData) {
        Preconditions.checkNotNull(chain);
        Preconditions.checkNotNull((Object)federationOptions);
        this.chain = chain;
        this.federationOptions = federationOptions;
        this.customData = customData;
    }

    public Chain<Searcher> getChain() {
        return this.chain;
    }

    public FederationOptions getFederationOptions() {
        return this.federationOptions;
    }

    public T getCustomData() {
        return this.customData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FederationTarget that = (FederationTarget)o;
        if (!this.chain.equals(that.chain)) {
            return false;
        }
        if (this.customData != null ? !this.customData.equals(that.customData) : that.customData != null) {
            return false;
        }
        return this.federationOptions.equals(that.federationOptions);
    }

    public int hashCode() {
        int result = this.chain.hashCode();
        result = 31 * result + this.federationOptions.hashCode();
        return result;
    }
}

