/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.CloseableInvoker;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.result.Hit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InterleavedFillInvoker
extends FillInvoker {
    private final Map<Integer, FillInvoker> invokers;
    private Map<Integer, Result> expectedFillResults = null;

    public InterleavedFillInvoker(Map<Integer, FillInvoker> invokers) {
        this.invokers = invokers;
    }

    @Override
    protected void sendFillRequest(Result result, String summaryClass) {
        this.expectedFillResults = new HashMap<Integer, Result>();
        Iterator<Hit> it = result.hits().deepIterator();
        while (it.hasNext()) {
            Hit hit = it.next();
            if (!(hit instanceof FastHit)) continue;
            FastHit fhit = (FastHit)hit;
            Result res = this.expectedFillResults.computeIfAbsent(fhit.getDistributionKey(), dk -> new Result(result.getQuery()));
            res.hits().add(fhit);
        }
        this.expectedFillResults.forEach((distKey, partialResult) -> {
            FillInvoker invoker = this.invokers.get(distKey);
            if (invoker != null) {
                invoker.sendFillRequest((Result)partialResult, summaryClass);
            }
        });
    }

    @Override
    protected void getFillResults(Result result, String summaryClass) {
        if (this.expectedFillResults == null) {
            return;
        }
        this.expectedFillResults.forEach((distKey, partialResult) -> {
            FillInvoker invoker = this.invokers.get(distKey);
            if (invoker != null) {
                invoker.getFillResults((Result)partialResult, summaryClass);
            }
        });
    }

    @Override
    protected void release() {
        if (!this.invokers.isEmpty()) {
            this.invokers.values().forEach(CloseableInvoker::close);
            this.invokers.clear();
        }
    }
}

