/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.component.AbstractComponent;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.FS4InvokerFactory;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.LoadBalancer;
import com.yahoo.search.dispatch.RpcResourcePool;
import com.yahoo.search.dispatch.SearchErrorInvoker;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.SearchPath;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import com.yahoo.search.query.Model;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class Dispatcher
extends AbstractComponent {
    private static final int MAX_GROUP_SELECTION_ATTEMPTS = 3;
    private static final CompoundName dispatchInternal = new CompoundName("dispatch.internal");
    private final SearchCluster searchCluster;
    private final LoadBalancer loadBalancer;
    private final RpcResourcePool rpcResourcePool;
    private final boolean multilevelDispatch;
    private final boolean internalDispatchByDefault;

    public Dispatcher(String clusterId, DispatchConfig dispatchConfig, FS4ResourcePool fs4ResourcePool, int containerClusterSize, VipStatus vipStatus) {
        this(new SearchCluster(clusterId, dispatchConfig, fs4ResourcePool, containerClusterSize, vipStatus), dispatchConfig);
    }

    public Dispatcher(SearchCluster searchCluster, DispatchConfig dispatchConfig) {
        this.searchCluster = searchCluster;
        this.loadBalancer = new LoadBalancer(searchCluster, dispatchConfig.distributionPolicy() == DispatchConfig.DistributionPolicy.ROUNDROBIN);
        this.rpcResourcePool = new RpcResourcePool(dispatchConfig);
        this.multilevelDispatch = dispatchConfig.useMultilevelDispatch();
        this.internalDispatchByDefault = !dispatchConfig.useFdispatchByDefault();
    }

    public SearchCluster searchCluster() {
        return this.searchCluster;
    }

    public void deconstruct() {
        this.rpcResourcePool.release();
    }

    public Optional<FillInvoker> getFillInvoker(Result result, VespaBackEndSearcher searcher, DocumentDatabase documentDb, FS4InvokerFactory fs4InvokerFactory) {
        Optional<FillInvoker> fs4Invoker;
        Optional<FillInvoker> rpcInvoker = this.rpcResourcePool.getFillInvoker(result.getQuery(), searcher, documentDb);
        if (rpcInvoker.isPresent()) {
            return rpcInvoker;
        }
        if (result.getQuery().properties().getBoolean(dispatchInternal, this.internalDispatchByDefault) && (fs4Invoker = fs4InvokerFactory.getFillInvoker(result)).isPresent()) {
            return fs4Invoker;
        }
        return Optional.empty();
    }

    public Optional<SearchInvoker> getSearchInvoker(Query query, FS4InvokerFactory fs4InvokerFactory) {
        if (this.multilevelDispatch || !query.properties().getBoolean(dispatchInternal, this.internalDispatchByDefault)) {
            return Optional.empty();
        }
        Optional<SearchInvoker> invoker = this.getSearchPathInvoker(query, fs4InvokerFactory::getSearchInvoker);
        if (!invoker.isPresent()) {
            invoker = this.getInternalInvoker(query, fs4InvokerFactory::getSearchInvoker);
        }
        if (invoker.isPresent() && query.properties().getBoolean(Model.ESTIMATE)) {
            query.setHits(0);
            query.setOffset(0);
        }
        return invoker;
    }

    private Optional<SearchInvoker> getSearchPathInvoker(Query query, SearchInvokerSupplier invokerFactory) {
        String searchPath = query.getModel().getSearchPath();
        if (searchPath == null) {
            return Optional.empty();
        }
        try {
            List<Node> nodes = SearchPath.selectNodes(searchPath, this.searchCluster);
            if (nodes.isEmpty()) {
                return Optional.empty();
            }
            query.trace(false, 2, "Dispatching internally with search path ", searchPath);
            return invokerFactory.supply(query, OptionalInt.empty(), nodes, true);
        }
        catch (SearchPath.InvalidSearchPathException e) {
            return Optional.of(new SearchErrorInvoker(ErrorMessage.createIllegalQuery(e.getMessage())));
        }
    }

    private Optional<SearchInvoker> getInternalInvoker(Query query, SearchInvokerSupplier invokerFactory) {
        Optional<Group> groupInCluster;
        Optional<Node> directNode = this.searchCluster.directDispatchTarget();
        if (directNode.isPresent()) {
            Node node = directNode.get();
            query.trace(false, 2, "Dispatching directly to ", node);
            return invokerFactory.supply(query, OptionalInt.empty(), Arrays.asList(node), true);
        }
        int covered = this.searchCluster.groupsWithSufficientCoverage();
        int groups = this.searchCluster.orderedGroups().size();
        int max = Integer.min(Integer.min(covered + 1, groups), 3);
        HashSet<Integer> rejected = null;
        for (int i = 0; i < max && (groupInCluster = this.loadBalancer.takeGroup(rejected)).isPresent(); ++i) {
            Group group = groupInCluster.get();
            boolean acceptIncompleteCoverage = i == max - 1;
            Optional<SearchInvoker> invoker = invokerFactory.supply(query, OptionalInt.of(group.id()), (List<Node>)group.nodes(), acceptIncompleteCoverage);
            if (invoker.isPresent()) {
                query.trace(false, 2, "Dispatching internally to search group ", group.id());
                query.getModel().setSearchPath("/" + group.id());
                invoker.get().teardown((success, time) -> this.loadBalancer.releaseGroup(group, (boolean)success, time.longValue()));
                return invoker;
            }
            this.loadBalancer.releaseGroup(group, false, 0.0);
            if (rejected == null) {
                rejected = new HashSet<Integer>();
            }
            rejected.add(group.id());
        }
        return Optional.empty();
    }

    @FunctionalInterface
    private static interface SearchInvokerSupplier {
        public Optional<SearchInvoker> supply(Query var1, OptionalInt var2, List<Node> var3, boolean var4);
    }
}

