/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.QueryCanonicalizer;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.parser.SimpleParser;
import com.yahoo.prelude.query.parser.Token;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.parser.ParserEnvironment;
import java.util.ListIterator;

public class AllParser
extends SimpleParser {
    public AllParser(ParserEnvironment environment) {
        super(environment);
    }

    @Override
    protected Item parseItems() {
        int position = this.tokens.getPosition();
        try {
            Item item = this.parseItemsBody();
            return item;
        }
        finally {
            this.tokens.setPosition(position);
        }
    }

    protected Item parseItemsBody() {
        AndItem and = null;
        NotItem not = null;
        do {
            Item current;
            if ((current = this.negativeItem()) != null) {
                not = this.addNot(current, not);
                continue;
            }
            current = this.positiveItem();
            if (current == null) {
                current = this.indexableItem();
            }
            if (current == null) {
                current = this.compositeItem();
            }
            if (current != null) {
                and = this.addAnd(current, and);
            }
            if (current != null) continue;
            this.tokens.skip();
        } while (this.tokens.hasNext());
        CompositeItem topLevel = and;
        if (not != null && topLevel != null) {
            not.setPositiveItem(topLevel);
            topLevel = not;
        }
        return this.simplifyUnnecessaryComposites(topLevel);
    }

    protected final Item simplifyUnnecessaryComposites(Item item) {
        if (item == null) {
            return null;
        }
        QueryTree root = new QueryTree(item);
        QueryCanonicalizer.canonicalize(root);
        return root.getRoot() instanceof NullItem ? null : root.getRoot();
    }

    protected AndItem addAnd(Item item, AndItem and) {
        if (and == null) {
            and = new AndItem();
        }
        and.addItem(item);
        return and;
    }

    protected OrItem addOr(Item item, OrItem or) {
        if (or == null) {
            or = new OrItem();
        }
        or.addItem(item);
        return or;
    }

    protected NotItem addNot(Item item, NotItem not) {
        if (not == null) {
            not = new NotItem();
        }
        not.addNegativeItem(item);
        return not;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Item negativeItem() {
        int position = this.tokens.getPosition();
        Item item = null;
        try {
            if (!this.tokens.skipMultiple(Token.Kind.MINUS)) {
                Item item2 = null;
                return item2;
            }
            if (this.tokens.currentIsNoIgnore(Token.Kind.SPACE)) {
                Item item3 = null;
                return item3;
            }
            item = this.indexableItem();
            if (item == null && (item = this.compositeItem()) != null && item instanceof OrItem) {
                AndItem and = new AndItem();
                ListIterator<Item> i = ((OrItem)item).getItemIterator();
                while (i.hasNext()) {
                    and.addItem((Item)i.next());
                }
                item = and;
            }
            if (item != null) {
                item.setProtected(true);
            }
            Item item4 = item;
            return item4;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    @Override
    protected Item combineItems(Item topLevelItem, Item item) {
        if (topLevelItem == null) {
            return item;
        }
        if (topLevelItem instanceof OrItem && item instanceof OrItem) {
            OrItem newTopOr = new OrItem();
            newTopOr.addItem(topLevelItem);
            newTopOr.addItem(item);
            return newTopOr;
        }
        if (item instanceof OrItem && topLevelItem instanceof RankItem) {
            ListIterator<Item> i = ((RankItem)topLevelItem).getItemIterator();
            while (i.hasNext()) {
                ((OrItem)item).addItem(0, (Item)i.next());
            }
            return item;
        }
        if (item instanceof OrItem && topLevelItem instanceof PhraseItem) {
            OrItem newTopOr = new OrItem();
            newTopOr.addItem(topLevelItem);
            newTopOr.addItem(item);
            return newTopOr;
        }
        if (!(topLevelItem instanceof RankItem)) {
            RankItem rank = new RankItem();
            if (topLevelItem instanceof NotItem) {
                rank.addItem(topLevelItem);
                rank.addItem(item);
            } else {
                rank.addItem(item);
                rank.addItem(topLevelItem);
            }
            return rank;
        }
        if (item instanceof RankItem && ((RankItem)item).getItem(0) instanceof OrItem) {
            RankItem itemAsRank = (RankItem)item;
            OrItem or = (OrItem)itemAsRank.getItem(0);
            ((RankItem)topLevelItem).addItem(0, or);
            for (int i = 1; i < itemAsRank.getItemCount(); ++i) {
                or.addItem(0, itemAsRank.getItem(i));
            }
            return topLevelItem;
        }
        ((RankItem)topLevelItem).addItem(0, item);
        return topLevelItem;
    }
}

