/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SimpleTaggableItem;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

public class PredicateQueryItem
extends SimpleTaggableItem {
    private String fieldName = "predicate";
    private ArrayList<Entry> features = new ArrayList();
    private ArrayList<RangeEntry> rangeFeatures = new ArrayList();
    public static final long ALL_SUB_QUERIES = -1L;

    @Override
    public void setIndexName(String index) {
        this.fieldName = index;
    }

    public String getIndexName() {
        return this.fieldName;
    }

    public void addFeature(String key, String value) {
        this.addFeature(key, value, -1L);
    }

    public void addFeature(String key, String value, long subQueryBitmap) {
        this.addFeature(new Entry(key, value, subQueryBitmap));
    }

    public void addFeature(Entry entry) {
        this.features.add(entry);
    }

    public void addRangeFeature(String key, long value) {
        this.addRangeFeature(key, value, -1L);
    }

    public void addRangeFeature(String key, long value, long subQueryBitmap) {
        this.addRangeFeature(new RangeEntry(key, value, subQueryBitmap));
    }

    public void addRangeFeature(RangeEntry entry) {
        this.rangeFeatures.add(entry);
    }

    public Collection<Entry> getFeatures() {
        return this.features;
    }

    public Collection<RangeEntry> getRangeFeatures() {
        return this.rangeFeatures;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.PREDICATE_QUERY;
    }

    @Override
    public String getName() {
        return "PREDICATE_QUERY_ITEM";
    }

    @Override
    public int encode(ByteBuffer buffer) {
        super.encodeThis(buffer);
        PredicateQueryItem.putString(this.fieldName, buffer);
        this.encodeFeatures(this.features, buffer);
        this.encodeFeatures(this.rangeFeatures, buffer);
        return 1;
    }

    private void encodeFeatures(ArrayList<? extends EntryBase> features, ByteBuffer buffer) {
        IntegerCompressor.putCompressedPositiveNumber((int)features.size(), (ByteBuffer)buffer);
        for (EntryBase entryBase : features) {
            entryBase.encode(buffer);
        }
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        boolean first = true;
        for (Entry entry : this.features) {
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(entry.getKey()).append('=').append(entry.getValue());
            if (entry.getSubQueryBitmap() == -1L) continue;
            buffer.append("[0x").append(Long.toHexString(entry.getSubQueryBitmap())).append(']');
        }
        for (RangeEntry rangeEntry : this.rangeFeatures) {
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(rangeEntry.getKey()).append(':').append(rangeEntry.getValue());
            if (rangeEntry.getSubQueryBitmap() == -1L) continue;
            buffer.append("[0x").append(Long.toHexString(rangeEntry.getSubQueryBitmap())).append(']');
        }
    }

    @Override
    public PredicateQueryItem clone() {
        PredicateQueryItem clone = (PredicateQueryItem)super.clone();
        clone.features = new ArrayList<Entry>(this.features);
        clone.rangeFeatures = new ArrayList<RangeEntry>(this.rangeFeatures);
        return clone;
    }

    public static class RangeEntry
    extends EntryBase {
        private long value;

        public RangeEntry(String key, long value) {
            this(key, value, -1L);
        }

        public RangeEntry(String key, long value, long subQueryBitmap) {
            super(key, subQueryBitmap);
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public void encode(ByteBuffer buffer) {
            Item.putString(this.getKey(), buffer);
            buffer.putLong(this.getValue());
            buffer.putLong(this.getSubQueryBitmap());
        }
    }

    public static class Entry
    extends EntryBase {
        private String value;

        public Entry(String key, String value) {
            this(key, value, -1L);
        }

        public Entry(String key, String value, long subQueryBitmap) {
            super(key, subQueryBitmap);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public void encode(ByteBuffer buffer) {
            Item.putString(this.getKey(), buffer);
            Item.putString(this.getValue(), buffer);
            buffer.putLong(this.getSubQueryBitmap());
        }
    }

    public static abstract class EntryBase {
        private String key;
        private long subQueryBitmap;

        public EntryBase(String key, long subQueryBitmap) {
            this.key = key;
            this.subQueryBitmap = subQueryBitmap;
        }

        public String getKey() {
            return this.key;
        }

        public long getSubQueryBitmap() {
            return this.subQueryBitmap;
        }

        public void setSubQueryBitmap(long subQueryBitmap) {
            this.subQueryBitmap = subQueryBitmap;
        }

        public abstract void encode(ByteBuffer var1);
    }
}

