/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.log.LogLevel;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.PacketWrapper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class PacketCache
extends LinkedHashMap<CacheKey, PacketWrapper> {
    private static final long serialVersionUID = -7403077211906108356L;
    private int totalSize;
    private final int capacity;
    private int maxCacheItemPercentage = 1;
    private final long maxAge;
    private static final Logger log = Logger.getLogger(PacketCache.class.getName());

    @Override
    public void clear() {
        super.clear();
        this.totalSize = 0;
    }

    public void setMaxCacheItemPercentage(int maxCapacityPercentage) {
        this.maxCacheItemPercentage = maxCapacityPercentage;
    }

    public PacketCache(int capacityMegaBytes, int capacityBytes, double maxAge) {
        super(12500, 1.0f, true);
        if (maxAge <= 0.0) {
            throw new IllegalArgumentException("maxAge <= 0 not legal on 5.1, use some very large number for no timeout.");
        }
        if (capacityMegaBytes > 2047) {
            log.log(LogLevel.INFO, "Packet cache of more than 2 GB requested. Reverting to 2 GB packet cache.");
            this.capacity = Integer.MAX_VALUE;
        } else {
            this.capacity = (capacityMegaBytes << 20) + capacityBytes;
        }
        if (this.capacity <= 0) {
            throw new IllegalArgumentException("Total cache size set to 0 or less bytes. If no caching is desired, avoid creating this object instead.");
        }
        this.maxAge = (long)(maxAge * 1000.0);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<CacheKey, PacketWrapper> eldest) {
        if (this.totalSize > this.capacity) {
            this.totalSize -= eldest.getValue().getPacketsSize();
            return true;
        }
        return false;
    }

    private void removeOverflow() {
        if (this.totalSize < this.capacity) {
            return;
        }
        Iterator i = this.values().iterator();
        while (i.hasNext()) {
            PacketWrapper eldestEntry = (PacketWrapper)i.next();
            this.totalSize -= eldestEntry.getPacketsSize();
            i.remove();
            if (this.totalSize >= this.capacity) continue;
            break;
        }
    }

    public int getCapacity() {
        return this.capacity >> 20;
    }

    public int getByteCapacity() {
        return this.capacity;
    }

    @Override
    public PacketWrapper put(CacheKey key, PacketWrapper value) {
        return this.put(key, value, System.currentTimeMillis());
    }

    public PacketWrapper put(CacheKey key, PacketWrapper result, long timestamp) {
        int size = result.getPacketsSize();
        if (size > 0) {
            result.setTimestamp(timestamp);
        }
        if (size * 100 > this.capacity * this.maxCacheItemPercentage) {
            return this.remove(key);
        }
        this.totalSize += size;
        PacketWrapper previous = super.put(key, result);
        if (previous != null) {
            this.totalSize -= previous.getPacketsSize();
        }
        if ((double)this.totalSize > (double)this.capacity * 1.1) {
            this.removeOverflow();
        }
        return previous;
    }

    public PacketWrapper get(CacheKey key) {
        return this.get(key, System.currentTimeMillis());
    }

    public PacketWrapper get(CacheKey key, long now) {
        PacketWrapper result = (PacketWrapper)super.get(key);
        if (result == null) {
            return result;
        }
        long timestamp = result.getTimestamp();
        if (now - timestamp > this.maxAge) {
            this.remove(key);
            return null;
        }
        return result;
    }

    public PacketWrapper remove(CacheKey key) {
        PacketWrapper removed = (PacketWrapper)super.remove(key);
        if (removed != null) {
            this.totalSize -= removed.getPacketsSize();
        }
        return removed;
    }

    public int totalPacketSize() {
        return this.totalSize;
    }
}

