/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cluster;

import com.yahoo.container.protect.Error;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.result.ErrorMessage;
import java.util.logging.Logger;

public class NodeMonitor {
    protected static Logger log = Logger.getLogger(NodeMonitor.class.getName());
    private final VespaBackEndSearcher node;
    private boolean isWorking = true;
    private long succeededAt = 0L;
    private boolean searchNodesOnline = false;
    private boolean statusIsKnown = false;

    public NodeMonitor(VespaBackEndSearcher node) {
        this.node = node;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public VespaBackEndSearcher getNode() {
        return this.node;
    }

    public void failed(ErrorMessage error) {
        long respondedAt = System.currentTimeMillis();
        this.statusIsKnown = true;
        if (error.getCode() == Error.NO_ANSWER_WHEN_PINGING_NODE.code) {
            if (respondedAt - this.succeededAt > 10000L) {
                this.searchNodesOnline = false;
                this.setWorking(false, "Not working for 10 s: " + error.toString());
            }
        } else if (error.getCode() == Error.BACKEND_COMMUNICATION_ERROR.code) {
            this.searchNodesOnline = false;
            this.setWorking(false, "Backend communication error: " + error.toString());
        } else {
            this.succeededAt = respondedAt;
        }
    }

    public void responded(boolean searchNodesOnline) {
        this.succeededAt = System.currentTimeMillis();
        this.statusIsKnown = true;
        this.searchNodesOnline = searchNodesOnline;
        if (!this.isWorking) {
            this.setWorking(true, "Responds correctly");
        }
    }

    private void setWorking(boolean working, String explanation) {
        if (this.isWorking == working) {
            return;
        }
        if (this.statusIsKnown) {
            if (working) {
                log.info("Putting " + this.node + " in service: " + explanation);
            } else {
                log.info("Taking " + this.node + " out of service: " + explanation);
            }
        }
        this.isWorking = working;
    }

    boolean searchNodesOnline() {
        return this.searchNodesOnline;
    }

    boolean statusIsKnown() {
        return this.statusIsKnown;
    }
}

