/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cluster;

import com.yahoo.component.provider.Freezable;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.prelude.cluster.ClusterSearcher;
import com.yahoo.prelude.cluster.MonitorConfiguration;
import com.yahoo.prelude.cluster.NodeMonitor;
import com.yahoo.prelude.cluster.QrMonitorConfig;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.result.ErrorMessage;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterMonitor
implements Runnable,
Freezable {
    private static final int pingThreadInitialDelayMs = 3000;
    private final MonitorConfiguration configuration;
    private static final Logger log = Logger.getLogger(ClusterMonitor.class.getName());
    private final ClusterSearcher nodeManager;
    private final Optional<VipStatus> vipStatus;
    private final Map<VespaBackEndSearcher, NodeMonitor> nodeMonitors = new IdentityHashMap<VespaBackEndSearcher, NodeMonitor>();
    private ScheduledFuture<?> future;
    private boolean isFrozen = false;

    ClusterMonitor(ClusterSearcher manager, QrMonitorConfig monitorConfig, Optional<VipStatus> vipStatus) {
        this.configuration = new MonitorConfiguration(monitorConfig);
        this.nodeManager = manager;
        this.vipStatus = vipStatus;
        log.fine("checkInterval is " + this.configuration.getCheckInterval() + " ms");
    }

    MonitorConfiguration getConfiguration() {
        return this.configuration;
    }

    void startPingThread() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("Do not start the monitoring thread before the set of nodes to monitor is complete/the ClusterMonitor is frozen.");
        }
        this.future = this.nodeManager.getScheduledExecutor().scheduleAtFixedRate(this, 3000L, this.configuration.getCheckInterval(), TimeUnit.MILLISECONDS);
    }

    void add(VespaBackEndSearcher node) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Can not add new nodes after ClusterMonitor has been frozen.");
        }
        this.nodeMonitors.put(node, new NodeMonitor(node));
        this.updateVipStatus();
    }

    void failed(VespaBackEndSearcher node, ErrorMessage error) {
        NodeMonitor monitor = this.nodeMonitors.get((Object)node);
        boolean wasWorking = monitor.isWorking();
        monitor.failed(error);
        if (wasWorking && !monitor.isWorking()) {
            log.info("Failed monitoring node '" + node + "' due to '" + error);
            this.nodeManager.failed(node);
        }
        this.updateVipStatus();
    }

    void responded(VespaBackEndSearcher node, boolean hasSearchNodesOnline) {
        NodeMonitor monitor = this.nodeMonitors.get((Object)node);
        boolean wasFailing = !monitor.isWorking();
        monitor.responded(hasSearchNodesOnline);
        if (wasFailing && monitor.isWorking()) {
            log.info("Failed node '" + node + "' started working again.");
            this.nodeManager.working(node);
        }
        this.updateVipStatus();
    }

    private void updateVipStatus() {
        if (!this.vipStatus.isPresent()) {
            return;
        }
        if (!this.hasInformationAboutAllNodes()) {
            return;
        }
        if (this.hasWorkingNodesWithDocumentsOnline()) {
            this.vipStatus.get().addToRotation(this.nodeManager.getId().stringValue());
        } else {
            this.vipStatus.get().removeFromRotation(this.nodeManager.getId().stringValue());
        }
    }

    private boolean hasInformationAboutAllNodes() {
        for (NodeMonitor monitor : this.nodeMonitors.values()) {
            if (monitor.statusIsKnown()) continue;
            return false;
        }
        return true;
    }

    private boolean hasWorkingNodesWithDocumentsOnline() {
        for (NodeMonitor node : this.nodeMonitors.values()) {
            if (!node.isWorking() || !node.searchNodesOnline()) continue;
            return true;
        }
        return false;
    }

    private void ping() throws InterruptedException {
        for (NodeMonitor monitor : this.nodeMonitors.values()) {
            this.nodeManager.ping(monitor.getNode());
        }
    }

    @Override
    public void run() {
        log.finest("Activating ping");
        try {
            this.ping();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error in monitor thread", e);
        }
    }

    public void shutdown() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }
}

