/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4.mplex;

import com.yahoo.io.FatalErrorHandler;
import com.yahoo.io.Listener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ListenerPool {
    private static final Logger logger = Logger.getLogger(ListenerPool.class.getName());
    private final List<Listener> listeners;

    public ListenerPool(String name, int numListeners) {
        this.listeners = new ArrayList<Listener>(numListeners);
        FatalErrorHandler fatalErrorHandler = new FatalErrorHandler();
        for (int i = 0; i < numListeners; ++i) {
            Listener listener = new Listener(name + "-" + i);
            listener.setFatalErrorHandler(fatalErrorHandler);
            listener.start();
            this.listeners.add(listener);
        }
    }

    public Listener get(int index) {
        return this.listeners.get(index);
    }

    public int size() {
        return this.listeners.size();
    }

    public void close() {
        for (Listener listener : this.listeners) {
            listener.interrupt();
        }
        try {
            for (Listener listener : this.listeners) {
                listener.join();
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Got interrupted", e);
            Thread.currentThread().interrupt();
        }
    }
}

