/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import java.nio.ByteBuffer;

public final class QueryPacketData {
    private byte[] rankProfile = null;
    private int queryFlags = 0;
    private byte[] queryStack = null;
    private byte[] location = null;
    private byte[] propertyMaps = null;

    private byte[] copyField(ByteBuffer src, int startOfField) {
        if (startOfField > src.position()) {
            throw new IllegalArgumentException("startOfField after src.position()");
        }
        byte[] dst = new byte[src.position() - startOfField];
        src.position(startOfField);
        src.get(dst);
        return dst;
    }

    ByteBuffer encodeRankProfile(ByteBuffer buffer) {
        return buffer.put(this.rankProfile);
    }

    void setRankProfile(ByteBuffer src, int startOfField) {
        this.rankProfile = this.copyField(src, startOfField);
    }

    ByteBuffer encodeQueryFlags(ByteBuffer buffer) {
        return buffer.putInt(this.queryFlags);
    }

    void setQueryFlags(int queryFlags) {
        this.queryFlags = queryFlags;
    }

    ByteBuffer encodeQueryStack(ByteBuffer buffer) {
        return buffer.put(this.queryStack);
    }

    void setQueryStack(ByteBuffer src, int startOfField) {
        this.queryStack = this.copyField(src, startOfField);
    }

    ByteBuffer encodePropertyMaps(ByteBuffer buffer) {
        if (this.propertyMaps != null) {
            buffer.put(this.propertyMaps);
        }
        return buffer;
    }

    void setPropertyMaps(ByteBuffer src, int startOfField) {
        this.propertyMaps = this.copyField(src, startOfField);
    }

    void setLocation(ByteBuffer src, int startOfField) {
        this.location = this.copyField(src, startOfField);
    }

    ByteBuffer encodeLocation(ByteBuffer buffer) {
        if (this.location != null) {
            buffer.put(this.location);
        }
        return buffer;
    }
}

