/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.BufferTooSmallException;
import com.yahoo.fs4.DocsumPacket;
import com.yahoo.fs4.EolPacket;
import com.yahoo.fs4.ErrorPacket;
import com.yahoo.fs4.PongPacket;
import com.yahoo.fs4.QueryResultPacket;
import java.nio.ByteBuffer;

public class PacketDecoder {
    private PacketDecoder() {
    }

    public static BasicPacket decode(ByteBuffer buffer) {
        int packetCode = buffer.getInt(buffer.position() + 4);
        switch (packetCode &= 0xFFFFFF) {
            case 200: {
                return EolPacket.create().decode(buffer);
            }
            case 203: {
                return ErrorPacket.create().decode(buffer);
            }
            case 205: {
                return DocsumPacket.create().decode(buffer);
            }
            case 217: {
                return QueryResultPacket.create().decode(buffer);
            }
            case 221: {
                return PongPacket.create().decode(buffer);
            }
        }
        throw new IllegalArgumentException("No support for packet " + packetCode);
    }

    public static DecodedPacket decodePacket(ByteBuffer buffer) {
        ByteBuffer dataUsed = buffer.slice();
        int start = buffer.position();
        BasicPacket packet = PacketDecoder.decode(buffer);
        dataUsed.limit(buffer.position() - start);
        return new DecodedPacket(packet, dataUsed);
    }

    public static int sniffChannel(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining < 12) {
            return 0;
        }
        int packetCode = buffer.getInt(buffer.position() + 4);
        switch (packetCode &= 0xFFFFFF) {
            case 202: 
            case 208: 
            case 214: 
            case 217: {
                return buffer.getInt(buffer.position() + 8);
            }
        }
        return 0;
    }

    public static boolean isPongPacket(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining < 8) {
            return false;
        }
        int packetCode = buffer.getInt(buffer.position() + 4);
        return (packetCode &= 0xFFFFFF) == 221;
    }

    public static int packetLength(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return -1;
        }
        return buffer.getInt(buffer.position()) + 4;
    }

    public static DecodedPacket extractPacket(ByteBuffer buffer) throws BufferTooSmallException {
        int remaining = buffer.remaining();
        if (remaining == 0) {
            buffer.clear();
            return null;
        }
        if (remaining < 4) {
            buffer.compact();
            return null;
        }
        int plen = PacketDecoder.packetLength(buffer);
        if (plen == -1) {
            buffer.compact();
            return null;
        }
        if (remaining < plen) {
            if (buffer.capacity() < plen) {
                throw new BufferTooSmallException("Buffer too small to hold packet");
            }
            buffer.compact();
            return null;
        }
        return PacketDecoder.decodePacket(buffer);
    }

    public static class DecodedPacket {
        public BasicPacket packet;
        public ByteBuffer consumedBytes;

        DecodedPacket(BasicPacket packet, ByteBuffer consumedBytes) {
            this.packet = packet;
            this.consumedBytes = consumedBytes;
        }
    }
}

