/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors;

import com.yahoo.vespa.streamingvisitors.tracing.LoggingTraceExporter;
import com.yahoo.vespa.streamingvisitors.tracing.MaxSamplesPerPeriod;
import com.yahoo.vespa.streamingvisitors.tracing.MonotonicNanoClock;
import com.yahoo.vespa.streamingvisitors.tracing.ProbabilisticSampleRate;
import com.yahoo.vespa.streamingvisitors.tracing.SamplingStrategy;
import com.yahoo.vespa.streamingvisitors.tracing.SamplingTraceExporter;
import com.yahoo.vespa.streamingvisitors.tracing.TraceExporter;
import java.util.concurrent.TimeUnit;

public class TracingOptions {
    private final SamplingStrategy samplingStrategy;
    private final TraceExporter traceExporter;
    private final MonotonicNanoClock clock;
    private final int traceLevelOverride;
    private final double traceTimeoutMultiplierThreshold;
    public static final TracingOptions DEFAULT;
    public static final int DEFAULT_TRACE_LEVEL_OVERRIDE = 7;
    public static final double TRACE_TIMEOUT_MULTIPLIER_THRESHOLD = 5.0;

    public TracingOptions(SamplingStrategy samplingStrategy, TraceExporter traceExporter, MonotonicNanoClock clock, int traceLevelOverride, double traceTimeoutMultiplierThreshold) {
        this.samplingStrategy = samplingStrategy;
        this.traceExporter = traceExporter;
        this.clock = clock;
        this.traceLevelOverride = traceLevelOverride;
        this.traceTimeoutMultiplierThreshold = traceTimeoutMultiplierThreshold;
    }

    public SamplingStrategy getSamplingStrategy() {
        return this.samplingStrategy;
    }

    public TraceExporter getTraceExporter() {
        return this.traceExporter;
    }

    public MonotonicNanoClock getClock() {
        return this.clock;
    }

    public int getTraceLevelOverride() {
        return this.traceLevelOverride;
    }

    public double getTraceTimeoutMultiplierThreshold() {
        return this.traceTimeoutMultiplierThreshold;
    }

    static {
        ProbabilisticSampleRate queryTraceSampler = ProbabilisticSampleRate.withSystemDefaults(0.5);
        MaxSamplesPerPeriod logExportSampler = MaxSamplesPerPeriod.withSteadyClock(TimeUnit.SECONDS.toNanos(10L), 1L);
        SamplingTraceExporter traceExporter = new SamplingTraceExporter(new LoggingTraceExporter(), logExportSampler);
        DEFAULT = new TracingOptions(queryTraceSampler, traceExporter, System::nanoTime, 7, 5.0);
    }
}

