/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.data.JsonProducer;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.JsonRender;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class FeatureData
implements Inspectable,
JsonProducer {
    private final Inspector value;
    private Set<String> featureNames = null;
    private String jsonForm = null;

    public FeatureData(Inspector value) {
        this.value = value;
    }

    public Inspector inspect() {
        return this.value;
    }

    @Override
    public String toJson() {
        if (this.jsonForm != null) {
            return this.jsonForm;
        }
        this.jsonForm = this.writeJson(new StringBuilder()).toString();
        return this.jsonForm;
    }

    @Override
    public StringBuilder writeJson(StringBuilder target) {
        return JsonRender.render((Inspectable)this.value, (JsonRender.StringEncoder)new Encoder(target, true));
    }

    public Double getDouble(String featureName) {
        Inspector featureValue = this.value.field(featureName);
        if (!featureValue.valid()) {
            return null;
        }
        switch (featureValue.type()) {
            case DOUBLE: {
                return featureValue.asDouble();
            }
            case DATA: {
                throw new IllegalArgumentException("Feature '" + featureName + "' is a tensor, not a double");
            }
        }
        throw new IllegalStateException("Unexpected feature value type " + featureValue.type());
    }

    public Tensor getTensor(String featureName) {
        Inspector featureValue = this.value.field(featureName);
        if (!featureValue.valid()) {
            return null;
        }
        switch (featureValue.type()) {
            case DOUBLE: {
                return Tensor.from((double)featureValue.asDouble());
            }
            case DATA: {
                return TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])featureValue.asData()));
            }
        }
        throw new IllegalStateException("Unexpected feature value type " + featureValue.type());
    }

    public Set<String> featureNames() {
        if (this.featureNames != null) {
            return this.featureNames;
        }
        this.featureNames = new HashSet<String>();
        this.value.fields().forEach(field -> this.featureNames.add((String)field.getKey()));
        return this.featureNames;
    }

    public String toString() {
        if (this.value.type() == Type.EMPTY) {
            return "";
        }
        return this.toJson();
    }

    public int hashCode() {
        return this.toJson().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FeatureData)) {
            return false;
        }
        return ((FeatureData)other).toJson().equals(this.toJson());
    }

    private static class Encoder
    extends JsonRender.StringEncoder {
        Encoder(StringBuilder out, boolean compact) {
            super(out, compact);
        }

        public void encodeDATA(byte[] value) {
            this.target().append(new String(JsonFormat.encodeWithType((Tensor)TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])value))), StandardCharsets.UTF_8));
        }
    }
}

