/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.FreezableSimpleComponent;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileFieldType;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;
import com.yahoo.text.Lowercase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryProfileType
extends FreezableSimpleComponent {
    private final CompoundName componentIdAsCompoundName;
    private Map<String, FieldDescription> fields;
    private List<QueryProfileType> inherited;
    private boolean strict = false;
    private boolean matchAsPath = false;
    private boolean builtin = false;
    private Map<String, String> aliases = null;

    public QueryProfileType(String idString) {
        this(new ComponentId(idString));
    }

    public QueryProfileType(ComponentId id) {
        this(id, new HashMap<String, FieldDescription>(), new ArrayList<QueryProfileType>());
    }

    private QueryProfileType(ComponentId id, Map<String, FieldDescription> fields, List<QueryProfileType> inherited) {
        super(id);
        QueryProfile.validateName(id.getName());
        this.componentIdAsCompoundName = new CompoundName(this.getId().getName());
        this.fields = fields;
        this.inherited = inherited;
    }

    private QueryProfileType(ComponentId id, Map<String, FieldDescription> fields, List<QueryProfileType> inherited, boolean strict, boolean matchAsPath, boolean builtin, Map<String, String> aliases) {
        this(id, new HashMap<String, FieldDescription>(fields), new ArrayList<QueryProfileType>(inherited));
        this.strict = strict;
        this.matchAsPath = matchAsPath;
        this.builtin = builtin;
        this.aliases = aliases == null ? null : new HashMap<String, String>(aliases);
    }

    public QueryProfileType unfrozen() {
        if (!this.isFrozen()) {
            return this;
        }
        ArrayList<QueryProfileType> unfrozenInherited = new ArrayList<QueryProfileType>();
        for (QueryProfileType inheritedType : this.inherited) {
            unfrozenInherited.add(inheritedType.unfrozen());
        }
        HashMap<String, FieldDescription> unfrozenFields = new HashMap<String, FieldDescription>();
        for (Map.Entry<String, FieldDescription> field : this.fields.entrySet()) {
            QueryProfileFieldType queryProfileFieldType;
            FieldDescription unfrozenFieldValue = field.getValue();
            if (field.getValue().getType() instanceof QueryProfileFieldType && (queryProfileFieldType = (QueryProfileFieldType)field.getValue().getType()).getQueryProfileType() != null) {
                QueryProfileFieldType unfrozenType = new QueryProfileFieldType(queryProfileFieldType.getQueryProfileType().unfrozen());
                unfrozenFieldValue = field.getValue().withType(unfrozenType);
            }
            unfrozenFields.put(field.getKey(), unfrozenFieldValue);
        }
        return new QueryProfileType(this.getId(), unfrozenFields, unfrozenInherited, this.strict, this.matchAsPath, this.builtin, this.aliases);
    }

    public CompoundName getComponentIdAsCompoundName() {
        return this.componentIdAsCompoundName;
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public List<QueryProfileType> inherited() {
        return this.inherited;
    }

    public Map<String, FieldDescription> declaredFields() {
        this.ensureNotFrozen();
        return Collections.unmodifiableMap(this.fields);
    }

    public boolean isDeclaredStrict() {
        this.ensureNotFrozen();
        return this.strict;
    }

    public boolean getDeclaredMatchAsPath() {
        this.ensureNotFrozen();
        return this.matchAsPath;
    }

    public void setStrict(boolean strict) {
        this.ensureNotFrozen();
        this.strict = strict;
    }

    public boolean isStrict() {
        if (this.isFrozen()) {
            return this.strict;
        }
        if (this.strict) {
            return true;
        }
        for (QueryProfileType inheritedType : this.inherited) {
            if (!inheritedType.isStrict()) continue;
            return true;
        }
        return false;
    }

    public void setMatchAsPath(boolean matchAsPath) {
        this.ensureNotFrozen();
        this.matchAsPath = matchAsPath;
    }

    public boolean getMatchAsPath() {
        if (this.isFrozen()) {
            return this.matchAsPath;
        }
        if (this.matchAsPath) {
            return true;
        }
        for (QueryProfileType inheritedType : this.inherited) {
            if (!inheritedType.getMatchAsPath()) continue;
            return true;
        }
        return false;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        for (QueryProfileType inheritedType : this.inherited) {
            for (FieldDescription field : inheritedType.fields().values()) {
                if (this.fields.containsKey(field.getName())) continue;
                this.fields.put(field.getName(), field);
            }
        }
        this.fields = ImmutableMap.copyOf(this.fields);
        this.inherited = ImmutableList.copyOf(this.inherited);
        this.strict = this.isStrict();
        this.matchAsPath = this.getMatchAsPath();
        super.freeze();
    }

    public boolean isOverridable(String fieldName) {
        FieldDescription field = this.getField(fieldName);
        if (field == null) {
            return true;
        }
        return field.isOverridable();
    }

    public Class<?> getValueClass(String name) {
        FieldDescription fieldDescription = this.getField(name);
        if (fieldDescription == null) {
            if (this.strict) {
                return null;
            }
            return Object.class;
        }
        return fieldDescription.getType().getValueClass();
    }

    public QueryProfileType getType(String localName) {
        FieldDescription fieldDescription = this.getField(localName);
        if (fieldDescription == null) {
            return null;
        }
        if (!(fieldDescription.getType() instanceof QueryProfileFieldType)) {
            return null;
        }
        return ((QueryProfileFieldType)fieldDescription.getType()).getQueryProfileType();
    }

    public FieldDescription getField(String name) {
        FieldDescription field = this.fields.get(name);
        if (field != null) {
            return field;
        }
        if (this.isFrozen()) {
            return null;
        }
        for (QueryProfileType inheritedType : this.inherited()) {
            field = inheritedType.getField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public FieldDescription removeField(String fieldName) {
        this.ensureNotFrozen();
        return this.fields.remove(fieldName);
    }

    public void addField(FieldDescription fieldDescription) {
        if (fieldDescription.getCompoundName().isCompound()) {
            throw new IllegalArgumentException("Adding compound names is only legal when supplying a registry");
        }
        this.addField(fieldDescription, null);
    }

    public void addField(FieldDescription fieldDescription, QueryProfileTypeRegistry registry) {
        CompoundName name = fieldDescription.getCompoundName();
        if (name.isCompound()) {
            QueryProfileType type = this.getOrCreateQueryProfileType(name.first(), registry);
            type.addField(fieldDescription.withName(name.rest()), registry);
        } else {
            this.ensureNotFrozen();
            this.fields.put(fieldDescription.getName(), fieldDescription);
        }
        for (String alias : fieldDescription.getAliases()) {
            this.addAlias(alias, fieldDescription.getName());
        }
    }

    private QueryProfileType getOrCreateQueryProfileType(String name, QueryProfileTypeRegistry registry) {
        FieldDescription fieldDescription = this.getField(name);
        if (fieldDescription != null) {
            if (!(fieldDescription.getType() instanceof QueryProfileFieldType)) {
                throw new IllegalArgumentException("Cannot use name '" + name + "' as a prefix because it is already a " + fieldDescription.getType());
            }
            QueryProfileFieldType fieldType = (QueryProfileFieldType)fieldDescription.getType();
            QueryProfileType type = fieldType.getQueryProfileType();
            if (type == null) {
                type = new QueryProfileType(name);
                registry.register(type.getId(), (Object)type);
                this.fields.put(name, fieldDescription.withType(new QueryProfileFieldType(type)));
            }
            return type;
        }
        QueryProfileType type = new QueryProfileType(name);
        registry.register(type.getId(), (Object)type);
        this.fields.put(name, new FieldDescription(name, new QueryProfileFieldType(type)));
        return type;
    }

    private void addAlias(String alias, String field) {
        this.ensureNotFrozen();
        if (this.aliases == null) {
            this.aliases = new HashMap<String, String>();
        }
        this.aliases.put(Lowercase.toLowerCase((String)alias), field);
    }

    public Map<String, FieldDescription> fields() {
        if (this.isFrozen()) {
            return this.fields;
        }
        if (this.inherited().size() == 0) {
            return Collections.unmodifiableMap(this.fields);
        }
        HashMap<String, FieldDescription> allFields = new HashMap<String, FieldDescription>(this.fields);
        for (QueryProfileType inheritedType : this.inherited) {
            allFields.putAll(inheritedType.fields());
        }
        return Collections.unmodifiableMap(allFields);
    }

    public Map<String, String> aliases() {
        if (this.isFrozen()) {
            return this.aliases;
        }
        if (this.aliases == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.aliases);
    }

    public String unalias(String aliasOrField) {
        if (this.aliases == null || this.aliases.isEmpty()) {
            return aliasOrField;
        }
        String field = this.aliases.get(Lowercase.toLowerCase((String)aliasOrField));
        if (field != null) {
            return field;
        }
        return aliasOrField;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryProfileType)) {
            return false;
        }
        QueryProfileType other = (QueryProfileType)((Object)o);
        return other.getId().equals((Object)this.getId());
    }

    public String toString() {
        return "query profile type '" + this.getId() + "'";
    }
}

