/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.prelude.Pong;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.InvokerFactory;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.rpc.RpcFillInvoker;
import com.yahoo.search.dispatch.rpc.RpcPing;
import com.yahoo.search.dispatch.rpc.RpcProtobufFillInvoker;
import com.yahoo.search.dispatch.rpc.RpcResourcePool;
import com.yahoo.search.dispatch.rpc.RpcSearchInvoker;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.PingFactory;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import java.util.Optional;
import java.util.concurrent.Callable;

public class RpcInvokerFactory
extends InvokerFactory
implements PingFactory {
    private static final CompoundName dispatchSummaries = new CompoundName("dispatch.summaries");
    private final RpcResourcePool rpcResourcePool;

    public RpcInvokerFactory(RpcResourcePool rpcResourcePool, SearchCluster searchCluster) {
        super(searchCluster);
        this.rpcResourcePool = rpcResourcePool;
    }

    @Override
    protected Optional<SearchInvoker> createNodeSearchInvoker(VespaBackEndSearcher searcher, Query query, Node node) {
        return Optional.of(new RpcSearchInvoker(searcher, node, this.rpcResourcePool));
    }

    @Override
    public Optional<FillInvoker> createFillInvoker(VespaBackEndSearcher searcher, Result result) {
        Query query = result.getQuery();
        boolean summaryNeedsQuery = searcher.summaryNeedsQuery(query);
        boolean useProtoBuf = query.properties().getBoolean(Dispatcher.dispatchProtobuf, true);
        boolean useDispatchDotSummaries = query.properties().getBoolean(dispatchSummaries, false);
        return (useDispatchDotSummaries || !useProtoBuf) && !summaryNeedsQuery ? Optional.of(new RpcFillInvoker(this.rpcResourcePool, searcher.getDocumentDatabase(query))) : Optional.of(new RpcProtobufFillInvoker(this.rpcResourcePool, searcher.getDocumentDatabase(query), searcher.getServerId(), summaryNeedsQuery));
    }

    public FillInvoker createFillInvoker(DocumentDatabase documentDb) {
        return new RpcFillInvoker(this.rpcResourcePool, documentDb);
    }

    @Override
    public void release() {
        this.rpcResourcePool.release();
    }

    @Override
    public Callable<Pong> createPinger(Node node, ClusterMonitor<Node> monitor) {
        return new RpcPing(node, monitor, this.rpcResourcePool);
    }
}

