/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yahoo.data.access.simple.Value;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.InvokerResult;
import com.yahoo.search.dispatch.LeanHit;
import com.yahoo.search.dispatch.rpc.MapConverter;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.Coverage;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Inspector;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ProtobufSerialization {
    private static final int INITIAL_SERIALIZATION_BUFFER_SIZE = 10240;

    static byte[] serializeSearchRequest(Query query, String serverId) {
        return ProtobufSerialization.convertFromQuery(query, serverId).toByteArray();
    }

    private static SearchProtocol.SearchRequest convertFromQuery(Query query, String serverId) {
        SearchProtocol.SearchRequest.Builder builder = SearchProtocol.SearchRequest.newBuilder().setHits(query.getHits()).setOffset(query.getOffset()).setTimeout((int)query.getTimeLeft());
        String documentDb = query.getModel().getDocumentDb();
        if (documentDb != null) {
            builder.setDocumentType(documentDb);
        }
        builder.setQueryTreeBlob(ProtobufSerialization.serializeQueryTree(query.getModel().getQueryTree()));
        if (query.getGroupingSessionCache() || query.getRanking().getQueryCache()) {
            builder.setSessionKey(query.getSessionId(serverId).toString());
        }
        if (query.properties().getBoolean(Model.ESTIMATE)) {
            builder.setHits(0);
        }
        if (GroupingExecutor.hasGroupingList(query)) {
            List<Grouping> groupingList = GroupingExecutor.getGroupingList(query);
            BufferSerializer gbuf = new BufferSerializer(new GrowableByteBuffer());
            gbuf.putInt(null, groupingList.size());
            for (Grouping g : groupingList) {
                g.serialize((Serializer)gbuf);
            }
            gbuf.getBuf().flip();
            builder.setGroupingBlob(ByteString.copyFrom((ByteBuffer)gbuf.getBuf().getByteBuffer()));
        }
        if (query.getGroupingSessionCache()) {
            builder.setCacheGrouping(true);
        }
        builder.setTraceLevel(ProtobufSerialization.getTraceLevelForBackend(query));
        ProtobufSerialization.mergeToSearchRequestFromRanking(query.getRanking(), builder);
        return builder.build();
    }

    public static int getTraceLevelForBackend(Query query) {
        int traceLevel = query.getTraceLevel();
        if (query.getModel().getExecution().trace().getForceTimestamps()) {
            traceLevel = Math.max(traceLevel, 5);
        }
        if (query.getExplainLevel() > 0) {
            traceLevel = Math.max(traceLevel, query.getExplainLevel() + 5);
        }
        return traceLevel;
    }

    private static void mergeToSearchRequestFromRanking(Ranking ranking, SearchProtocol.SearchRequest.Builder builder) {
        builder.setRankProfile(ranking.getProfile());
        if (ranking.getQueryCache()) {
            builder.setCacheQuery(true);
        }
        if (ranking.getSorting() != null) {
            ProtobufSerialization.mergeToSearchRequestFromSorting(ranking.getSorting(), builder);
        }
        if (ranking.getLocation() != null) {
            builder.setGeoLocation(ranking.getLocation().toString());
        }
        Map<String, Object> featureMap = ranking.getFeatures().asMap();
        MapConverter.convertMapPrimitives(featureMap, arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addFeatureOverrides(arg_0));
        MapConverter.convertMapTensors(featureMap, arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addTensorFeatureOverrides(arg_0));
        ProtobufSerialization.mergeRankProperties(ranking, arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addRankProperties(arg_0), arg_0 -> ((SearchProtocol.SearchRequest.Builder)builder).addTensorRankProperties(arg_0));
    }

    private static void mergeToSearchRequestFromSorting(Sorting sorting, SearchProtocol.SearchRequest.Builder builder) {
        for (Sorting.FieldOrder field : sorting.fieldOrders()) {
            SearchProtocol.SortField sortField = SearchProtocol.SortField.newBuilder().setField(field.getSorter().toSerialForm()).setAscending(field.getSortOrder() == Sorting.Order.ASCENDING).build();
            builder.addSorting(sortField);
        }
    }

    static SearchProtocol.DocsumRequest.Builder createDocsumRequestBuilder(Query query, String serverId, String summaryClass, boolean includeQueryData) {
        Ranking ranking;
        String documentDb;
        SearchProtocol.DocsumRequest.Builder builder = SearchProtocol.DocsumRequest.newBuilder().setTimeout((int)query.getTimeLeft()).setDumpFeatures(query.properties().getBoolean(Ranking.RANKFEATURES, false));
        if (summaryClass != null) {
            builder.setSummaryClass(summaryClass);
        }
        if ((documentDb = query.getModel().getDocumentDb()) != null) {
            builder.setDocumentType(documentDb);
        }
        if ((ranking = query.getRanking()).getQueryCache()) {
            builder.setCacheQuery(true);
            builder.setSessionKey(query.getSessionId(serverId).toString());
        }
        builder.setRankProfile(ranking.getProfile());
        if (ranking.getLocation() != null) {
            builder.setGeoLocation(ranking.getLocation().toString());
        }
        if (includeQueryData) {
            ProtobufSerialization.mergeQueryDataToDocsumRequest(query, builder);
        }
        if (query.getTraceLevel() >= 3) {
            query.trace((includeQueryData ? "ProtoBuf: Resending " : "Not resending ") + "query during document summary fetching", 3);
        }
        return builder;
    }

    static byte[] serializeDocsumRequest(SearchProtocol.DocsumRequest.Builder builder, List<FastHit> documents) {
        builder.clearGlobalIds();
        for (FastHit hit : documents) {
            builder.addGlobalIds(ByteString.copyFrom((byte[])hit.getRawGlobalId()));
        }
        return builder.build().toByteArray();
    }

    private static void mergeQueryDataToDocsumRequest(Query query, SearchProtocol.DocsumRequest.Builder builder) {
        Ranking ranking = query.getRanking();
        Map<String, Object> featureMap = ranking.getFeatures().asMap();
        builder.setQueryTreeBlob(ProtobufSerialization.serializeQueryTree(query.getModel().getQueryTree()));
        MapConverter.convertMapPrimitives(featureMap, arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addFeatureOverrides(arg_0));
        MapConverter.convertMapTensors(featureMap, arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addTensorFeatureOverrides(arg_0));
        if (query.getPresentation().getHighlight() != null) {
            MapConverter.convertStringMultiMap(query.getPresentation().getHighlight().getHighlightTerms(), arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addHighlightTerms(arg_0));
        }
        ProtobufSerialization.mergeRankProperties(ranking, arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addRankProperties(arg_0), arg_0 -> ((SearchProtocol.DocsumRequest.Builder)builder).addTensorRankProperties(arg_0));
    }

    static byte[] serializeResult(Result searchResult) {
        return ProtobufSerialization.convertFromResult(searchResult).toByteArray();
    }

    static InvokerResult deserializeToSearchResult(byte[] payload, Query query, VespaBackEndSearcher searcher, int partId, int distKey) throws InvalidProtocolBufferException {
        SearchProtocol.SearchReply protobuf = SearchProtocol.SearchReply.parseFrom((byte[])payload);
        return ProtobufSerialization.convertToResult(query, protobuf, searcher.getDocumentDatabase(query), partId, distKey);
    }

    static InvokerResult convertToResult(Query query, SearchProtocol.SearchReply protobuf, DocumentDatabase documentDatabase, int partId, int distKey) {
        boolean haveGrouping;
        InvokerResult result = new InvokerResult(query, protobuf.getHitsCount());
        result.getResult().setTotalHitCount(protobuf.getTotalHitCount());
        result.getResult().setCoverage(ProtobufSerialization.convertToCoverage(protobuf));
        boolean bl = haveGrouping = protobuf.getGroupingBlob() != null && !protobuf.getGroupingBlob().isEmpty();
        if (haveGrouping) {
            BufferSerializer buf = new BufferSerializer(new GrowableByteBuffer(protobuf.getGroupingBlob().asReadOnlyByteBuffer()));
            int cnt = buf.getInt(null);
            ArrayList<Grouping> list = new ArrayList<Grouping>(cnt);
            for (int i = 0; i < cnt; ++i) {
                Grouping g = new Grouping();
                g.deserialize((Deserializer)buf);
                list.add(g);
            }
            GroupingListHit hit = new GroupingListHit(list, documentDatabase.getDocsumDefinitionSet());
            hit.setQuery(query);
            result.getResult().hits().add(hit);
        }
        for (SearchProtocol.Hit replyHit : protobuf.getHitsList()) {
            LeanHit hit = replyHit.getSortData().isEmpty() ? new LeanHit(replyHit.getGlobalId().toByteArray(), partId, distKey, replyHit.getRelevance()) : new LeanHit(replyHit.getGlobalId().toByteArray(), partId, distKey, replyHit.getSortData().toByteArray());
            result.getLeanHits().add(hit);
        }
        ByteString slimeTrace = protobuf.getSlimeTrace();
        if (slimeTrace != null && !slimeTrace.isEmpty()) {
            Value.ArrayValue traces = new Value.ArrayValue();
            traces.add((com.yahoo.data.access.Inspector)new SlimeAdapter((Inspector)BinaryFormat.decode((byte[])slimeTrace.toByteArray()).get()));
            query.trace(traces, query.getTraceLevel());
        }
        return result;
    }

    private static Coverage convertToCoverage(SearchProtocol.SearchReply protobuf) {
        Coverage coverage = new Coverage(protobuf.getCoverageDocs(), protobuf.getActiveDocs(), 1);
        coverage.setNodesTried(1).setSoonActive(protobuf.getSoonActiveDocs());
        int degradedReason = 0;
        if (protobuf.getDegradedByMatchPhase()) {
            degradedReason |= 1;
        }
        if (protobuf.getDegradedBySoftTimeout()) {
            degradedReason |= 2;
        }
        coverage.setDegradedReason(degradedReason);
        return coverage;
    }

    private static SearchProtocol.SearchReply convertFromResult(Result result) {
        SearchProtocol.SearchReply.Builder builder = SearchProtocol.SearchReply.newBuilder();
        Coverage coverage = result.getCoverage(false);
        if (coverage != null) {
            builder.setCoverageDocs(coverage.getDocs()).setActiveDocs(coverage.getActive()).setSoonActiveDocs(coverage.getSoonActive()).setDegradedBySoftTimeout(coverage.isDegradedByTimeout()).setDegradedByMatchPhase(coverage.isDegradedByMatchPhase());
        }
        result.hits().iterator().forEachRemaining(hit -> {
            SearchProtocol.Hit.Builder hitBuilder = SearchProtocol.Hit.newBuilder();
            if (hit.getRelevance() != null) {
                hitBuilder.setRelevance(hit.getRelevance().getScore());
            }
            if (hit instanceof FastHit) {
                FastHit fhit = (FastHit)hit;
                hitBuilder.setGlobalId(ByteString.copyFrom((byte[])fhit.getRawGlobalId()));
            }
            builder.addHits(hitBuilder);
        });
        return builder.build();
    }

    private static ByteString serializeQueryTree(QueryTree queryTree) {
        int bufferSize = 10240;
        while (true) {
            try {
                ByteBuffer treeBuffer = ByteBuffer.allocate(bufferSize);
                queryTree.encode(treeBuffer);
                treeBuffer.flip();
                return ByteString.copyFrom((ByteBuffer)treeBuffer);
            }
            catch (BufferOverflowException e) {
                bufferSize *= 2;
                continue;
            }
            break;
        }
    }

    private static void mergeRankProperties(Ranking ranking, Consumer<SearchProtocol.StringProperty.Builder> stringProperties, Consumer<SearchProtocol.TensorProperty.Builder> tensorProperties) {
        MapConverter.convertMultiMap(ranking.getProperties().asMap(), propB -> {
            if (!"sessionId".equals(propB.getName())) {
                stringProperties.accept((SearchProtocol.StringProperty.Builder)propB);
            }
        }, tensorProperties);
    }
}

