/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ClusterInfoConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.jdisc.Metric;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.InvokerFactory;
import com.yahoo.search.dispatch.LoadBalancer;
import com.yahoo.search.dispatch.SearchErrorInvoker;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.SearchPath;
import com.yahoo.search.dispatch.rpc.RpcInvokerFactory;
import com.yahoo.search.dispatch.rpc.RpcResourcePool;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.PingFactory;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class Dispatcher
extends AbstractComponent {
    public static final String DISPATCH = "dispatch";
    private static final String INTERNAL = "internal";
    private static final String PROTOBUF = "protobuf";
    private static final String FDISPATCH_METRIC = "dispatch_fdispatch";
    private static final String INTERNAL_METRIC = "dispatch_internal";
    private static final int MAX_GROUP_SELECTION_ATTEMPTS = 3;
    public static final CompoundName dispatchProtobuf = CompoundName.fromComponents((String[])new String[]{"dispatch", "protobuf"});
    private final SearchCluster searchCluster;
    private final LoadBalancer loadBalancer;
    private final boolean multilevelDispatch;
    private final InvokerFactory invokerFactory;
    private final Metric metric;
    private final Metric.Context metricContext;
    private static final QueryProfileType argumentType = new QueryProfileType("dispatch");

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    @Inject
    public Dispatcher(ComponentId clusterId, DispatchConfig dispatchConfig, ClusterInfoConfig clusterInfoConfig, VipStatus vipStatus, Metric metric) {
        this(new SearchCluster(clusterId.stringValue(), dispatchConfig, clusterInfoConfig.nodeCount(), vipStatus), dispatchConfig, metric);
    }

    private Dispatcher(SearchCluster searchCluster, DispatchConfig dispatchConfig, Metric metric) {
        this(searchCluster, dispatchConfig, new RpcInvokerFactory(new RpcResourcePool(dispatchConfig), searchCluster), metric);
    }

    protected Dispatcher(SearchCluster searchCluster, DispatchConfig dispatchConfig, RpcInvokerFactory rcpInvokerFactory, Metric metric) {
        this(searchCluster, dispatchConfig, rcpInvokerFactory, rcpInvokerFactory, metric);
    }

    protected Dispatcher(SearchCluster searchCluster, DispatchConfig dispatchConfig, InvokerFactory invokerFactory, PingFactory pingFactory, Metric metric) {
        this.searchCluster = searchCluster;
        this.loadBalancer = new LoadBalancer(searchCluster, dispatchConfig.distributionPolicy() == DispatchConfig.DistributionPolicy.ROUNDROBIN);
        this.invokerFactory = invokerFactory;
        this.multilevelDispatch = dispatchConfig.useMultilevelDispatch();
        this.metric = metric;
        this.metricContext = metric.createContext(null);
        searchCluster.startClusterMonitoring(pingFactory);
    }

    public SearchCluster searchCluster() {
        return this.searchCluster;
    }

    public void deconstruct() {
        this.invokerFactory.release();
        this.searchCluster.shutDown();
    }

    public Optional<FillInvoker> getFillInvoker(Result result, VespaBackEndSearcher searcher) {
        return this.invokerFactory.createFillInvoker(searcher, result);
    }

    public Optional<SearchInvoker> getSearchInvoker(Query query, VespaBackEndSearcher searcher) {
        if (this.multilevelDispatch) {
            this.emitDispatchMetric(Optional.empty());
            return Optional.empty();
        }
        Optional<SearchInvoker> invoker = this.getSearchPathInvoker(query, searcher);
        if (invoker.isEmpty()) {
            invoker = this.getInternalInvoker(query, searcher);
        }
        if (invoker.isPresent() && query.properties().getBoolean(Model.ESTIMATE)) {
            query.setHits(0);
            query.setOffset(0);
        }
        this.emitDispatchMetric(invoker);
        return invoker;
    }

    private Optional<SearchInvoker> getSearchPathInvoker(Query query, VespaBackEndSearcher searcher) {
        String searchPath = query.getModel().getSearchPath();
        if (searchPath == null) {
            return Optional.empty();
        }
        try {
            List<Node> nodes = SearchPath.selectNodes(searchPath, this.searchCluster);
            if (nodes.isEmpty()) {
                return Optional.empty();
            }
            query.trace(false, 2, "Dispatching internally with search path ", searchPath);
            return this.invokerFactory.createSearchInvoker(searcher, query, OptionalInt.empty(), nodes, true);
        }
        catch (SearchPath.InvalidSearchPathException e) {
            return Optional.of(new SearchErrorInvoker(ErrorMessage.createIllegalQuery(e.getMessage())));
        }
    }

    private Optional<SearchInvoker> getInternalInvoker(Query query, VespaBackEndSearcher searcher) {
        Optional<Group> groupInCluster;
        Optional<Node> directNode = this.searchCluster.localCorpusDispatchTarget();
        if (directNode.isPresent()) {
            Node node = directNode.get();
            query.trace(false, 2, "Dispatching directly to ", node);
            return this.invokerFactory.createSearchInvoker(searcher, query, OptionalInt.empty(), Arrays.asList(node), true);
        }
        int covered = this.searchCluster.groupsWithSufficientCoverage();
        int groups = this.searchCluster.orderedGroups().size();
        int max = Integer.min(Integer.min(covered + 1, groups), 3);
        HashSet<Integer> rejected = null;
        for (int i = 0; i < max && !(groupInCluster = this.loadBalancer.takeGroup(rejected)).isEmpty(); ++i) {
            Group group = groupInCluster.get();
            boolean acceptIncompleteCoverage = i == max - 1;
            Optional<SearchInvoker> invoker = this.invokerFactory.createSearchInvoker(searcher, query, OptionalInt.of(group.id()), (List<Node>)group.nodes(), acceptIncompleteCoverage);
            if (invoker.isPresent()) {
                query.trace(false, 2, "Dispatching internally to search group ", group.id());
                query.getModel().setSearchPath("/" + group.id());
                invoker.get().teardown((success, time) -> this.loadBalancer.releaseGroup(group, (boolean)success, time.longValue()));
                return invoker;
            }
            this.loadBalancer.releaseGroup(group, false, 0.0);
            if (rejected == null) {
                rejected = new HashSet<Integer>();
            }
            rejected.add(group.id());
        }
        return Optional.empty();
    }

    private void emitDispatchMetric(Optional<SearchInvoker> invoker) {
        if (invoker.isEmpty()) {
            this.metric.add(FDISPATCH_METRIC, (Number)1, this.metricContext);
        } else {
            this.metric.add(INTERNAL_METRIC, (Number)1, this.metricContext);
        }
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(INTERNAL, FieldType.booleanType));
        argumentType.addField(new FieldDescription(PROTOBUF, FieldType.booleanType));
        argumentType.freeze();
    }
}

