/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.search.cluster.BaseNodeMonitor;
import com.yahoo.search.cluster.MonitorConfiguration;
import com.yahoo.search.cluster.NodeManager;
import com.yahoo.search.cluster.TrafficNodeMonitor;
import com.yahoo.search.result.ErrorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterMonitor<T> {
    private final MonitorConfiguration configuration = new MonitorConfiguration();
    private static Logger log = Logger.getLogger(ClusterMonitor.class.getName());
    private final NodeManager<T> nodeManager;
    private final MonitorThread monitorThread;
    private volatile boolean shutdown = false;
    private final Map<T, TrafficNodeMonitor<T>> nodeMonitors = Collections.synchronizedMap(new LinkedHashMap());

    public ClusterMonitor(NodeManager<T> manager) {
        this.nodeManager = manager;
        this.monitorThread = new MonitorThread("search.clustermonitor");
        this.monitorThread.start();
    }

    public MonitorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void add(T node, boolean internal) {
        this.nodeMonitors.put(node, new TrafficNodeMonitor<T>(node, this.configuration, internal));
    }

    public BaseNodeMonitor<T> getNodeMonitor(T node) {
        return this.nodeMonitors.get(node);
    }

    public synchronized void failed(T node, ErrorMessage error) {
        TrafficNodeMonitor<T> monitor = this.nodeMonitors.get(node);
        Boolean wasWorking = monitor.isKnownWorking();
        monitor.failed(error);
        if (wasWorking != monitor.isKnownWorking()) {
            this.nodeManager.failed(node);
        }
    }

    public synchronized void responded(T node) {
        TrafficNodeMonitor<T> monitor = this.nodeMonitors.get(node);
        Boolean wasWorking = monitor.isKnownWorking();
        monitor.responded();
        if (wasWorking != monitor.isKnownWorking()) {
            this.nodeManager.working(monitor.getNode());
        }
    }

    public void ping(Executor executor) {
        Iterator<BaseNodeMonitor<T>> i = this.nodeMonitorIterator();
        while (i.hasNext()) {
            BaseNodeMonitor<T> monitor = i.next();
            this.nodeManager.ping(monitor.getNode(), executor);
        }
        this.nodeManager.pingIterationCompleted();
    }

    public Iterator<BaseNodeMonitor<T>> nodeMonitorIterator() {
        return this.nodeMonitors().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseNodeMonitor<T>> nodeMonitors() {
        Map<T, TrafficNodeMonitor<T>> map = this.nodeMonitors;
        synchronized (map) {
            return new ArrayList<BaseNodeMonitor<T>>(this.nodeMonitors.values());
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.monitorThread.interrupt();
    }

    private class MonitorThread
    extends Thread {
        MonitorThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            log.info("Starting cluster monitor thread " + this.getName());
            ExecutorService pingExecutor = Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory((String)"search.ping"));
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(ClusterMonitor.this.configuration.getCheckInterval());
                    log.finest("Activating ping");
                    ClusterMonitor.this.ping(pingExecutor);
                }
                catch (Throwable e) {
                    if (ClusterMonitor.this.shutdown && e instanceof InterruptedException) break;
                    if (!(e instanceof Exception)) {
                        log.log(Level.WARNING, "Error in monitor thread, will quit", e);
                        break;
                    }
                    log.log(Level.WARNING, "Exception in monitor thread", e);
                }
            }
            pingExecutor.shutdown();
            try {
                pingExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("Stopped cluster monitor thread " + this.getName());
        }
    }
}

