/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.geo.BoundingBoxParser;
import com.yahoo.geo.DegreesParser;
import com.yahoo.prelude.Location;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.Exceptions;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
@Provides(value={"PositionParsing"})
public class PosSearcher
extends Searcher {
    public static final String POSITION_PARSING = "PositionParsing";
    private static final CompoundName posBb = new CompoundName("pos.bb");
    private static final CompoundName posLl = new CompoundName("pos.ll");
    private static final CompoundName posXy = new CompoundName("pos.xy");
    private static final CompoundName posAttributeName = new CompoundName("pos.attribute");
    private static final CompoundName posRadius = new CompoundName("pos.radius");
    private static final CompoundName posUnits = new CompoundName("pos.units");
    public static final double km2deg = 0.009013373419803435;
    public static final double mi2deg = 0.014505618432920139;

    @Override
    public Result search(Query query, Execution execution) {
        String bb = query.properties().getString(posBb);
        String ll = query.properties().getString(posLl);
        String xy = query.properties().getString(posXy);
        if (ll == null && xy == null && bb == null) {
            return execution.search(query);
        }
        if (query.getRanking().getLocation() != null) {
            query.trace("query already has a location set, not processing 'pos' params", false, 1);
            return execution.search(query);
        }
        Location loc = new Location();
        loc.setDimensions(2);
        String posAttribute = query.properties().getString(posAttributeName);
        loc.setAttribute(posAttribute);
        try {
            if (ll == null && xy == null && bb != null) {
                PosSearcher.parseBoundingBox(bb, loc);
            } else {
                if (ll != null && xy != null) {
                    throw new IllegalArgumentException("Cannot handle both lat/long and xy coords at the same time");
                }
                if (ll != null) {
                    this.handleGeoCircle(query, ll, loc);
                }
                if (xy != null) {
                    this.handleXyCircle(query, xy, loc);
                }
                if (bb != null) {
                    PosSearcher.parseBoundingBox(bb, loc);
                }
            }
        }
        catch (IllegalArgumentException e) {
            return new Result(query, ErrorMessage.createInvalidQueryParameter("Error in pos parameters: " + Exceptions.toMessageString((Throwable)e)));
        }
        query.getRanking().setLocation(loc);
        return execution.search(query);
    }

    private void handleGeoCircle(Query query, String ll, Location target) {
        double radiusdegrees;
        double nsCoord;
        double ewCoord;
        try {
            DegreesParser parsed = new DegreesParser(ll);
            ewCoord = parsed.longitude;
            nsCoord = parsed.latitude;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to parse lat/long string '" + ll + "'", e);
        }
        String radius = query.properties().getString(posRadius);
        if (radius == null) {
            radiusdegrees = 0.45066867099017177;
        } else if (radius.endsWith("km")) {
            double radiuskm = Double.valueOf(radius.substring(0, radius.length() - 2));
            radiusdegrees = radiuskm * 0.009013373419803435;
        } else if (radius.endsWith("m")) {
            double radiusm = Double.valueOf(radius.substring(0, radius.length() - 1));
            radiusdegrees = radiusm * 0.009013373419803435 / 1000.0;
        } else if (radius.endsWith("mi")) {
            double radiusmiles = Double.valueOf(radius.substring(0, radius.length() - 2));
            radiusdegrees = radiusmiles * 0.014505618432920139;
        } else {
            radiusdegrees = (double)Integer.parseInt(radius) * 1.0E-6;
        }
        target.setGeoCircle(nsCoord, ewCoord, radiusdegrees);
    }

    private void handleXyCircle(Query query, String xy, Location target) {
        int radiusUnits;
        int semipos = xy.indexOf(59);
        if (semipos <= 0 || semipos >= xy.length()) {
            throw new IllegalArgumentException("pos.xy must be in the format 'digits;digits' but was: '" + xy + "'");
        }
        int xcoord = Integer.parseInt(xy.substring(0, semipos));
        int ycoord = Integer.parseInt(xy.substring(semipos + 1, xy.length()));
        String radius = query.properties().getString(posRadius);
        if (radius == null) {
            radiusUnits = 5000;
        } else if (radius.endsWith("km")) {
            double radiuskm = Double.valueOf(radius.substring(0, radius.length() - 2));
            double radiusdegrees = radiuskm * 0.009013373419803435;
            radiusUnits = (int)(radiusdegrees * 1000000.0);
        } else if (radius.endsWith("m")) {
            double radiusm = Double.valueOf(radius.substring(0, radius.length() - 1));
            double radiusdegrees = radiusm * 0.009013373419803435 / 1000.0;
            radiusUnits = (int)(radiusdegrees * 1000000.0);
        } else if (radius.endsWith("mi")) {
            double radiusmiles = Double.valueOf(radius.substring(0, radius.length() - 2));
            double radiusdegrees = radiusmiles * 0.014505618432920139;
            radiusUnits = (int)(radiusdegrees * 1000000.0);
        } else {
            radiusUnits = Integer.parseInt(radius);
        }
        target.setXyCircle(xcoord, ycoord, radiusUnits);
    }

    private static void parseBoundingBox(String bb, Location target) {
        BoundingBoxParser parser = new BoundingBoxParser(bb);
        target.setBoundingBox(parser.n, parser.s, parser.e, parser.w);
    }
}

