/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.SimpleIndexedItem;
import com.yahoo.prelude.query.SubstringItem;
import com.yahoo.search.Query;

public class QueryRewrite {
    public static void optimizeAndNot(Query query) {
        Item possibleNewRoot;
        Item root = query.getModel().getQueryTree().getRoot();
        if (root != (possibleNewRoot = QueryRewrite.optimizeAndNot(root))) {
            query.getModel().getQueryTree().setRoot(possibleNewRoot);
        }
    }

    public static void optimizeByRestrict(Query query) {
        if (query.getModel().getRestrict().size() != 1) {
            return;
        }
        Item root = query.getModel().getQueryTree().getRoot();
        if (QueryRewrite.optimizeByRestrict(root, query.getModel().getRestrict().iterator().next()) == Recall.RECALLS_NOTHING) {
            query.getModel().getQueryTree().setRoot(new NullItem());
        }
    }

    public static void collapseSingleComposites(Query query) {
        Item newRoot;
        Item oldRoot = query.getModel().getQueryTree().getRoot();
        if (oldRoot != (newRoot = QueryRewrite.collapseSingleComposites(oldRoot))) {
            query.getModel().getQueryTree().setRoot(newRoot);
        }
    }

    public static void rewriteSddocname(Query query) {
        Item newRoot;
        Item oldRoot = query.getModel().getQueryTree().getRoot();
        if (oldRoot != (newRoot = QueryRewrite.rewriteSddocname(oldRoot))) {
            query.getModel().getQueryTree().setRoot(newRoot);
        }
    }

    private static Item optimizeAndNot(Item node) {
        if (node instanceof CompositeItem) {
            return QueryRewrite.extractAndNotRecursively((CompositeItem)node);
        }
        return node;
    }

    private static CompositeItem extractAndNotRecursively(CompositeItem parent) {
        for (int i = 0; i < parent.getItemCount(); ++i) {
            Item possibleNewChild;
            Item child = parent.getItem(i);
            if (child == (possibleNewChild = QueryRewrite.optimizeAndNot(child))) continue;
            parent.setItem(i, possibleNewChild);
        }
        if (parent instanceof AndItem) {
            return QueryRewrite.extractAndNot((AndItem)parent);
        }
        return parent;
    }

    private static CompositeItem extractAndNot(AndItem parent) {
        CompositeItem theOnlyNot = null;
        for (int i = 0; i < parent.getItemCount(); ++i) {
            Item child = parent.getItem(i);
            if (!(child instanceof NotItem)) continue;
            NotItem thisNot = (NotItem)child;
            parent.setItem(i, thisNot.getPositiveItem());
            if (theOnlyNot == null) {
                theOnlyNot = thisNot;
                ((NotItem)theOnlyNot).setPositiveItem(parent);
                continue;
            }
            for (int j = 1; j < thisNot.getItemCount(); ++j) {
                ((NotItem)theOnlyNot).addNegativeItem(thisNot.getItem(j));
            }
        }
        return theOnlyNot != null ? theOnlyNot : parent;
    }

    private static Recall optimizeByRestrict(Item item, String restrictParam) {
        if (item instanceof SimpleIndexedItem) {
            return QueryRewrite.optimizeIndexedItemByRestrict((SimpleIndexedItem)item, restrictParam);
        }
        if (item instanceof NotItem) {
            return QueryRewrite.optimizeNotItemByRestrict((NotItem)item, restrictParam);
        }
        if (item instanceof CompositeItem) {
            return QueryRewrite.optimizeCompositeItemByRestrict((CompositeItem)item, restrictParam);
        }
        return Recall.UNKNOWN_RECALL;
    }

    private static Recall optimizeIndexedItemByRestrict(SimpleIndexedItem item, String restrictParam) {
        if (!"sddocname".equals(item.getIndexName())) {
            return Recall.UNKNOWN_RECALL;
        }
        return restrictParam.equals(item.getIndexedString()) ? Recall.RECALLS_EVERYTHING : Recall.RECALLS_NOTHING;
    }

    private static Recall optimizeNotItemByRestrict(NotItem item, String restrictParam) {
        if (QueryRewrite.optimizeByRestrict(item.getItem(0), restrictParam) == Recall.RECALLS_NOTHING) {
            return Recall.RECALLS_NOTHING;
        }
        int i = item.getItemCount();
        while (--i >= 1) {
            Item child = item.getItem(i);
            switch (QueryRewrite.optimizeByRestrict(child, restrictParam)) {
                case RECALLS_EVERYTHING: {
                    return Recall.RECALLS_NOTHING;
                }
                case RECALLS_NOTHING: {
                    item.removeItem(i);
                }
            }
        }
        return Recall.UNKNOWN_RECALL;
    }

    private static Recall optimizeCompositeItemByRestrict(CompositeItem item, String restrictParam) {
        Recall recall = Recall.UNKNOWN_RECALL;
        int i = item.getItemCount();
        while (--i >= 0) {
            switch (QueryRewrite.optimizeByRestrict(item.getItem(i), restrictParam)) {
                case RECALLS_EVERYTHING: {
                    if (item instanceof OrItem || item instanceof EquivItem) {
                        QueryRewrite.removeOtherNonrankedChildren(item, i);
                        recall = Recall.RECALLS_EVERYTHING;
                        break;
                    }
                    if (item instanceof AndItem || item instanceof NearItem) {
                        item.removeItem(i);
                        break;
                    }
                    if (item instanceof RankItem) break;
                    throw new UnsupportedOperationException(item.getClass().getName());
                }
                case RECALLS_NOTHING: {
                    if (item instanceof OrItem || item instanceof EquivItem) {
                        item.removeItem(i);
                        break;
                    }
                    if (item instanceof AndItem || item instanceof NearItem) {
                        return Recall.RECALLS_NOTHING;
                    }
                    if (item instanceof RankItem) {
                        item.removeItem(i);
                        break;
                    }
                    throw new UnsupportedOperationException(item.getClass().getName());
                }
            }
        }
        return recall;
    }

    private static void removeOtherNonrankedChildren(CompositeItem parent, int indexOfChildToKeep) {
        Item childToKeep = parent.getItem(indexOfChildToKeep);
        int i = parent.getItemCount();
        while (--i >= 0) {
            Item child = parent.getItem(i);
            if (child == childToKeep || parent.getItem(i).isRanked()) continue;
            parent.removeItem(i);
        }
    }

    private static Item collapseSingleComposites(Item item) {
        if (!(item instanceof CompositeItem)) {
            return item;
        }
        CompositeItem parent = (CompositeItem)item;
        int numChildren = parent.getItemCount();
        for (int i = 0; i < numChildren; ++i) {
            Item newChild;
            Item oldChild = parent.getItem(i);
            if (oldChild == (newChild = QueryRewrite.collapseSingleComposites(oldChild))) continue;
            parent.setItem(i, newChild);
        }
        return parent.extractSingleChild().orElse(item);
    }

    private static Item rewriteSddocname(Item item) {
        SimpleIndexedItem oldItem;
        if (item instanceof CompositeItem) {
            CompositeItem parent = (CompositeItem)item;
            int len = parent.getItemCount();
            for (int i = 0; i < len; ++i) {
                Item newChild;
                Item oldChild = parent.getItem(i);
                if (oldChild == (newChild = QueryRewrite.rewriteSddocname(oldChild))) continue;
                parent.setItem(i, newChild);
            }
        } else if (item instanceof SimpleIndexedItem && "sddocname".equals((oldItem = (SimpleIndexedItem)item).getIndexName())) {
            SubstringItem newItem = new SubstringItem(oldItem.getIndexedString());
            newItem.setIndexName("[documentmetastore]");
            return newItem;
        }
        return item;
    }

    private static enum Recall {
        RECALLS_EVERYTHING,
        RECALLS_NOTHING,
        UNKNOWN_RECALL;

    }
}

