/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.google.common.annotations.Beta;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NonReducibleCompositeItem;
import com.yahoo.prelude.query.SimpleIndexedItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.protect.Validator;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.Optional;

@Beta
public class SameElementItem
extends NonReducibleCompositeItem {
    private final String fieldName;

    public SameElementItem(String commonPath) {
        Validator.ensureNonEmpty((String)"Field name", (String)commonPath);
        this.fieldName = commonPath;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        SameElementItem.putString(this.fieldName, buffer);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append(this.fieldName).append(':');
        buffer.append('{');
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            TermItem term = (TermItem)i.next();
            buffer.append(term.getIndexName()).append(':').append(term.getIndexedString());
            if (!i.hasNext()) continue;
            buffer.append(' ');
        }
        buffer.append('}');
    }

    @Override
    protected void adding(Item item) {
        super.adding(item);
        Validator.ensureInstanceOf((String)"Child item", (Object)item, TermItem.class);
        TermItem asTerm = (TermItem)item;
        Validator.ensureNonEmpty((String)"Struct fieldname", (String)asTerm.getIndexName());
        Validator.ensureNonEmpty((String)"Query term", (String)asTerm.getIndexedString());
    }

    @Override
    public Optional<Item> extractSingleChild() {
        if (this.getItemCount() == 1) {
            SimpleIndexedItem child = (SimpleIndexedItem)this.getItem(0);
            child.setIndexName(this.getFieldName() + "." + child.getIndexName());
            return Optional.of(child);
        }
        return Optional.empty();
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.SAME_ELEMENT;
    }

    @Override
    public String getName() {
        return this.getItemType().toString();
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

