/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.statistics.ElapsedTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Pong {
    private String pingInfo = "";
    private final List<ErrorMessage> errors = new ArrayList<ErrorMessage>(1);
    private ElapsedTime elapsed = new ElapsedTime();
    private final Optional<Long> activeDocuments;

    public Pong() {
        this.activeDocuments = Optional.empty();
    }

    public Pong(ErrorMessage error) {
        this.errors.add(error);
        this.activeDocuments = Optional.empty();
    }

    public Pong(long activeDocuments) {
        this.activeDocuments = Optional.of(activeDocuments);
    }

    public void addError(ErrorMessage error) {
        this.errors.add(error);
    }

    public ErrorMessage getError(int i) {
        return this.errors.get(i);
    }

    public Optional<Long> activeDocuments() {
        return this.activeDocuments;
    }

    public Optional<Integer> activeNodes() {
        return Optional.empty();
    }

    public List<ErrorMessage> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean badResponse() {
        return !this.errors.isEmpty();
    }

    public ElapsedTime getElapsedTime() {
        return this.elapsed;
    }

    public String toString() {
        StringBuilder m = new StringBuilder("Result of pinging");
        if (this.pingInfo.length() > 0) {
            m.append(" using ");
            m.append(this.pingInfo);
        }
        if (this.errors.size() > 0) {
            m.append(" ");
        }
        for (int i = 0; i < this.errors.size(); ++i) {
            m.append(this.errors.get(i).toString());
            if (i >= this.errors.size() - 1) continue;
            m.append(", ");
        }
        return m.toString();
    }
}

