/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.collect.ImmutableMap;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.DotProductItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.ExactStringItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.MarkerWordItem;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.ONearItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.PredicateQueryItem;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.RangeItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.RegExpItem;
import com.yahoo.prelude.query.SameElementItem;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.SubstringItem;
import com.yahoo.prelude.query.SuffixItem;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.prelude.query.WandItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.yql.NullItemException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class VespaSerializer {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Map<Class<?>, Serializer> dispatch;
    private static final Comparator<? super Map.Entry<Object, Integer>> tokenComparator;

    private static StringBuilder escape(String in, StringBuilder escaped) {
        block11: for (char c : in.toCharArray()) {
            switch (c) {
                case '\b': {
                    escaped.append("\\b");
                    continue block11;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block11;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block11;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block11;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block11;
                }
                case '\"': {
                    escaped.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    escaped.append("\\'");
                    continue block11;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block11;
                }
                case '/': {
                    escaped.append("\\/");
                    continue block11;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        escaped.append("\\u").append(VespaSerializer.fourDigitHexString(c));
                        continue block11;
                    }
                    escaped.append(c);
                }
            }
        }
        return escaped;
    }

    private static char[] fourDigitHexString(char c) {
        char[] hex = new char[4];
        int in = c & 0xFFFF;
        for (int i = 3; i >= 0; --i) {
            hex[i] = DIGITS[in & 0xF];
            in >>>= 4;
        }
        return hex;
    }

    static String getIndexName(Item item) {
        if (!(item instanceof IndexedItem)) {
            throw new IllegalArgumentException("Expected IndexedItem, got " + item.getClass());
        }
        return VespaSerializer.normalizeIndexName(((IndexedItem)((Object)item)).getIndexName());
    }

    public static String serialize(Query query) {
        StringBuilder out = new StringBuilder();
        VespaSerializer.serialize(query.getModel().getQueryTree().getRoot(), out);
        for (GroupingRequest request : query.getSelect().getGrouping()) {
            out.append(" | ");
            VespaSerializer.serialize(request, out);
        }
        return out.toString();
    }

    private static void serialize(GroupingRequest request, StringBuilder out) {
        Iterator<Continuation> it = request.continuations().iterator();
        if (it.hasNext()) {
            out.append("[{ 'continuations':[");
            while (it.hasNext()) {
                out.append('\'').append(it.next()).append('\'');
                if (!it.hasNext()) continue;
                out.append(", ");
            }
            out.append("] }]");
        }
        out.append(request.getRootOperation());
    }

    private static void serialize(Item item, StringBuilder out) {
        VespaVisitor visitor = new VespaVisitor(out);
        ToolBox.visit(visitor, item);
    }

    static String serialize(Item item) {
        StringBuilder out = new StringBuilder();
        VespaSerializer.serialize(item, out);
        return out.toString();
    }

    private static void serializeWeightedSetContents(StringBuilder destination, String opName, WeightedSetItem weightedSet) {
        VespaSerializer.serializeWeightedSetContents(destination, opName, weightedSet, "");
    }

    private static void serializeWeightedSetContents(StringBuilder destination, String opName, WeightedSetItem weightedSet, String optionalAnnotations) {
        VespaSerializer.addAnnotations(destination, weightedSet, optionalAnnotations);
        destination.append(opName).append('(').append(VespaSerializer.normalizeIndexName(weightedSet.getIndexName())).append(", {");
        int initLen = destination.length();
        ArrayList<Map.Entry<Object, Integer>> tokens = new ArrayList<Map.Entry<Object, Integer>>(weightedSet.getNumTokens());
        Iterator<Map.Entry<Object, Integer>> i = weightedSet.getTokens();
        while (i.hasNext()) {
            tokens.add(i.next());
        }
        Collections.sort(tokens, tokenComparator);
        for (Map.Entry entry : tokens) {
            VespaSerializer.comma(destination, initLen);
            destination.append('\"');
            VespaSerializer.escape(entry.getKey().toString(), destination);
            destination.append("\": ").append(((Integer)entry.getValue()).toString());
        }
        destination.append("})");
    }

    private static void addAnnotations(StringBuilder destination, WeightedSetItem weightedSet, String optionalAnnotations) {
        int incomingLen = destination.length();
        String annotations = VespaSerializer.leafAnnotations(weightedSet);
        if (optionalAnnotations.length() > 0 || annotations.length() > 0) {
            destination.append("[{");
        }
        int preAnnotationValueLen = destination.length();
        if (annotations.length() > 0) {
            destination.append(annotations);
        }
        if (optionalAnnotations.length() > 0) {
            VespaSerializer.comma(destination, preAnnotationValueLen);
            destination.append(optionalAnnotations);
        }
        if (destination.length() > incomingLen) {
            destination.append("}]");
        }
    }

    private static void comma(StringBuilder annotation, int initLen) {
        if (annotation.length() > initLen) {
            annotation.append(", ");
        }
    }

    private static String leafAnnotations(TaggableItem item) {
        int hitLimit;
        StringBuilder annotation = new StringBuilder();
        int initLen = annotation.length();
        int uniqueId = item.getUniqueID();
        double connectivity = item.getConnectivity();
        TaggableItem connectedTo = (TaggableItem)((Object)item.getConnectedItem());
        double significance = item.getSignificance();
        if (connectedTo != null && connectedTo.getUniqueID() != 0) {
            annotation.append('\"').append("connectivity").append("\": {\"").append("id").append("\": ").append(connectedTo.getUniqueID()).append(", \"").append("weight").append("\": ").append(connectivity).append("}");
        }
        if (item.hasExplicitSignificance()) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append('\"').append("significance").append("\": ").append(significance);
        }
        if (uniqueId != 0) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append('\"').append("id").append("\": ").append(uniqueId);
        }
        Item leaf = (Item)((Object)item);
        boolean filter = leaf.isFilter();
        boolean isRanked = leaf.isRanked();
        String label = leaf.getLabel();
        int weight = leaf.getWeight();
        if (filter) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("\"").append("filter").append("\": true");
        }
        if (!isRanked) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("\"").append("ranked").append("\": false");
        }
        if (label != null) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append("\"").append("label").append("\": \"");
            VespaSerializer.escape(label, annotation);
            annotation.append("\"");
        }
        if (weight != 100) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append('\"').append("weight").append("\": ").append(weight);
        }
        if (item instanceof IntItem && (hitLimit = ((IntItem)item).getHitLimit()) != 0) {
            VespaSerializer.comma(annotation, initLen);
            annotation.append('\"').append("hitLimit").append("\": ").append(hitLimit);
        }
        return annotation.toString();
    }

    private static void serializeOrigin(StringBuilder destination, String image, int offset, int length) {
        destination.append('\"').append("origin").append("\": {\"").append("original").append("\": \"");
        VespaSerializer.escape(image, destination);
        destination.append("\", \"").append("offset").append("\": ").append(offset).append(", \"").append("length").append("\": ").append(length).append("}");
    }

    private static String normalizeIndexName(@NonNull String indexName) {
        if (indexName.length() == 0) {
            return "default";
        }
        return indexName;
    }

    private static void annotatedTerm(StringBuilder destination, IndexedItem w, String annotations) {
        if (annotations.length() > 0) {
            destination.append("([{").append(annotations).append("}]");
        }
        destination.append('\"');
        VespaSerializer.escape(w.getIndexedString(), destination).append('\"');
        if (annotations.length() > 0) {
            destination.append(')');
        }
    }

    static {
        tokenComparator = new TokenComparator();
        HashMap<Class<RegExpItem>, Serializer> dispatchBuilder = new HashMap<Class<RegExpItem>, Serializer>();
        dispatchBuilder.put(AndItem.class, new AndSerializer());
        dispatchBuilder.put(AndSegmentItem.class, new AndSegmentSerializer());
        dispatchBuilder.put(DotProductItem.class, new DotProductSerializer());
        dispatchBuilder.put(EquivItem.class, new EquivSerializer());
        dispatchBuilder.put(ExactStringItem.class, new WordSerializer());
        dispatchBuilder.put(IntItem.class, new NumberSerializer());
        dispatchBuilder.put(MarkerWordItem.class, new WordSerializer());
        dispatchBuilder.put(NearItem.class, new NearSerializer());
        dispatchBuilder.put(NotItem.class, new NotSerializer());
        dispatchBuilder.put(NullItem.class, new NullSerializer());
        dispatchBuilder.put(ONearItem.class, new ONearSerializer());
        dispatchBuilder.put(OrItem.class, new OrSerializer());
        dispatchBuilder.put(PhraseItem.class, new PhraseSerializer());
        dispatchBuilder.put(SameElementItem.class, new SameElementSerializer());
        dispatchBuilder.put(PhraseSegmentItem.class, new PhraseSegmentSerializer());
        dispatchBuilder.put(PredicateQueryItem.class, new PredicateQuerySerializer());
        dispatchBuilder.put(PrefixItem.class, new WordSerializer());
        dispatchBuilder.put(WordAlternativesItem.class, new WordAlternativesSerializer());
        dispatchBuilder.put(RangeItem.class, new RangeSerializer());
        dispatchBuilder.put(RankItem.class, new RankSerializer());
        dispatchBuilder.put(SubstringItem.class, new WordSerializer());
        dispatchBuilder.put(SuffixItem.class, new WordSerializer());
        dispatchBuilder.put(WandItem.class, new WandSerializer());
        dispatchBuilder.put(WeakAndItem.class, new WeakAndSerializer());
        dispatchBuilder.put(WeightedSetItem.class, new WeightedSetSerializer());
        dispatchBuilder.put(WordItem.class, new WordSerializer());
        dispatchBuilder.put(RegExpItem.class, new RegExpSerializer());
        dispatch = ImmutableMap.copyOf(dispatchBuilder);
    }

    private static class WordSerializer
    extends Serializer {
        private WordSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            WordItem w = (WordItem)item;
            StringBuilder wordAnnotations = WordSerializer.getAllAnnotations(w);
            destination.append(VespaSerializer.normalizeIndexName(w.getIndexName())).append(" contains ");
            VespaSerializer.annotatedTerm(destination, w, wordAnnotations.toString());
            return false;
        }

        static void serializeWordWithoutIndex(StringBuilder destination, Item item) {
            WordItem w = (WordItem)item;
            StringBuilder wordAnnotations = WordSerializer.getAllAnnotations(w);
            VespaSerializer.annotatedTerm(destination, w, wordAnnotations.toString());
        }

        private static StringBuilder getAllAnnotations(WordItem w) {
            StringBuilder wordAnnotations = new StringBuilder(WordSerializer.wordAnnotations(w));
            String leafAnnotations = VespaSerializer.leafAnnotations(w);
            if (leafAnnotations.length() > 0) {
                VespaSerializer.comma(wordAnnotations, 0);
                wordAnnotations.append(VespaSerializer.leafAnnotations(w));
            }
            return wordAnnotations;
        }

        private static String wordAnnotations(WordItem item) {
            int length;
            int offset;
            String image;
            Substring origin = item.getOrigin();
            boolean usePositionData = item.usePositionData();
            boolean stemmed = item.isStemmed();
            boolean lowercased = item.isLowercased();
            boolean accentDrop = item.isNormalizable();
            SegmentingRule andSegmenting = item.getSegmentingRule();
            boolean isFromQuery = item.isFromQuery();
            StringBuilder annotation = new StringBuilder();
            boolean prefix = item instanceof PrefixItem;
            boolean suffix = item instanceof SuffixItem;
            boolean substring = item instanceof SubstringItem;
            int initLen = annotation.length();
            if (origin == null) {
                image = item.getRawWord();
                offset = 0;
                length = image.length();
            } else {
                image = origin.getSuperstring();
                offset = origin.start;
                length = origin.end - origin.start;
            }
            if (!image.substring(offset, offset + length).equals(item.getIndexedString())) {
                VespaSerializer.serializeOrigin(annotation, image, offset, length);
            }
            if (!usePositionData) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("usePositionData").append("\": false");
            }
            if (stemmed) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("stem").append("\": false");
            }
            if (lowercased) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("normalizeCase").append("\": false");
            }
            if (!accentDrop) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("accentDrop").append("\": false");
            }
            if (andSegmenting == SegmentingRule.BOOLEAN_AND) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("andSegmenting").append("\": true");
            }
            if (!isFromQuery) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("implicitTransforms").append("\": false");
            }
            if (prefix) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("prefix").append("\": true");
            }
            if (suffix) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("suffix").append("\": true");
            }
            if (substring) {
                VespaSerializer.comma(annotation, initLen);
                annotation.append('\"').append("substring").append("\": true");
            }
            return annotation.toString();
        }
    }

    private static class WeightedSetSerializer
    extends Serializer {
        private WeightedSetSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            VespaSerializer.serializeWeightedSetContents(destination, "weightedSet", (WeightedSetItem)item);
            return false;
        }
    }

    private static class WeakAndSerializer
    extends Serializer {
        private WeakAndSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
            destination.append(')');
            if (this.needsAnnotationBlock((WeakAndItem)item)) {
                destination.append(')');
            }
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return ", ";
        }

        private boolean needsAnnotationBlock(WeakAndItem item) {
            return this.nonDefaultScoreThreshold(item) || this.nonDefaultTargetNumHits(item);
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            WeakAndItem w = (WeakAndItem)item;
            if (this.needsAnnotationBlock(w)) {
                destination.append("([{");
            }
            int lengthBeforeAnnotations = destination.length();
            if (this.nonDefaultTargetNumHits(w)) {
                destination.append('\"').append("targetNumHits").append("\": ").append(w.getN());
            }
            if (this.nonDefaultScoreThreshold(w)) {
                VespaSerializer.comma(destination, lengthBeforeAnnotations);
                destination.append('\"').append("scoreThreshold").append("\": ").append(w.getScoreThreshold());
            }
            if (this.needsAnnotationBlock(w)) {
                destination.append("}]");
            }
            destination.append("weakAnd").append('(');
            return true;
        }

        private boolean nonDefaultScoreThreshold(WeakAndItem w) {
            return w.getScoreThreshold() > 0;
        }

        private boolean nonDefaultTargetNumHits(WeakAndItem w) {
            return w.getN() != 100;
        }
    }

    private static class WandSerializer
    extends Serializer {
        private WandSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            VespaSerializer.serializeWeightedSetContents(destination, "wand", (WeightedSetItem)item, this.specificAnnotations((WandItem)item));
            return false;
        }

        private String specificAnnotations(WandItem w) {
            StringBuilder annotations = new StringBuilder();
            int targetNumHits = w.getTargetNumHits();
            double scoreThreshold = w.getScoreThreshold();
            double thresholdBoostFactor = w.getThresholdBoostFactor();
            if (targetNumHits != 10) {
                annotations.append('\"').append("targetNumHits").append("\": ").append(targetNumHits);
            }
            if (scoreThreshold != 0.0) {
                VespaSerializer.comma(annotations, 0);
                annotations.append('\"').append("scoreThreshold").append("\": ").append(scoreThreshold);
            }
            if (thresholdBoostFactor != 1.0) {
                VespaSerializer.comma(annotations, 0);
                annotations.append('\"').append("thresholdBoostFactor").append("\": ").append(thresholdBoostFactor);
            }
            return annotations.toString();
        }
    }

    private static class VespaVisitor
    extends ToolBox.QueryVisitor {
        final StringBuilder destination;
        final Deque<SerializerWrapper> state = new ArrayDeque<SerializerWrapper>();

        VespaVisitor(StringBuilder destination) {
            this.destination = destination;
        }

        @Override
        public void onExit() {
            SerializerWrapper w = this.state.removeFirst();
            w.type.onExit(this.destination, w.item);
            w = this.state.peekFirst();
            if (w != null) {
                ++w.subItems;
            }
        }

        @Override
        public boolean visit(Item item) {
            Serializer doIt = (Serializer)dispatch.get(item.getClass());
            if (doIt == null) {
                throw new IllegalArgumentException(item.getClass() + " not supported for YQL+ marshalling.");
            }
            if (this.state.peekFirst() != null && this.state.peekFirst().subItems > 0) {
                this.destination.append(this.state.peekFirst().type.separator(this.state));
            }
            this.state.addFirst(new SerializerWrapper(doIt, item));
            return doIt.serialize(this.destination, item);
        }
    }

    private static final class TokenComparator
    implements Comparator<Map.Entry<Object, Integer>> {
        private TokenComparator() {
        }

        @Override
        public int compare(Map.Entry<Object, Integer> o1, Map.Entry<Object, Integer> o2) {
            Comparable c1 = (Comparable)o1.getKey();
            Comparable c2 = (Comparable)o2.getKey();
            return c1.compareTo(c2);
        }
    }

    private static final class SerializerWrapper {
        int subItems = 0;
        final Serializer type;
        final Item item;

        SerializerWrapper(Serializer type, Item item) {
            this.type = type;
            this.item = item;
        }
    }

    private static abstract class Serializer {
        private Serializer() {
        }

        abstract void onExit(StringBuilder var1, Item var2);

        String separator(Deque<SerializerWrapper> state) {
            throw new UnsupportedOperationException("Having several items for this query operator serializer, " + this.getClass().getSimpleName() + ", not yet implemented.");
        }

        abstract boolean serialize(StringBuilder var1, Item var2);
    }

    private static class WordAlternativesSerializer
    extends Serializer {
        private WordAlternativesSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            return WordAlternativesSerializer.serialize(destination, (WordAlternativesItem)item, true);
        }

        static boolean serialize(StringBuilder destination, WordAlternativesItem alternatives, boolean includeField) {
            int initLen;
            boolean needsAnnotations;
            String annotations = VespaSerializer.leafAnnotations(alternatives);
            Substring origin = alternatives.getOrigin();
            boolean isFromQuery = alternatives.isFromQuery();
            boolean bl = needsAnnotations = annotations.length() > 0 || origin != null || !isFromQuery;
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(alternatives.getIndexName())).append(" contains ");
            }
            if (needsAnnotations) {
                destination.append("([{");
                initLen = destination.length();
                if (origin != null) {
                    String image = origin.getSuperstring();
                    int offset = origin.start;
                    int length = origin.end - origin.start;
                    VespaSerializer.serializeOrigin(destination, image, offset, length);
                }
                if (!isFromQuery) {
                    VespaSerializer.comma(destination, initLen);
                    destination.append('\"').append("implicitTransforms").append("\": false");
                }
                if (annotations.length() > 0) {
                    VespaSerializer.comma(destination, initLen);
                    destination.append(annotations);
                }
                destination.append("}]");
            }
            destination.append("alternatives").append("({");
            initLen = destination.length();
            ArrayList<WordAlternativesItem.Alternative> sortedAlternatives = new ArrayList<WordAlternativesItem.Alternative>(alternatives.getAlternatives());
            Collections.sort(sortedAlternatives, (x, y) -> Double.compare(y.exactness, x.exactness));
            for (WordAlternativesItem.Alternative alternative : sortedAlternatives) {
                VespaSerializer.comma(destination, initLen);
                destination.append('\"');
                VespaSerializer.escape(alternative.word, destination);
                destination.append("\": ").append(Double.toString(alternative.exactness));
            }
            destination.append("})");
            if (needsAnnotations) {
                destination.append(')');
            }
            return false;
        }
    }

    private static class RankSerializer
    extends Serializer {
        private RankSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return ", ";
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            destination.append("rank").append('(');
            return true;
        }
    }

    private static class RangeSerializer
    extends Serializer {
        private RangeSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            RangeItem range = (RangeItem)item;
            String annotations = VespaSerializer.leafAnnotations(range);
            if (annotations.length() > 0) {
                destination.append("[{").append(annotations).append("}]");
            }
            destination.append("range").append('(').append(VespaSerializer.normalizeIndexName(range.getIndexName())).append(", ");
            this.appendNumberImage(destination, range.getFrom());
            destination.append(", ");
            this.appendNumberImage(destination, range.getTo());
            destination.append(')');
            return false;
        }

        private void appendNumberImage(StringBuilder destination, Number number) {
            destination.append(number.toString());
            if (number instanceof Long) {
                destination.append('L');
            }
        }
    }

    private static class PredicateQuerySerializer
    extends Serializer {
        private PredicateQuerySerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            PredicateQueryItem pItem = (PredicateQueryItem)item;
            destination.append("predicate(").append(pItem.getIndexName()).append(',');
            this.appendFeatures(destination, pItem.getFeatures());
            destination.append(',');
            this.appendFeatures(destination, pItem.getRangeFeatures());
            destination.append(')');
            return false;
        }

        private void appendFeatures(StringBuilder destination, Collection<? extends PredicateQueryItem.EntryBase> features) {
            if (features.isEmpty()) {
                destination.append('0');
                return;
            }
            destination.append('{');
            boolean first = true;
            for (PredicateQueryItem.EntryBase entryBase : features) {
                if (!first) {
                    destination.append(',');
                }
                if (entryBase.getSubQueryBitmap() != -1L) {
                    destination.append("\"0x").append(Long.toHexString(entryBase.getSubQueryBitmap()));
                    destination.append("\":{");
                    this.appendKeyValue(destination, entryBase);
                    destination.append('}');
                } else {
                    this.appendKeyValue(destination, entryBase);
                }
                first = false;
            }
            destination.append('}');
        }

        private void appendKeyValue(StringBuilder destination, PredicateQueryItem.EntryBase entry) {
            destination.append('\"');
            VespaSerializer.escape(entry.getKey(), destination);
            destination.append("\":");
            if (entry instanceof PredicateQueryItem.Entry) {
                destination.append('\"');
                VespaSerializer.escape(((PredicateQueryItem.Entry)entry).getValue(), destination);
                destination.append('\"');
            } else {
                destination.append(((PredicateQueryItem.RangeEntry)entry).getValue());
                destination.append('L');
            }
        }
    }

    private static class SameElementSerializer
    extends Serializer {
        private SameElementSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            return SameElementSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, Item item, boolean includeField) {
            SameElementItem sameElement = (SameElementItem)item;
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(sameElement.getFieldName())).append(" contains ");
            }
            destination.append("sameElement").append('(');
            for (int i = 0; i < sameElement.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if (!((current = sameElement.getItem(i)) instanceof WordItem)) {
                    throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in same_element is not implemented, please report this as a bug.");
                }
                new WordSerializer().serialize(destination, current);
            }
            destination.append(')');
            return false;
        }
    }

    private static class PhraseSerializer
    extends Serializer {
        private PhraseSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            return PhraseSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, Item item, boolean includeField) {
            PhraseItem phrase = (PhraseItem)item;
            String annotations = VespaSerializer.leafAnnotations(phrase);
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(phrase.getIndexName())).append(" contains ");
            }
            if (annotations.length() > 0) {
                destination.append("([{").append(annotations).append("}]");
            }
            destination.append("phrase").append('(');
            for (int i = 0; i < phrase.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if ((current = phrase.getItem(i)) instanceof WordItem) {
                    WordSerializer.serializeWordWithoutIndex(destination, current);
                    continue;
                }
                if (current instanceof PhraseSegmentItem) {
                    PhraseSegmentSerializer.serialize(destination, current, false);
                    continue;
                }
                if (current instanceof WordAlternativesItem) {
                    WordAlternativesSerializer.serialize(destination, (WordAlternativesItem)current, false);
                    continue;
                }
                throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in phrases not implemented, please report this as a bug.");
            }
            destination.append(')');
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }
    }

    private static class PhraseSegmentSerializer
    extends Serializer {
        private PhraseSegmentSerializer() {
        }

        private static void serializeWords(StringBuilder destination, PhraseSegmentItem segment) {
            for (int i = 0; i < segment.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if (!((current = segment.getItem(i)) instanceof WordItem)) {
                    throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in phrases not implemented, please report this as a bug.");
                }
                destination.append('\"');
                VespaSerializer.escape(((WordItem)current).getIndexedString(), destination).append('\"');
            }
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            return PhraseSegmentSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, Item item, boolean includeField) {
            int length;
            int offset;
            String image;
            PhraseSegmentItem phrase = (PhraseSegmentItem)item;
            Substring origin = phrase.getOrigin();
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(phrase.getIndexName())).append(" contains ");
            }
            if (origin == null) {
                image = phrase.getRawWord();
                offset = 0;
                length = image.length();
            } else {
                image = origin.getSuperstring();
                offset = origin.start;
                length = origin.end - origin.start;
            }
            destination.append("([{");
            VespaSerializer.serializeOrigin(destination, image, offset, length);
            String annotations = VespaSerializer.leafAnnotations(phrase);
            if (annotations.length() > 0) {
                destination.append(", ").append(annotations);
            }
            if (phrase.getSegmentingRule() == SegmentingRule.BOOLEAN_AND) {
                destination.append(", ").append('\"').append("andSegmenting").append("\": true");
            }
            destination.append("}]");
            destination.append("phrase").append('(');
            PhraseSegmentSerializer.serializeWords(destination, phrase);
            destination.append("))");
            return false;
        }
    }

    private static class OrSerializer
    extends Serializer {
        private OrSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return " OR ";
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            destination.append("(");
            return true;
        }
    }

    private static class ONearSerializer
    extends Serializer {
        private ONearSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            NearItem n = (NearItem)item;
            String annotations = NearSerializer.nearAnnotations(n);
            destination.append(VespaSerializer.getIndexName(n.getItem(0))).append(" contains ");
            if (annotations.length() > 0) {
                destination.append('(').append(annotations);
            }
            destination.append("onear").append('(');
            int initLen = destination.length();
            ListIterator<Item> i = n.getItemIterator();
            while (i.hasNext()) {
                WordItem close = (WordItem)i.next();
                if (destination.length() > initLen) {
                    destination.append(", ");
                }
                destination.append('\"');
                VespaSerializer.escape(close.getIndexedString(), destination).append('\"');
            }
            destination.append(')');
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }
    }

    private static class RegExpSerializer
    extends Serializer {
        private RegExpSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            RegExpItem regexp = (RegExpItem)item;
            String annotations = VespaSerializer.leafAnnotations(regexp);
            destination.append(VespaSerializer.normalizeIndexName(regexp.getIndexName())).append(" matches ");
            VespaSerializer.annotatedTerm(destination, regexp, annotations);
            return false;
        }
    }

    private static class NumberSerializer
    extends Serializer {
        private NumberSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            IntItem intItem = (IntItem)item;
            if (intItem.getFromLimit().number().equals(intItem.getToLimit().number())) {
                destination.append(VespaSerializer.normalizeIndexName(intItem.getIndexName())).append(" = ");
                this.annotatedNumberImage(intItem, intItem.getFromLimit().number().toString(), destination);
            } else if (intItem.getFromLimit().isInfinite()) {
                destination.append(VespaSerializer.normalizeIndexName(intItem.getIndexName()));
                destination.append(intItem.getToLimit().isInclusive() ? " <= " : " < ");
                this.annotatedNumberImage(intItem, intItem.getToLimit().number().toString(), destination);
            } else if (intItem.getToLimit().isInfinite()) {
                destination.append(VespaSerializer.normalizeIndexName(intItem.getIndexName()));
                destination.append(intItem.getFromLimit().isInclusive() ? " >= " : " > ");
                this.annotatedNumberImage(intItem, intItem.getFromLimit().number().toString(), destination);
            } else {
                this.serializeAsRange(destination, intItem);
            }
            return false;
        }

        private void serializeAsRange(StringBuilder destination, IntItem intItem) {
            String annotations = VespaSerializer.leafAnnotations(intItem);
            boolean leftOpen = !intItem.getFromLimit().isInclusive();
            boolean rightOpen = !intItem.getToLimit().isInclusive();
            String boundsAnnotation = "";
            if (leftOpen && rightOpen) {
                boundsAnnotation = "\"bounds\": \"open\"";
            } else if (leftOpen) {
                boundsAnnotation = "\"bounds\": \"leftOpen\"";
            } else if (rightOpen) {
                boundsAnnotation = "\"bounds\": \"rightOpen\"";
            }
            if (annotations.length() > 0 || boundsAnnotation.length() > 0) {
                destination.append("[{");
            }
            int initLen = destination.length();
            if (annotations.length() > 0) {
                destination.append(annotations);
            }
            VespaSerializer.comma(destination, initLen);
            if (boundsAnnotation.length() > 0) {
                destination.append(boundsAnnotation);
            }
            if (initLen != annotations.length()) {
                destination.append("}]");
            }
            destination.append("range").append('(').append(VespaSerializer.normalizeIndexName(intItem.getIndexName())).append(", ").append(intItem.getFromLimit().number()).append(", ").append(intItem.getToLimit().number()).append(")");
        }

        private void annotatedNumberImage(IntItem item, String rawNumber, StringBuilder image) {
            String annotations = VespaSerializer.leafAnnotations(item);
            if (annotations.length() > 0) {
                image.append("([{").append(annotations).append("}]");
            }
            if ('-' == rawNumber.charAt(0)) {
                image.append('(');
            }
            image.append(rawNumber);
            this.appendLongIfNecessary(rawNumber, image);
            if ('-' == rawNumber.charAt(0)) {
                image.append(')');
            }
            if (annotations.length() > 0) {
                image.append(')');
            }
        }

        private void appendLongIfNecessary(String rawNumber, StringBuilder image) {
            if (rawNumber.indexOf(46) >= 0) {
                return;
            }
            try {
                long l = Long.parseLong(rawNumber);
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    image.append('L');
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }

    private static class NullSerializer
    extends Serializer {
        private NullSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            throw new NullItemException("NullItem encountered in query tree. This is usually a symptom of an invalid query or an error in a query transformer.");
        }
    }

    private static class NotSerializer
    extends Serializer {
        private NotSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            if (state.peekFirst().subItems == 1) {
                return ") AND !(";
            }
            return " OR ";
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            destination.append("(");
            return true;
        }
    }

    private static class NearSerializer
    extends Serializer {
        private NearSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            NearItem n = (NearItem)item;
            String annotations = NearSerializer.nearAnnotations(n);
            destination.append(VespaSerializer.getIndexName(n.getItem(0))).append(" contains ");
            if (annotations.length() > 0) {
                destination.append('(').append(annotations);
            }
            destination.append("near").append('(');
            int initLen = destination.length();
            ListIterator<Item> i = n.getItemIterator();
            while (i.hasNext()) {
                WordItem close = (WordItem)i.next();
                if (destination.length() > initLen) {
                    destination.append(", ");
                }
                destination.append('\"');
                VespaSerializer.escape(close.getIndexedString(), destination).append('\"');
            }
            destination.append(')');
            if (annotations.length() > 0) {
                destination.append(')');
            }
            return false;
        }

        static String nearAnnotations(NearItem n) {
            if (n.getDistance() != 2) {
                return "[{\"distance\": " + n.getDistance() + "}]";
            }
            return "";
        }
    }

    private static class EquivSerializer
    extends Serializer {
        private EquivSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            EquivItem e = (EquivItem)item;
            String annotations = VespaSerializer.leafAnnotations(e);
            destination.append(VespaSerializer.getIndexName(e.getItem(0))).append(" contains ");
            if (annotations.length() > 0) {
                destination.append("([{").append(annotations).append("}]");
            }
            destination.append("equiv").append('(');
            int initLen = destination.length();
            ListIterator<Item> i = e.getItemIterator();
            while (i.hasNext()) {
                Item x = (Item)i.next();
                if (destination.length() > initLen) {
                    destination.append(", ");
                }
                if (x instanceof PhraseItem) {
                    PhraseSerializer.serialize(destination, x, false);
                    continue;
                }
                destination.append('\"');
                VespaSerializer.escape(((IndexedItem)((Object)x)).getIndexedString(), destination);
                destination.append('\"');
            }
            if (annotations.length() > 0) {
                destination.append(')');
            }
            destination.append(')');
            return false;
        }
    }

    private static class DotProductSerializer
    extends Serializer {
        private DotProductSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            VespaSerializer.serializeWeightedSetContents(destination, "dotProduct", (WeightedSetItem)item);
            return false;
        }
    }

    private static class AndSerializer
    extends Serializer {
        private AndSerializer() {
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
            destination.append(')');
        }

        @Override
        String separator(Deque<SerializerWrapper> state) {
            return " AND ";
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            destination.append("(");
            return true;
        }
    }

    private static class AndSegmentSerializer
    extends Serializer {
        private AndSegmentSerializer() {
        }

        private static void serializeWords(StringBuilder destination, AndSegmentItem segment) {
            for (int i = 0; i < segment.getItemCount(); ++i) {
                Item current;
                if (i > 0) {
                    destination.append(", ");
                }
                if (!((current = segment.getItem(i)) instanceof WordItem)) {
                    throw new IllegalArgumentException("Serializing of " + current.getClass().getSimpleName() + " in segment AND expressions not implemented, please report this as a bug.");
                }
                destination.append('\"');
                VespaSerializer.escape(((WordItem)current).getIndexedString(), destination).append('\"');
            }
        }

        @Override
        void onExit(StringBuilder destination, Item item) {
        }

        @Override
        boolean serialize(StringBuilder destination, Item item) {
            return AndSegmentSerializer.serialize(destination, item, true);
        }

        static boolean serialize(StringBuilder destination, Item item, boolean includeField) {
            int length;
            int offset;
            String image;
            AndSegmentItem phrase = (AndSegmentItem)item;
            Substring origin = phrase.getOrigin();
            if (origin == null) {
                image = phrase.getRawWord();
                offset = 0;
                length = image.length();
            } else {
                image = origin.getSuperstring();
                offset = origin.start;
                length = origin.end - origin.start;
            }
            if (includeField) {
                destination.append(VespaSerializer.normalizeIndexName(phrase.getIndexName())).append(" contains ");
            }
            destination.append("([{");
            VespaSerializer.serializeOrigin(destination, image, offset, length);
            destination.append(", \"").append("andSegmenting").append("\": true");
            destination.append("}]");
            destination.append("phrase").append('(');
            AndSegmentSerializer.serializeWords(destination, phrase);
            destination.append("))");
            return false;
        }
    }
}

