/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain;

import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.language.Linguistics;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.query.parser.SpecialTokenRegistry;
import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.cluster.PingableSearcher;
import com.yahoo.search.rendering.RendererRegistry;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.search.statistics.TimeTracker;
import java.util.Objects;
import java.util.logging.Logger;

public class Execution
extends com.yahoo.processing.execution.Execution {
    public static final String ATTRIBUTEPREFETCH = "attributeprefetch";
    private final int entryIndex;
    private final TimeTracker timer;
    private final Context context = new Context(this);
    private final Context[] contextCache;
    private static final Logger log = Logger.getLogger(Execution.class.getName());

    public Execution(Execution execution) {
        this((Chain<? extends Processor>)execution.chain(), execution.context, execution.nextIndex());
    }

    public Execution(Context context) {
        this((Chain<? extends Searcher>)new Chain((ChainedComponent[])new Searcher[0]), context);
    }

    public Execution(Chain<? extends Searcher> searchChain, Context context) {
        this(searchChain, context, 0);
    }

    public Execution(Searcher searcher, Context context) {
        this((Chain<? extends Processor>)new Chain((ChainedComponent[])new Searcher[]{searcher}), context, 0);
    }

    private Execution(Chain<? extends Processor> searchChain, Context context, int searcherIndex) {
        super(searchChain, searcherIndex, context.createChildTrace(), context.createChildEnvironment());
        this.context.fill(context);
        this.contextCache = new Context[searchChain.components().size()];
        this.entryIndex = searcherIndex;
        this.timer = new TimeTracker(searchChain, searcherIndex);
    }

    public final Response process(Request request) {
        return this.search((Query)request);
    }

    public Result search(Query query) {
        this.timer.sampleSearch(this.nextIndex(), this.context.getDetailedDiagnostics());
        query.getModel().setExecution(this);
        this.trace().setTraceLevel(query.getTraceLevel());
        return (Result)super.process((Request)query);
    }

    protected void onInvoking(Request request, Processor processor) {
        super.onInvoking(request, processor);
        int traceDependencies = 6;
        Query query = (Query)request;
        if (query.getTraceLevel() >= 6) {
            query.trace(processor.getId() + " " + processor.getDependencies(), 6);
        }
    }

    protected Response defaultResponse(Request request) {
        return new Result((Query)request);
    }

    public void fillAttributes(Result result) {
        this.fill(result, ATTRIBUTEPREFETCH);
    }

    public void fill(Result result) {
        this.fill(result, result.getQuery().getPresentation().getSummary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(Result result, String summaryClass) {
        this.timer.sampleFill(this.nextIndex(), this.context.getDetailedDiagnostics());
        Searcher current = (Searcher)this.next();
        if (current == null) {
            return;
        }
        try {
            this.nextProcessor();
            this.onInvokingFill(current, result, summaryClass);
            current.ensureFilled(result, summaryClass, this);
        }
        finally {
            this.previousProcessor();
            this.onReturningFill(current, result, summaryClass);
            this.timer.sampleFillReturn(this.nextIndex(), this.context.getDetailedDiagnostics(), result);
        }
    }

    private void onInvokingFill(Searcher searcher, Result result, String summaryClass) {
        int traceFillAt = 5;
        if (this.trace().getTraceLevel() < traceFillAt) {
            return;
        }
        this.trace().trace("Invoke fill(" + summaryClass + ") on " + (Object)((Object)searcher), traceFillAt);
    }

    private void onReturningFill(Searcher searcher, Result result, String summaryClass) {
        int traceFillAt = 5;
        if (this.trace().getTraceLevel() < traceFillAt) {
            return;
        }
        this.trace().trace("Return fill(" + summaryClass + ") on " + (Object)((Object)searcher), traceFillAt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pong ping(Ping ping) {
        Pong annotationReference = null;
        this.timer.samplePing(this.nextIndex(), this.context.getDetailedDiagnostics());
        Searcher next = (Searcher)this.next();
        if (next == null) {
            annotationReference = new Pong();
            return annotationReference;
        }
        try {
            this.nextProcessor();
            Pong pong = annotationReference = this.invokePing(ping, next);
            return pong;
        }
        finally {
            this.previousProcessor();
            this.timer.samplePingReturn(this.nextIndex(), this.context.getDetailedDiagnostics(), annotationReference);
        }
    }

    protected void onReturning(Request request, Processor processor, Response response) {
        super.onReturning(request, processor, response);
        this.timer.sampleSearchReturn(this.nextIndex(), this.context.getDetailedDiagnostics(), (Result)response);
    }

    protected void previousProcessor() {
        super.previousProcessor();
        this.popContext();
    }

    protected void nextProcessor() {
        this.pushContext();
        super.nextProcessor();
    }

    private void popContext() {
        this.context.fill(this.contextCache[this.nextIndex()]);
        this.contextCache[this.nextIndex()] = null;
    }

    private void pushContext() {
        Context contextToPush = this.nextIndex() == this.entryIndex ? this.context.shallowCopy() : this.context.copyIfChanged(this.contextCache[this.nextIndex() - 1]);
        this.contextCache[this.nextIndex()] = contextToPush;
    }

    private Pong invokePing(Ping ping, Searcher next) {
        Pong annotationReference = next instanceof PingableSearcher ? ((PingableSearcher)next).ping(ping, this) : this.ping(ping);
        return annotationReference;
    }

    public SearchChainRegistry searchChainRegistry() {
        return this.context.searchChainRegistry();
    }

    public Context context() {
        return this.context;
    }

    public TimeTracker timer() {
        return this.timer;
    }

    public static final class Context {
        private boolean detailedDiagnostics = false;
        private boolean breakdown = false;
        private SearchChainRegistry searchChainRegistry = null;
        private IndexFacts indexFacts = null;
        private SpecialTokenRegistry tokenRegistry = null;
        private RendererRegistry rendererRegistry = null;
        private Linguistics linguistics = null;
        private final Execution owner;

        Context() {
            this.owner = null;
        }

        Context(Execution owner) {
            this.owner = owner;
        }

        public Context(SearchChainRegistry searchChainRegistry, IndexFacts indexFacts, SpecialTokenRegistry tokenRegistry, RendererRegistry rendererRegistry, Linguistics linguistics) {
            this.owner = null;
            this.searchChainRegistry = searchChainRegistry;
            this.indexFacts = indexFacts;
            this.tokenRegistry = tokenRegistry;
            this.rendererRegistry = rendererRegistry;
            this.linguistics = linguistics;
        }

        public static Context createContextStub() {
            return new Context(null, null, null, null, null);
        }

        public static Context createContextStub(IndexFacts indexFacts) {
            return new Context(null, indexFacts, null, null, null);
        }

        public static Context createContextStub(SearchChainRegistry searchChainRegistry, IndexFacts indexFacts) {
            return new Context(searchChainRegistry, indexFacts, null, null, null);
        }

        public static Context createContextStub(SearchChainRegistry searchChainRegistry, IndexFacts indexFacts, Linguistics linguistics) {
            return new Context(searchChainRegistry, indexFacts, null, null, linguistics);
        }

        public void populateFrom(Context sourceContext) {
            this.detailedDiagnostics = sourceContext.detailedDiagnostics;
            this.breakdown = sourceContext.breakdown;
            if (this.indexFacts == null) {
                this.indexFacts = sourceContext.indexFacts;
            }
            if (this.tokenRegistry == null) {
                this.tokenRegistry = sourceContext.tokenRegistry;
            }
            if (this.searchChainRegistry == null) {
                this.searchChainRegistry = sourceContext.searchChainRegistry;
            }
            if (this.rendererRegistry == null) {
                this.rendererRegistry = sourceContext.rendererRegistry;
            }
            if (this.linguistics == null) {
                this.linguistics = sourceContext.linguistics;
            }
        }

        void fill(Context other) {
            this.searchChainRegistry = other.searchChainRegistry;
            this.indexFacts = other.indexFacts;
            this.tokenRegistry = other.tokenRegistry;
            this.rendererRegistry = other.rendererRegistry;
            this.detailedDiagnostics = other.detailedDiagnostics;
            this.breakdown = other.breakdown;
            this.linguistics = other.linguistics;
        }

        public boolean equals(Context other) {
            return other.indexFacts == this.indexFacts && other.rendererRegistry == this.rendererRegistry && other.tokenRegistry == this.tokenRegistry && other.searchChainRegistry == this.searchChainRegistry && other.detailedDiagnostics == this.detailedDiagnostics && other.breakdown == this.breakdown && other.linguistics == this.linguistics;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.indexFacts, this.rendererRegistry, this.tokenRegistry, this.searchChainRegistry, this.detailedDiagnostics, this.breakdown, this.linguistics});
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != Context.class) {
                return false;
            }
            return this.equals((Context)other);
        }

        public Context shallowCopy() {
            Context c = new Context();
            c.fill(this);
            return c;
        }

        Context copyIfChanged(Context previous) {
            if (this.equals(previous)) {
                return previous;
            }
            return this.shallowCopy();
        }

        public IndexFacts getIndexFacts() {
            return this.indexFacts;
        }

        public void setIndexFacts(IndexFacts indexFacts) {
            this.indexFacts = indexFacts;
        }

        public SearchChainRegistry searchChainRegistry() {
            return this.searchChainRegistry;
        }

        public RendererRegistry rendererRegistry() {
            return this.rendererRegistry;
        }

        public SpecialTokenRegistry getTokenRegistry() {
            return this.tokenRegistry;
        }

        public void setTokenRegistry(SpecialTokenRegistry tokenRegistry) {
            this.tokenRegistry = tokenRegistry;
        }

        public void setDetailedDiagnostics(boolean breakdown) {
            this.detailedDiagnostics = breakdown;
        }

        public boolean getDetailedDiagnostics() {
            return this.detailedDiagnostics;
        }

        public boolean getBreakdown() {
            return this.breakdown;
        }

        public void setBreakdown(boolean breakdown) {
            this.breakdown = breakdown;
        }

        public Linguistics getLinguistics() {
            return this.linguistics;
        }

        public void setLinguistics(Linguistics linguistics) {
            this.linguistics = linguistics;
        }

        private Execution.Trace createChildTrace() {
            return this.owner != null ? this.owner.trace().createChild() : Execution.Trace.createRoot((int)0);
        }

        private Execution.Environment createChildEnvironment() {
            return this.owner != null ? this.owner.environment().nested() : Execution.Environment.createEmpty();
        }
    }
}

