/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.io.ByteWriter;
import com.yahoo.net.URI;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.prelude.hitfield.JSONString;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.result.HitRenderer;
import com.yahoo.search.query.context.QueryContext;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.DefaultErrorHit;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.Relevance;
import com.yahoo.search.result.StructuredData;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8String;
import com.yahoo.text.XML;
import com.yahoo.text.XMLWriter;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public final class XmlRenderer
extends AsynchronousSectionedRenderer<Result> {
    public static final String DEFAULT_MIMETYPE = "text/xml";
    public static final String DEFAULT_ENCODING = "utf-8";
    private static final Utf8String RESULT = new Utf8String("result");
    private static final Utf8String GROUP = new Utf8String("group");
    private static final Utf8String ID = new Utf8String("id");
    private static final Utf8String FIELD = new Utf8String("field");
    private static final Utf8String HIT = new Utf8String("hit");
    private static final Utf8String ERROR = new Utf8String("error");
    private static final Utf8String TOTAL_HIT_COUNT = new Utf8String("total-hit-count");
    private static final Utf8String QUERY_TIME = new Utf8String("querytime");
    private static final Utf8String SUMMARY_FETCH_TIME = new Utf8String("summaryfetchtime");
    private static final Utf8String SEARCH_TIME = new Utf8String("searchtime");
    private static final Utf8String NAME = new Utf8String("name");
    private static final Utf8String CODE = new Utf8String("code");
    private static final Utf8String COVERAGE_DOCS = new Utf8String("coverage-docs");
    private static final Utf8String COVERAGE_NODES = new Utf8String("coverage-nodes");
    private static final Utf8String COVERAGE_FULL = new Utf8String("coverage-full");
    private static final Utf8String COVERAGE = new Utf8String("coverage");
    private static final Utf8String RESULTS_FULL = new Utf8String("results-full");
    private static final Utf8String RESULTS = new Utf8String("results");
    private static final Utf8String TYPE = new Utf8String("type");
    private static final Utf8String RELEVANCY = new Utf8String("relevancy");
    private static final Utf8String SOURCE = new Utf8String("source");
    private final CopyOnWriteHashMap<String, Utf8String> fieldNameMap = new CopyOnWriteHashMap();
    private XMLWriter writer;

    public XmlRenderer() {
        this(null);
    }

    public XmlRenderer(Executor executor) {
        super(executor);
    }

    public void init() {
        super.init();
        this.writer = null;
    }

    public String getEncoding() {
        if (this.getResult() == null || this.getResult().getQuery() == null || this.getResult().getQuery().getModel().getEncoding() == null) {
            return DEFAULT_ENCODING;
        }
        return this.getResult().getQuery().getModel().getEncoding();
    }

    public String getMimeType() {
        return DEFAULT_MIMETYPE;
    }

    private XMLWriter wrapWriter(Writer writer) {
        return XMLWriter.from((Writer)writer, (int)10, (int)-1);
    }

    private void header(XMLWriter writer, Result result) throws IOException {
        writer.xmlHeader(this.getRequestedEncoding(result.getQuery()));
        writer.openTag(RESULT).attribute(TOTAL_HIT_COUNT, String.valueOf(result.getTotalHitCount()));
        XmlRenderer.renderCoverageAttributes(result.getCoverage(false), writer);
        this.renderTime(writer, result);
        writer.closeStartTag();
    }

    private void renderTime(XMLWriter writer, Result result) {
        if (!result.getQuery().getPresentation().getTiming()) {
            return;
        }
        String threeDecimals = "%.3f";
        double milli = 0.001;
        long now = System.currentTimeMillis();
        long searchTime = now - result.getElapsedTime().first();
        double searchSeconds = (double)searchTime * 0.001;
        if (result.getElapsedTime().firstFill() != 0L) {
            long queryTime = result.getElapsedTime().weightedSearchTime();
            long summaryFetchTime = result.getElapsedTime().weightedFillTime();
            double querySeconds = (double)queryTime * 0.001;
            double summarySeconds = (double)summaryFetchTime * 0.001;
            writer.attribute(QUERY_TIME, String.format("%.3f", querySeconds));
            writer.attribute(SUMMARY_FETCH_TIME, String.format("%.3f", summarySeconds));
        }
        writer.attribute(SEARCH_TIME, String.format("%.3f", searchSeconds));
    }

    protected static void renderCoverageAttributes(Coverage coverage, XMLWriter writer) throws IOException {
        if (coverage == null) {
            return;
        }
        writer.attribute(COVERAGE_DOCS, coverage.getDocs());
        writer.attribute(COVERAGE_NODES, (long)coverage.getNodes());
        writer.attribute(COVERAGE_FULL, coverage.getFull());
        writer.attribute(COVERAGE, (long)coverage.getResultPercentage());
        writer.attribute(RESULTS_FULL, (long)coverage.getFullResultSets());
        writer.attribute(RESULTS, (long)coverage.getResultSets());
    }

    public void error(XMLWriter writer, Result result) throws IOException {
        ErrorMessage error = result.hits().getError();
        writer.openTag(ERROR).attribute(CODE, (long)error.getCode()).content((Object)error.getMessage(), false).closeTag();
    }

    protected void emptyResult(XMLWriter writer, Result result) throws IOException {
    }

    public void queryContext(XMLWriter writer, QueryContext queryContext, Query owner) throws IOException {
        if (owner.getTraceLevel() != 0) {
            XMLWriter xmlWriter = XMLWriter.from((Writer)writer);
            xmlWriter.openTag("meta").attribute("type", (Object)"context");
            TraceNode traceRoot = owner.getModel().getExecution().trace().traceNode().root();
            traceRoot.accept((TraceVisitor)new RenderingVisitor(xmlWriter, owner.getStartTime()));
            xmlWriter.closeTag();
        }
    }

    private void renderSingularHit(XMLWriter writer, Hit hit) {
        writer.openTag(HIT);
        this.renderHitAttributes(writer, hit);
        writer.closeStartTag();
        this.renderHitFields(writer, hit);
    }

    private void renderHitFields(XMLWriter writer, Hit hit) {
        this.renderSyntheticRelevanceField(writer, hit);
        hit.forEachField((name, value) -> this.renderField(writer, (String)name, value));
    }

    private void renderField(XMLWriter writer, String name, Object value) {
        if (name.startsWith("$")) {
            return;
        }
        this.writeOpenFieldElement(writer, name);
        this.renderFieldContent(writer, value);
        this.writeCloseFieldElement(writer);
    }

    private void renderFieldContent(XMLWriter writer, Object value) {
        writer.escapedContent(this.asXML(value), false);
    }

    private String asXML(Object value) {
        if (value == null) {
            return "(null)";
        }
        if (value instanceof HitField) {
            return ((HitField)value).quotedContent(false);
        }
        if (value instanceof StructuredData || value instanceof XMLString || value instanceof JSONString) {
            return value.toString();
        }
        return XML.xmlEscape((String)value.toString(), (boolean)false, (char)'\u001f');
    }

    private void renderSyntheticRelevanceField(XMLWriter writer, Hit hit) {
        String relevancyFieldName = "relevancy";
        Relevance relevance = hit.getRelevance();
        if (relevance != null) {
            this.renderSimpleField(writer, relevancyFieldName, relevance);
        }
    }

    private void renderSimpleField(XMLWriter writer, String relevancyFieldName, Relevance relevance) {
        this.writeOpenFieldElement(writer, relevancyFieldName);
        writer.content((Object)relevance.toString(), false);
        this.writeCloseFieldElement(writer);
    }

    private void writeCloseFieldElement(XMLWriter writer) {
        writer.closeTag();
    }

    private void writeOpenFieldElement(XMLWriter writer, String relevancyFieldName) {
        Utf8String utf8 = (Utf8String)this.fieldNameMap.get((Object)relevancyFieldName);
        if (utf8 == null) {
            utf8 = new Utf8String(relevancyFieldName);
            this.fieldNameMap.put((Object)relevancyFieldName, (Object)utf8);
        }
        writer.openTag(FIELD).attribute(NAME, (AbstractUtf8Array)utf8);
        writer.closeStartTag();
    }

    private void renderHitAttributes(XMLWriter writer, Hit hit) {
        writer.attribute(TYPE, hit.types().stream().collect(Collectors.joining(" ")));
        if (hit.getRelevance() != null) {
            writer.attribute(RELEVANCY, hit.getRelevance().toString());
        }
        writer.attribute(SOURCE, hit.getSource());
    }

    private void renderHitGroup(XMLWriter writer, HitGroup hit) throws IOException {
        if (!HitRenderer.renderHeader(hit, writer)) {
            if (hit.types().contains("grouphit")) {
                this.renderHitGroupOfTypeGroupHit(writer, hit);
            } else {
                this.renderGroup(writer, hit);
            }
        }
    }

    private void renderGroup(XMLWriter writer, HitGroup hit) {
        writer.openTag(GROUP);
        this.renderHitAttributes(writer, hit);
        writer.closeStartTag();
    }

    private void renderHitGroupOfTypeGroupHit(XMLWriter writer, HitGroup hit) {
        writer.openTag(HIT);
        this.renderHitAttributes(writer, hit);
        this.renderId(writer, hit);
        writer.closeStartTag();
    }

    private void renderId(XMLWriter writer, HitGroup hit) {
        URI uri = hit.getId();
        if (uri != null) {
            writer.openTag(ID).content((Object)uri.stringValue(), false).closeTag();
        }
    }

    private boolean simpleRenderHit(XMLWriter writer, Hit hit) throws IOException {
        if (hit instanceof DefaultErrorHit) {
            return XmlRenderer.simpleRenderDefaultErrorHit(writer, (DefaultErrorHit)hit);
        }
        return hit instanceof GroupingListHit;
    }

    public static boolean simpleRenderDefaultErrorHit(XMLWriter writer, ErrorHit defaultErrorHit) throws IOException {
        writer.openTag("errordetails");
        Iterator<? extends ErrorMessage> i = defaultErrorHit.errorIterator();
        while (i.hasNext()) {
            ErrorMessage error = i.next();
            XmlRenderer.renderMessageDefaultErrorHit(writer, error);
        }
        writer.closeTag();
        return true;
    }

    public static void renderMessageDefaultErrorHit(XMLWriter writer, ErrorMessage error) throws IOException {
        writer.openTag("error");
        writer.attribute("source", (Object)error.getSource());
        writer.attribute("error", (Object)error.getMessage());
        writer.attribute("code", (Object)Integer.toString(error.getCode()));
        writer.content((Object)error.getDetailedMessage(), false);
        if (error.getCause() != null) {
            writer.openTag("cause");
            writer.content((Object)"\n", true);
            StringWriter stackTrace = new StringWriter();
            error.getCause().printStackTrace(new PrintWriter(stackTrace));
            writer.content((Object)stackTrace.toString(), true);
            writer.closeTag();
        }
        writer.closeTag();
    }

    private Result getResult() {
        Result r;
        try {
            r = (Result)this.getResponse();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("XmlRenderer attempted used outside a search context, got a " + this.getResponse().getClass().getName());
        }
        return r;
    }

    public void beginResponse(OutputStream stream) throws IOException {
        Charset cs = Charset.forName(this.getRequestedEncoding(this.getResult().getQuery()));
        CharsetEncoder encoder = cs.newEncoder();
        this.writer = this.wrapWriter((Writer)new ByteWriter(stream, encoder));
        this.header(this.writer, this.getResult());
        if (this.getResult().hits().getError() != null || this.getResult().hits().getQuery().errors().size() > 0) {
            this.error(this.writer, this.getResult());
        }
        if (this.getResult().getConcreteHitCount() == 0) {
            this.emptyResult(this.writer, this.getResult());
        }
        if (this.getResult().getContext(false) != null) {
            this.queryContext(this.writer, this.getResult().getContext(false), this.getResult().getQuery());
        }
    }

    public final String getRequestedEncoding(Query query) {
        String encoding = query.getModel().getEncoding();
        if (encoding != null) {
            return encoding;
        }
        return this.getEncoding();
    }

    public void beginList(DataList<?> list) throws IOException {
        if (this.getRecursionLevel() == 1) {
            return;
        }
        HitGroup hit = (HitGroup)list;
        boolean renderedSimple = this.simpleRenderHit(this.writer, hit);
        if (renderedSimple) {
            return;
        }
        this.renderHitGroup(this.writer, hit);
    }

    public void data(Data data) throws IOException {
        Hit hit = (Hit)data;
        boolean renderedSimple = this.simpleRenderHit(this.writer, hit);
        if (renderedSimple) {
            return;
        }
        this.renderSingularHit(this.writer, hit);
        this.writer.closeTag();
    }

    public void endList(DataList<?> list) {
        if (this.getRecursionLevel() > 1) {
            this.writer.closeTag();
        }
    }

    public void endResponse() {
        this.writer.closeTag();
        this.writer.close();
    }

    public static final class RenderingVisitor
    extends TraceVisitor {
        private static final String tag = "p";
        private final XMLWriter writer;
        private long baseTime;

        public RenderingVisitor(XMLWriter writer, long baseTime) {
            this.writer = writer;
            this.baseTime = baseTime;
        }

        public void entering(TraceNode node) {
            if (node.isRoot()) {
                return;
            }
            this.writer.openTag(tag);
        }

        public void leaving(TraceNode node) {
            if (node.isRoot()) {
                return;
            }
            this.writer.closeTag();
        }

        public void visit(TraceNode node) {
            if (node.isRoot()) {
                return;
            }
            if (node.payload() == null) {
                return;
            }
            this.writer.openTag(tag);
            if (node.timestamp() != 0L) {
                this.writer.content((Object)(node.timestamp() - this.baseTime), false).content((Object)" ms: ", false);
            }
            this.writer.content((Object)node.payload().toString(), false);
            this.writer.closeTag();
        }
    }
}

