/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.component.ComponentId;
import com.yahoo.language.Language;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.parser.CustomParser;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.query.parser.ParserFactory;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.Exceptions;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

@Deprecated
public class QueryCombinator
extends Searcher {
    private static final String QUERYPREFIX = "query.";

    public QueryCombinator(ComponentId id) {
        super(id);
    }

    @Override
    public Result search(Query query, Execution execution) {
        Set<QueryPart> pieces = QueryCombinator.findQuerySnippets(query.properties());
        if (pieces.size() == 0) {
            return execution.search(query);
        }
        this.addAndItems(query, pieces, execution.context());
        query.trace("Adding extra query parts.", true, 2);
        return execution.search(query);
    }

    private void addAndItems(Query query, Iterable<QueryPart> pieces, Execution.Context context) {
        IndexFacts indexFacts = context.getIndexFacts();
        IndexFacts.Session session = indexFacts.newSession(query);
        HashSet<String> usedSources = new HashSet<String>(session.documentTypes());
        Language language = query.getModel().getParsingLanguage();
        for (QueryPart part : pieces) {
            Item item = null;
            Index index = session.getIndex(part.defaultIndex);
            String defaultIndex = index == Index.nullIndex ? null : part.defaultIndex;
            try {
                CustomParser parser = (CustomParser)ParserFactory.newInstance(query.getModel().getType(), ParserEnvironment.fromExecutionContext(context));
                item = parser.parse(part.query, null, language, usedSources, indexFacts, defaultIndex);
            }
            catch (RuntimeException e) {
                String err = Exceptions.toMessageString((Throwable)e);
                query.trace("Query parser threw an exception: " + err, true, 1);
                this.getLogger().log(LogLevel.WARNING, "Query parser threw exception searcher QueryCombinator for " + query.getHttpRequest().toString() + ", query part " + part.query + ": " + err);
            }
            if (item == null) continue;
            if (defaultIndex == null) {
                QueryCombinator.assignDefaultIndex(item, part.defaultIndex);
            }
            QueryCombinator.addAndItem(query.getModel().getQueryTree(), item);
        }
    }

    private static void addAndItem(QueryTree queryTree, Item item) {
        Item root = queryTree.getRoot();
        if (root instanceof NullItem || root == null) {
            queryTree.setRoot(item);
        } else if (root.getClass() == AndItem.class) {
            ((AndItem)root).addItem(item);
        } else {
            AndItem newRoot = new AndItem();
            newRoot.addItem(root);
            newRoot.addItem(item);
            queryTree.setRoot(newRoot);
        }
    }

    private static void assignDefaultIndex(Item item, String defaultIndex) {
        if (item instanceof IndexedItem) {
            IndexedItem indexName = (IndexedItem)((Object)item);
            if ("".equals(indexName.getIndexName())) {
                indexName.setIndexName(defaultIndex);
            }
        } else if (item instanceof CompositeItem) {
            ListIterator<Item> items = ((CompositeItem)item).getItemIterator();
            while (items.hasNext()) {
                Item i = (Item)items.next();
                QueryCombinator.assignDefaultIndex(i, defaultIndex);
            }
        }
    }

    private static Set<QueryPart> findQuerySnippets(Properties properties) {
        HashSet<QueryPart> pieces = new HashSet<QueryPart>();
        for (Map.Entry k : properties.listProperties().entrySet()) {
            String name;
            String key = (String)k.getKey();
            if (!key.startsWith(QUERYPREFIX) || QueryCombinator.hasDots(name = key.substring(QUERYPREFIX.length()))) continue;
            String index = properties.getString("defidx." + name);
            pieces.add(new QueryPart(k.getValue().toString(), index));
        }
        return pieces;
    }

    private static boolean hasDots(String name) {
        int index = name.indexOf(46, 0);
        return index != -1;
    }

    private static class QueryPart {
        final String query;
        final String defaultIndex;

        QueryPart(String query, String defaultIndex) {
            this.query = query;
            this.defaultIndex = defaultIndex;
        }
    }
}

