/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.language.Language;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.parser.CustomParser;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.query.parser.ParserFactory;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.Exceptions;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

@Before(value={"transformedQuery", "com.yahoo.prelude.querytransform.StemmingSearcher"})
public class LegacyCombinator
extends Searcher {
    private static final String TYPESUFFIX = ".type";
    private static final String OPERATORSUFFIX = ".operator";
    private static final String DEFIDXSUFFIX = ".defidx";
    private static final String DEFIDXPREFIX = "defidx.";
    private static final String QUERYPREFIX = "query.";

    @Override
    public Result search(Query query, Execution execution) {
        Set<QueryPart> pieces;
        IndexFacts indexFacts = execution.context().getIndexFacts();
        try {
            pieces = LegacyCombinator.findQuerySnippets(query.properties());
        }
        catch (IllegalArgumentException e) {
            query.errors().add(ErrorMessage.createInvalidQueryParameter("LegacyCombinator got invalid parameters: " + e.getMessage()));
            return execution.search(query);
        }
        if (pieces.size() == 0) {
            return execution.search(query);
        }
        IndexFacts.Session session = indexFacts.newSession(query);
        Language language = query.getModel().getParsingLanguage();
        this.addAndItems(language, query, pieces, session, execution.context());
        this.addRankItems(language, query, pieces, session, execution.context());
        try {
            this.addNotItems(language, query, pieces, session, execution.context());
        }
        catch (IllegalArgumentException e) {
            query.errors().add(ErrorMessage.createInvalidQueryParameter("LegacyCombinator found only excluding terms, no including."));
            return execution.search(query);
        }
        query.trace("Adding extra query parts.", true, 2);
        return execution.search(query);
    }

    private void addNotItems(Language language, Query query, Set<QueryPart> pieces, IndexFacts.Session session, Execution.Context context) {
        for (QueryPart part : pieces) {
            String defaultIndex;
            Item item;
            if (part.operator != Combinator.EXCLUDED || (item = this.parse(language, query, part, defaultIndex = this.defaultIndex(session, part), context)) == null) continue;
            this.setDefaultIndex(part, defaultIndex, item);
            this.addNotItem(query.getModel().getQueryTree(), item);
        }
    }

    private void addNotItem(QueryTree queryTree, Item item) {
        Item root = queryTree.getRoot();
        if (root instanceof NullItem || root == null) {
            throw new IllegalArgumentException("No positive terms for query.");
        }
        if (root.getClass() == NotItem.class) {
            ((NotItem)root).addNegativeItem(item);
        } else {
            NotItem newRoot = new NotItem();
            newRoot.addPositiveItem(root);
            newRoot.addNegativeItem(item);
            queryTree.setRoot(newRoot);
        }
    }

    private void addRankItems(Language language, Query query, Set<QueryPart> pieces, IndexFacts.Session session, Execution.Context context) {
        for (QueryPart part : pieces) {
            String defaultIndex;
            Item item;
            if (part.operator != Combinator.PREFERRED || (item = this.parse(language, query, part, defaultIndex = this.defaultIndex(session, part), context)) == null) continue;
            this.setDefaultIndex(part, defaultIndex, item);
            this.addRankItem(query.getModel().getQueryTree(), item);
        }
    }

    private void addRankItem(QueryTree queryTree, Item item) {
        Item root = queryTree.getRoot();
        if (root instanceof NullItem || root == null) {
            queryTree.setRoot(item);
        } else if (root.getClass() == RankItem.class) {
            ((RankItem)root).addItem(item);
        } else {
            RankItem newRoot = new RankItem();
            newRoot.addItem(root);
            newRoot.addItem(item);
            queryTree.setRoot(newRoot);
        }
    }

    private void addAndItems(Language language, Query query, Iterable<QueryPart> pieces, IndexFacts.Session session, Execution.Context context) {
        for (QueryPart part : pieces) {
            String defaultIndex;
            Item item;
            if (part.operator != Combinator.REQUIRED || (item = this.parse(language, query, part, defaultIndex = this.defaultIndex(session, part), context)) == null) continue;
            this.setDefaultIndex(part, defaultIndex, item);
            LegacyCombinator.addAndItem(query.getModel().getQueryTree(), item);
        }
    }

    private void setDefaultIndex(QueryPart part, String defaultIndex, Item item) {
        if (defaultIndex == null) {
            LegacyCombinator.assignDefaultIndex(item, part.defaultIndex);
        }
    }

    private Item parse(Language language, Query query, QueryPart part, String defaultIndex, Execution.Context context) {
        Item item = null;
        try {
            CustomParser parser = (CustomParser)ParserFactory.newInstance(part.syntax, ParserEnvironment.fromExecutionContext(context));
            item = parser.parse(part.query, null, language, query.getModel().getSources(), context.getIndexFacts(), defaultIndex);
        }
        catch (RuntimeException e) {
            String err = Exceptions.toMessageString((Throwable)e);
            query.trace("Query parser threw an exception: " + err, true, 1);
            this.getLogger().log(LogLevel.WARNING, "Query parser threw exception in searcher LegacyCombinator for " + query.getHttpRequest().toString() + ", query part " + part.query + ": " + err);
        }
        return item;
    }

    private String defaultIndex(IndexFacts.Session indexFacts, QueryPart part) {
        String defaultIndex = indexFacts.getIndex(part.defaultIndex) == Index.nullIndex ? null : part.defaultIndex;
        return defaultIndex;
    }

    private static void addAndItem(QueryTree queryTree, Item item) {
        Item root = queryTree.getRoot();
        if (root instanceof NullItem || root == null) {
            queryTree.setRoot(item);
        } else if (root.getClass() == AndItem.class) {
            ((AndItem)root).addItem(item);
        } else {
            AndItem newRoot = new AndItem();
            newRoot.addItem(root);
            newRoot.addItem(item);
            queryTree.setRoot(newRoot);
        }
    }

    private static void assignDefaultIndex(Item item, String defaultIndex) {
        if (item instanceof IndexedItem) {
            IndexedItem indexName = (IndexedItem)((Object)item);
            if ("".equals(indexName.getIndexName())) {
                indexName.setIndexName(defaultIndex);
            }
        } else if (item instanceof CompositeItem) {
            ListIterator<Item> items = ((CompositeItem)item).getItemIterator();
            while (items.hasNext()) {
                Item i = (Item)items.next();
                LegacyCombinator.assignDefaultIndex(i, defaultIndex);
            }
        }
    }

    private static Set<QueryPart> findQuerySnippets(Properties properties) {
        HashSet<QueryPart> pieces = new HashSet<QueryPart>();
        for (Map.Entry k : properties.listProperties().entrySet()) {
            String name;
            String key = (String)k.getKey();
            if (!key.startsWith(QUERYPREFIX) || LegacyCombinator.hasDots(name = key.substring(QUERYPREFIX.length()))) continue;
            String index = properties.getString(DEFIDXPREFIX + name);
            String oldIndex = properties.getString(QUERYPREFIX + name + DEFIDXSUFFIX);
            String operator = properties.getString(QUERYPREFIX + name + OPERATORSUFFIX);
            String type = properties.getString(QUERYPREFIX + name + TYPESUFFIX);
            pieces.add(new QueryPart(name, index, oldIndex, operator, k.getValue().toString(), type));
        }
        return pieces;
    }

    private static boolean hasDots(String name) {
        int index = name.indexOf(46, 0);
        return index != -1;
    }

    private static class QueryPart {
        final String query;
        final String defaultIndex;
        final Combinator operator;
        final String identifier;
        final Query.Type syntax;

        QueryPart(String identifier, String defaultIndex, String oldIndex, String operator, String query, String syntax) {
            QueryPart.validateArguments(identifier, defaultIndex, oldIndex, operator, syntax);
            this.query = query;
            this.defaultIndex = defaultIndex != null ? defaultIndex : oldIndex;
            this.operator = Combinator.getCombinator(operator);
            this.identifier = identifier;
            this.syntax = Query.Type.getType(syntax);
        }

        private static void validateArguments(String identifier, String defaultIndex, String oldIndex, String operator, String syntax) {
            if (defaultIndex == null) {
                return;
            }
            if (oldIndex != null) {
                throw new IllegalArgumentException(QueryPart.createErrorMessage(identifier, LegacyCombinator.DEFIDXSUFFIX));
            }
            if (operator != null) {
                throw new IllegalArgumentException(QueryPart.createErrorMessage(identifier, LegacyCombinator.OPERATORSUFFIX));
            }
            if (syntax != null) {
                throw new IllegalArgumentException(QueryPart.createErrorMessage(identifier, LegacyCombinator.TYPESUFFIX));
            }
        }

        private static String createErrorMessage(String identifier, String legacyArgument) {
            return "Cannot set both defidx." + identifier + " and " + LegacyCombinator.QUERYPREFIX + identifier + legacyArgument + ".";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryPart other = (QueryPart)obj;
            return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
        }

        public String toString() {
            return "QueryPart(" + this.identifier + ", " + this.defaultIndex + ", " + (Object)((Object)this.operator) + ", " + (Object)((Object)this.syntax) + ")";
        }
    }

    private static enum Combinator {
        REQUIRED("req"),
        PREFERRED("rank"),
        EXCLUDED("not");

        String parameterValue;

        private Combinator(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        static Combinator getCombinator(String name) {
            for (Combinator c : Combinator.values()) {
                if (!c.parameterValue.equals(name)) continue;
                return c;
            }
            return REQUIRED;
        }
    }
}

