/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;

public class QueryProfileFieldType
extends FieldType {
    private final QueryProfileType type;

    public static QueryProfileFieldType fromString(String queryProfileName, QueryProfileTypeRegistry registry) {
        if (queryProfileName == null || queryProfileName.equals("")) {
            return new QueryProfileFieldType(null);
        }
        if (registry == null) {
            throw new IllegalArgumentException("Can not resolve query profile type '" + queryProfileName + "' because no registry is provided");
        }
        QueryProfileType queryProfileType = (QueryProfileType)((Object)registry.getComponent(queryProfileName));
        if (queryProfileType == null) {
            throw new IllegalArgumentException("Could not resolve query profile type '" + queryProfileName + "'");
        }
        return new QueryProfileFieldType((QueryProfileType)((Object)registry.getComponent(queryProfileName)));
    }

    public QueryProfileFieldType() {
        this(null);
    }

    public QueryProfileFieldType(QueryProfileType type) {
        this.type = type;
    }

    public QueryProfileType getQueryProfileType() {
        return this.type;
    }

    @Override
    public Class<?> getValueClass() {
        return QueryProfile.class;
    }

    @Override
    public String stringValue() {
        return "query-profile" + (this.type != null ? ":" + this.type.getId().getName() : "");
    }

    @Override
    public String toString() {
        return "field type " + this.stringValue();
    }

    @Override
    public String toInstanceDescription() {
        return "reference to a query profile" + (this.type != null ? " of type '" + this.type.getId().getName() + "'" : "");
    }

    @Override
    public CompiledQueryProfile convertFrom(Object object, CompiledQueryProfileRegistry registry) {
        CompiledQueryProfile profile;
        String profileId = object.toString();
        if (profileId.startsWith("ref:")) {
            profileId = profileId.substring("ref:".length());
        }
        if ((profile = (CompiledQueryProfile)registry.getComponent(profileId)) == null) {
            return null;
        }
        if (this.type != null && !this.type.equals((Object)profile.getType())) {
            return null;
        }
        return profile;
    }

    @Override
    public QueryProfile convertFrom(Object object, QueryProfileRegistry registry) {
        QueryProfile profile;
        if (object instanceof String) {
            profile = (QueryProfile)registry.getComponent((String)object);
        } else if (object instanceof QueryProfile) {
            profile = (QueryProfile)object;
        } else {
            return null;
        }
        if (this.type != null && this.type != profile.getType()) {
            return null;
        }
        return profile;
    }

    public int hashCode() {
        if (this.type == null) {
            return 17;
        }
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryProfileFieldType)) {
            return false;
        }
        QueryProfileFieldType other = (QueryProfileFieldType)o;
        return this.equals(this.type.getId(), other.type.getId());
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

