/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.PrimitiveFieldType;
import com.yahoo.search.query.profile.types.QueryFieldType;
import com.yahoo.search.query.profile.types.QueryProfileFieldType;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;
import com.yahoo.search.query.profile.types.TensorFieldType;
import com.yahoo.search.yql.YqlQuery;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public abstract class FieldType {
    public static final PrimitiveFieldType stringType = new PrimitiveFieldType(String.class);
    public static final PrimitiveFieldType integerType = new PrimitiveFieldType(Integer.class);
    public static final PrimitiveFieldType longType = new PrimitiveFieldType(Long.class);
    public static final PrimitiveFieldType floatType = new PrimitiveFieldType(Float.class);
    public static final PrimitiveFieldType doubleType = new PrimitiveFieldType(Double.class);
    public static final PrimitiveFieldType booleanType = new PrimitiveFieldType(Boolean.class);
    public static final QueryFieldType queryType = new QueryFieldType();
    public static final QueryProfileFieldType genericQueryProfileType = new QueryProfileFieldType();

    public abstract Class getValueClass();

    public abstract String stringValue();

    public abstract String toString();

    public abstract String toInstanceDescription();

    public abstract Object convertFrom(Object var1, QueryProfileRegistry var2);

    public abstract Object convertFrom(Object var1, CompiledQueryProfileRegistry var2);

    public TensorType asTensorType() {
        return TensorType.empty;
    }

    public static FieldType fromString(String typeString, QueryProfileTypeRegistry registry) {
        if ("string".equals(typeString)) {
            return stringType;
        }
        if ("integer".equals(typeString)) {
            return integerType;
        }
        if ("long".equals(typeString)) {
            return longType;
        }
        if ("float".equals(typeString)) {
            return floatType;
        }
        if ("double".equals(typeString)) {
            return doubleType;
        }
        if ("boolean".equals(typeString)) {
            return booleanType;
        }
        if ("query".equals(typeString)) {
            return queryType;
        }
        if (typeString.startsWith("tensor")) {
            return TensorFieldType.fromTypeString(typeString);
        }
        if ("query-profile".equals(typeString)) {
            return genericQueryProfileType;
        }
        if (typeString.startsWith("query-profile:")) {
            return QueryProfileFieldType.fromString(typeString.substring("query-profile:".length()), registry);
        }
        throw new IllegalArgumentException("Unknown type '" + typeString + "'");
    }

    public static boolean isLegalFieldValue(Object value) {
        Class<?> clazz = value.getClass();
        if (clazz == String.class) {
            return true;
        }
        if (clazz == Integer.class) {
            return true;
        }
        if (clazz == Long.class) {
            return true;
        }
        if (clazz == Float.class) {
            return true;
        }
        if (clazz == Double.class) {
            return true;
        }
        if (clazz == Boolean.class) {
            return true;
        }
        if (clazz == YqlQuery.class) {
            return true;
        }
        if (clazz == QueryProfile.class) {
            return true;
        }
        return clazz == Tensor.class;
    }
}

