/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.container.util.Util;

public class ParameterParser {
    public static Long asMilliSeconds(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.longValue() * 1000L;
        }
        return ParameterParser.parseTime(value.toString());
    }

    private static Long parseTime(String time) throws NumberFormatException {
        time = time.trim();
        try {
            int unitOffset = ParameterParser.findUnitOffset(time);
            double measure = Double.valueOf(time.substring(0, unitOffset));
            double multiplier = ParameterParser.parseUnit(time.substring(unitOffset));
            return (long)(measure * multiplier);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error parsing " + Util.quote((Object)time), e);
        }
    }

    private static int findUnitOffset(String time) {
        char c;
        int unitOffset;
        for (unitOffset = 0; unitOffset < time.length() && ((c = time.charAt(unitOffset)) == '.' || c >= '0' && c <= '9'); ++unitOffset) {
        }
        if (unitOffset == 0) {
            throw new NumberFormatException("Invalid number " + Util.quote((Object)time));
        }
        return unitOffset;
    }

    private static double parseUnit(String unit) {
        double multiplier = "ks".equals(unit = unit.trim()) ? 1000000.0 : ("s".equals(unit) ? 1000.0 : ("ms".equals(unit) ? 1.0 : ("\u00b5s".equals(unit) ? 0.001 : 1000.0)));
        return multiplier;
    }
}

