/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.engine.resolvers;

import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.pagetemplates.engine.Resolution;
import com.yahoo.search.pagetemplates.engine.Resolver;
import com.yahoo.search.pagetemplates.model.Choice;
import com.yahoo.search.pagetemplates.model.MapChoice;
import com.yahoo.search.pagetemplates.model.PageElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class RandomResolver
extends Resolver {
    public static final String nativeId = "native.random";
    private Random random = new Random(System.currentTimeMillis());

    public RandomResolver() {
    }

    protected RandomResolver(String id) {
        super(id);
    }

    @Override
    public void resolve(Choice choice, Query query, Result result, Resolution resolution) {
        resolution.addChoiceResolution(choice, this.random.nextInt(choice.alternatives().size()));
    }

    @Override
    public void resolve(MapChoice choice, Query query, Result result, Resolution resolution) {
        HashMap<String, List<PageElement>> mapping = new HashMap<String, List<PageElement>>();
        List<String> placeholderIds = choice.placeholderIds();
        ArrayList<List<PageElement>> valueList = new ArrayList<List<PageElement>>(choice.values());
        for (String placeholderId : placeholderIds) {
            mapping.put(placeholderId, (List<PageElement>)valueList.remove(this.random.nextInt(valueList.size())));
        }
        resolution.addMapChoiceResolution(choice, mapping);
    }
}

