/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.handler;

import com.google.inject.Inject;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.Vtag;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainsConfigurer;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.component.chain.model.ChainsModelBuilder;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.container.core.ContainerHttpConfig;
import com.yahoo.container.core.QrTemplatesConfig;
import com.yahoo.container.handler.Coverage;
import com.yahoo.container.handler.Timing;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.jdisc.VespaHeaders;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.container.protect.FreezeDetector;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.language.Linguistics;
import com.yahoo.log.LogLevel;
import com.yahoo.net.HostName;
import com.yahoo.net.UriTools;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.IndexModel;
import com.yahoo.prelude.query.QueryException;
import com.yahoo.prelude.query.parser.ParseException;
import com.yahoo.prelude.query.parser.SpecialTokenRegistry;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.handler.HttpSearchResponse;
import com.yahoo.search.handler.SearchResponse;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileConfigurer;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.search.query.properties.DefaultProperties;
import com.yahoo.search.rendering.Renderer;
import com.yahoo.search.rendering.RendererRegistry;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.search.statistics.ElapsedTime;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.statistics.Callback;
import com.yahoo.statistics.Handle;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.configdefinition.SpecialtokensConfig;
import com.yahoo.yolean.Exceptions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchHandler
extends LoggingRequestHandler {
    private final AtomicInteger requestsInFlight = new AtomicInteger(0);
    private final int maxThreads;
    private static final CompoundName DETAILED_TIMING_LOGGING = new CompoundName("trace.timingDetails");
    private static final String SEARCH_CONNECTIONS = "search_connections";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static Logger log = Logger.getLogger(SearchHandler.class.getName());
    private Value searchConnections;
    private final SearchChainRegistry searchChainRegistry;
    private final RendererRegistry rendererRegistry;
    private final IndexFacts indexFacts;
    private final SpecialTokenRegistry specialTokens;
    public static final String defaultSearchChainName = "default";
    private static final String fallbackSearchChain = "vespa";
    private static final CompoundName FORCE_TIMESTAMPS = new CompoundName("trace.timestamps");
    private final Linguistics linguistics;
    private final CompiledQueryProfileRegistry queryProfileRegistry;
    private final Optional<String> hostResponseHeaderKey;
    private final String selfHostname = HostName.getLocalhost();

    @Inject
    public SearchHandler(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, QrSearchersConfig clusters, SpecialtokensConfig specialtokens, Statistics statistics, Linguistics linguistics, Metric metric, ComponentRegistry<com.yahoo.processing.rendering.Renderer> renderers, Executor executor, AccessLog accessLog, QueryProfilesConfig queryProfileConfig, ComponentRegistry<Searcher> searchers, ContainerHttpConfig containerHttpConfig) {
        super(executor, accessLog, metric, true);
        log.log((Level)LogLevel.DEBUG, "SearchHandler.init " + System.identityHashCode((Object)this));
        this.searchChainRegistry = new SearchChainRegistry(searchers);
        this.setupSearchChainRegistry(searchers, chainsConfig);
        this.indexFacts = new IndexFacts(new IndexModel(indexInfo, clusters));
        this.indexFacts.freeze();
        this.specialTokens = new SpecialTokenRegistry(specialtokens);
        this.rendererRegistry = new RendererRegistry(renderers.allComponents());
        QueryProfileRegistry queryProfileRegistry = QueryProfileConfigurer.createFromConfig(queryProfileConfig);
        this.queryProfileRegistry = queryProfileRegistry.compile();
        this.linguistics = linguistics;
        this.maxThreads = SearchHandler.examineExecutor(executor);
        this.searchConnections = new Value(SEARCH_CONNECTIONS, statistics, new Value.Parameters().setLogRaw(Boolean.valueOf(true)).setLogMax(Boolean.valueOf(true)).setLogMean(Boolean.valueOf(true)).setLogMin(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(true)).setCallback((Callback)new MeanConnections()));
        this.hostResponseHeaderKey = containerHttpConfig.hostResponseHeaderKey().equals("") ? Optional.empty() : Optional.of(containerHttpConfig.hostResponseHeaderKey());
    }

    @Deprecated
    public SearchHandler(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, QrSearchersConfig clusters, SpecialtokensConfig specialtokens, Statistics statistics, Linguistics linguistics, Metric metric, ComponentRegistry<com.yahoo.processing.rendering.Renderer> renderers, Executor executor, AccessLog accessLog, QueryProfilesConfig queryProfileConfig, ComponentRegistry<Searcher> searchers) {
        this(chainsConfig, indexInfo, clusters, specialtokens, statistics, linguistics, metric, renderers, executor, accessLog, queryProfileConfig, searchers, new ContainerHttpConfig(new ContainerHttpConfig.Builder()));
    }

    @Deprecated
    public SearchHandler(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, QrSearchersConfig clusters, SpecialtokensConfig specialTokens, QrTemplatesConfig ignored, FreezeDetector ignored2, Statistics statistics, Linguistics linguistics, Metric metric, ComponentRegistry<com.yahoo.processing.rendering.Renderer> renderers, Executor executor, AccessLog accessLog, QueryProfilesConfig queryProfileConfig, ComponentRegistry<Searcher> searchers) {
        this(chainsConfig, indexInfo, clusters, specialTokens, statistics, linguistics, metric, renderers, executor, accessLog, queryProfileConfig, searchers);
    }

    protected void destroy() {
        super.destroy();
        this.rendererRegistry.deconstruct();
    }

    private void setupSearchChainRegistry(ComponentRegistry<Searcher> searchers, ChainsConfig chainsConfig) {
        ChainsModel chainsModel = ChainsModelBuilder.buildFromConfig((ChainsConfig)chainsConfig);
        ChainsConfigurer.prepareChainRegistry((ComponentRegistry)this.searchChainRegistry, (ChainsModel)chainsModel, searchers);
        this.searchChainRegistry.freeze();
    }

    private static int examineExecutor(Executor executor) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getMaximumPoolSize();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpResponse handle(HttpRequest request) {
        this.requestsInFlight.incrementAndGet();
        try {
            HttpSearchResponse httpSearchResponse = this.handleBody(request);
            return httpSearchResponse;
        }
        catch (QueryException e) {
            HttpResponse httpResponse = e.getCause() instanceof IllegalArgumentException ? this.invalidParameterResponse(request, e) : this.illegalQueryResponse(request, e);
            return httpResponse;
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Failed handling " + request, e);
            HttpResponse httpResponse = this.internalServerErrorResponse(request, e);
            return httpResponse;
        }
        finally {
            this.requestsInFlight.decrementAndGet();
        }
    }

    private int getHttpResponseStatus(HttpRequest httpRequest, Result result) {
        boolean benchmarkOutput = VespaHeaders.benchmarkOutput((HttpRequest)httpRequest);
        if (benchmarkOutput) {
            return VespaHeaders.getEagerErrorStatus((ErrorMessage)result.hits().getError(), SearchResponse.getErrorIterator(result.hits().getErrorHit()));
        }
        return VespaHeaders.getStatus((boolean)SearchResponse.isSuccess(result), (ErrorMessage)result.hits().getError(), SearchResponse.getErrorIterator(result.hits().getErrorHit()));
    }

    private HttpResponse errorResponse(HttpRequest request, com.yahoo.search.result.ErrorMessage errorMessage) {
        Query query = new Query();
        Result result = new Result(query, errorMessage);
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.getRendererCopy(ComponentSpecification.fromString((String)request.getProperty("format")));
        result.getTemplating().setRenderer(renderer);
        return new HttpSearchResponse(this.getHttpResponseStatus(request, result), result, query, renderer);
    }

    private HttpResponse invalidParameterResponse(HttpRequest request, RuntimeException e) {
        return this.errorResponse(request, com.yahoo.search.result.ErrorMessage.createInvalidQueryParameter(Exceptions.toMessageString((Throwable)e)));
    }

    private HttpResponse illegalQueryResponse(HttpRequest request, RuntimeException e) {
        return this.errorResponse(request, com.yahoo.search.result.ErrorMessage.createIllegalQuery(Exceptions.toMessageString((Throwable)e)));
    }

    private HttpResponse internalServerErrorResponse(HttpRequest request, RuntimeException e) {
        return this.errorResponse(request, com.yahoo.search.result.ErrorMessage.createInternalServerError(Exceptions.toMessageString((Throwable)e)));
    }

    private HttpSearchResponse handleBody(HttpRequest request) {
        com.yahoo.processing.rendering.Renderer<Result> renderer;
        Result result;
        Map<String, String> requestMap = this.requestMapFromRequest(request);
        String queryProfileName = requestMap.getOrDefault("queryProfile", null);
        CompiledQueryProfile queryProfile = this.queryProfileRegistry.findQueryProfile(queryProfileName);
        Query query = new Query(request, requestMap, queryProfile);
        boolean benchmarkOutput = VespaHeaders.benchmarkOutput((HttpRequest)request);
        boolean benchmarkCoverage = VespaHeaders.benchmarkCoverage((boolean)benchmarkOutput, (HeaderFields)request.getJDiscRequest().headers());
        String invalidReason = query.validate();
        Chain searchChain = null;
        String searchChainName = null;
        if (invalidReason == null) {
            Tuple2<String, Chain<Searcher>> nameAndChain = this.resolveChain(query.properties().getString(Query.SEARCH_CHAIN));
            searchChainName = (String)nameAndChain.first;
            searchChain = (Chain)nameAndChain.second;
        }
        if (invalidReason != null) {
            result = new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery(invalidReason));
        } else if (queryProfile == null && queryProfileName != null) {
            result = new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery("Could not resolve query profile '" + queryProfileName + "'"));
        } else if (searchChain == null) {
            result = new Result(query, com.yahoo.search.result.ErrorMessage.createInvalidQueryParameter("No search chain named '" + searchChainName + "' was found"));
        } else {
            String pathAndQuery = UriTools.rawRequest((URI)request.getUri());
            result = this.search(pathAndQuery, query, (Chain<Searcher>)searchChain, this.searchChainRegistry);
        }
        if (result.getTemplating().usesDefaultTemplate()) {
            renderer = this.toRendererCopy(query.getPresentation().getRenderer());
            result.getTemplating().setRenderer(renderer);
        } else {
            renderer = this.perRenderingCopy(result.getTemplating().getRenderer());
        }
        HttpSearchResponse response = new HttpSearchResponse(this.getHttpResponseStatus(request, result), result, query, renderer);
        if (this.hostResponseHeaderKey.isPresent()) {
            response.headers().add(this.hostResponseHeaderKey.get(), this.selfHostname);
        }
        if (benchmarkOutput) {
            VespaHeaders.benchmarkOutput((HeaderFields)response.headers(), (boolean)benchmarkCoverage, (Timing)response.getTiming(), (HitCounts)response.getHitCounts(), (int)SearchHandler.getErrors(result), (Coverage)response.getCoverage());
        }
        return response;
    }

    private static int getErrors(Result result) {
        return result.hits().getErrorHit() == null ? 0 : 1;
    }

    @NonNull
    private com.yahoo.processing.rendering.Renderer<Result> toRendererCopy(ComponentSpecification format) {
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.rendererRegistry.getRenderer(format);
        renderer = this.perRenderingCopy(renderer);
        return renderer;
    }

    private Tuple2<String, Chain<Searcher>> resolveChain(String explicitChainName) {
        Chain<Searcher> searchChain;
        String chainName = explicitChainName;
        if (chainName == null) {
            chainName = defaultSearchChainName;
        }
        if ((searchChain = this.searchChainRegistry.getChain(chainName)) == null && explicitChainName == null) {
            chainName = fallbackSearchChain;
            searchChain = this.searchChainRegistry.getChain(chainName);
        }
        return new Tuple2((Object)chainName, searchChain);
    }

    public Result searchAndFill(Query query, Chain<? extends Searcher> searchChain, SearchChainRegistry registry) {
        Result result;
        Result errorResult = this.validateQuery(query);
        if (errorResult != null) {
            return errorResult;
        }
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.rendererRegistry.getRenderer(query.getPresentation().getRenderer());
        if (query.getPresentation().getSummary() == null && renderer instanceof Renderer) {
            query.getPresentation().setSummary(((Renderer)renderer).getDefaultSummaryClass());
        }
        Execution execution = new Execution(searchChain, new Execution.Context(registry, this.indexFacts, this.specialTokens, this.rendererRegistry, this.linguistics));
        query.getModel().setExecution(execution);
        execution.trace().setForceTimestamps(query.properties().getBoolean(FORCE_TIMESTAMPS, false));
        if (query.properties().getBoolean(DETAILED_TIMING_LOGGING, false)) {
            execution.context().setDetailedDiagnostics(true);
        }
        if ((result = execution.search(query)).getTemplating() == null) {
            result.getTemplating().setRenderer(renderer);
        }
        this.ensureQuerySet(result, query);
        execution.fill(result, result.getQuery().getPresentation().getSummary());
        this.traceExecutionTimes(query, result);
        this.traceVespaVersion(query);
        this.traceRequestAttributes(query);
        return result;
    }

    private void traceRequestAttributes(Query query) {
        int miminumTraceLevel = 7;
        if (query.getTraceLevel() >= 7) {
            query.trace("Request attributes: " + query.getHttpRequest().getJDiscRequest().context(), miminumTraceLevel);
        }
    }

    public com.yahoo.processing.rendering.Renderer<Result> getRendererCopy(ComponentSpecification spec) {
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.rendererRegistry.getRenderer(spec);
        return this.perRenderingCopy(renderer);
    }

    @NonNull
    private com.yahoo.processing.rendering.Renderer<Result> perRenderingCopy(com.yahoo.processing.rendering.Renderer<Result> renderer) {
        com.yahoo.processing.rendering.Renderer copy = renderer.clone();
        copy.init();
        return copy;
    }

    private void ensureQuerySet(Result result, Query fallbackQuery) {
        Query query = result.getQuery();
        if (query == null) {
            result.setQuery(fallbackQuery);
        }
    }

    private Result search(String request, Query query, Chain<Searcher> searchChain, SearchChainRegistry registry) {
        if (query.getTraceLevel() >= 2) {
            query.trace("Invoking " + searchChain, false, 2);
        }
        if (this.searchConnections != null) {
            this.connectionStatistics();
        } else {
            log.log(LogLevel.WARNING, "searchConnections is a null reference, probably a known race condition during startup.", new IllegalStateException("searchConnections reference is null."));
        }
        try {
            return this.searchAndFill(query, searchChain, registry);
        }
        catch (ParseException e) {
            com.yahoo.search.result.ErrorMessage error = com.yahoo.search.result.ErrorMessage.createIllegalQuery("Could not parse query [" + request + "]: " + Exceptions.toMessageString((Throwable)e));
            log.log((Level)LogLevel.DEBUG, () -> error.getDetailedMessage());
            return new Result(query, error);
        }
        catch (IllegalArgumentException e) {
            com.yahoo.search.result.ErrorMessage error = com.yahoo.search.result.ErrorMessage.createBadRequest("Invalid search request [" + request + "]: " + Exceptions.toMessageString((Throwable)e));
            log.log((Level)LogLevel.DEBUG, () -> error.getDetailedMessage());
            return new Result(query, error);
        }
        catch (LinkageError e) {
            com.yahoo.search.result.ErrorMessage error = com.yahoo.search.result.ErrorMessage.createErrorInPluginSearcher("Error executing " + searchChain + "]: " + Exceptions.toMessageString((Throwable)e), e);
            this.log(request, query, e);
            return new Result(query, error);
        }
        catch (StackOverflowError e) {
            com.yahoo.search.result.ErrorMessage error = com.yahoo.search.result.ErrorMessage.createErrorInPluginSearcher("Error executing " + searchChain + "]: " + Exceptions.toMessageString((Throwable)e), e);
            this.log(request, query, e);
            return new Result(query, error);
        }
        catch (Exception e) {
            Result result = new Result(query);
            this.log(request, query, e);
            result.hits().addError(com.yahoo.search.result.ErrorMessage.createUnspecifiedError("Failed searching: " + Exceptions.toMessageString((Throwable)e), e));
            return result;
        }
    }

    private void connectionStatistics() {
        long maxThreadsAsLong;
        long connectionsAsLong;
        int connections = this.requestsInFlight.intValue();
        this.searchConnections.put((double)connections);
        if (this.maxThreads > 3 && (connectionsAsLong = (long)connections) >= (maxThreadsAsLong = (long)this.maxThreads) * 9L / 10L) {
            if (connectionsAsLong == maxThreadsAsLong * 9L / 10L) {
                log.log(Level.WARNING, this.threadConsumptionMessage(connections, this.maxThreads, "90"));
            } else if (connectionsAsLong == maxThreadsAsLong * 95L / 100L) {
                log.log(Level.WARNING, this.threadConsumptionMessage(connections, this.maxThreads, "95"));
            } else if (connectionsAsLong == maxThreadsAsLong) {
                log.log(Level.WARNING, this.threadConsumptionMessage(connections, this.maxThreads, "100"));
            }
        }
    }

    private String threadConsumptionMessage(int connections, int maxThreads, String percentage) {
        return percentage + "% of possible search connections (" + connections + " of maximum " + maxThreads + ") currently active.";
    }

    private void log(String request, Query query, Throwable e) {
        if (e.getStackTrace().length == 0) {
            log.log((Level)LogLevel.ERROR, "Failed executing " + query.toDetailString() + " [" + request + "], received exception with no context", e);
        } else {
            log.log((Level)LogLevel.ERROR, "Failed executing " + query.toDetailString() + " [" + request + "]", e);
        }
    }

    private Result validateQuery(Query query) {
        if (query.getHttpRequest().getProperty(DefaultProperties.MAX_HITS.toString()) != null) {
            throw new RuntimeException(DefaultProperties.MAX_HITS + " must be specified in a query profile.");
        }
        if (query.getHttpRequest().getProperty(DefaultProperties.MAX_OFFSET.toString()) != null) {
            throw new RuntimeException(DefaultProperties.MAX_OFFSET + " must be specified in a query profile.");
        }
        int maxHits = query.properties().getInteger(DefaultProperties.MAX_HITS);
        int maxOffset = query.properties().getInteger(DefaultProperties.MAX_OFFSET);
        if (query.getHits() > maxHits) {
            return new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery(query.getHits() + " hits requested, configured limit: " + maxHits + "."));
        }
        if (query.getOffset() > maxOffset) {
            return new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery("Offset of " + query.getOffset() + " requested, configured limit: " + maxOffset + "."));
        }
        return null;
    }

    private void traceExecutionTimes(Query query, Result result) {
        if (query.getTraceLevel() < 3) {
            return;
        }
        ElapsedTime elapsedTime = result.getElapsedTime();
        long now = System.currentTimeMillis();
        if (elapsedTime.firstFill() != 0L) {
            query.trace("Query time " + query + ": " + (elapsedTime.firstFill() - elapsedTime.first()) + " ms", false, 3);
            query.trace("Summary fetch time " + query + ": " + (now - elapsedTime.firstFill()) + " ms", false, 3);
        } else {
            query.trace("Total search time " + query + ": " + (now - elapsedTime.first()) + " ms", false, 3);
        }
    }

    private void traceVespaVersion(Query query) {
        query.trace("Vespa version: " + Vtag.currentVersion.toString(), false, 4);
    }

    public SearchChainRegistry getSearchChainRegistry() {
        return this.searchChainRegistry;
    }

    private Map<String, String> requestMapFromRequest(HttpRequest request) {
        if (request.getMethod() == HttpRequest.Method.POST && JSON_CONTENT_TYPE.equals(request.getHeader("Content-Type"))) {
            Cursor inspector;
            try {
                byte[] byteArray = IOUtils.readBytes((InputStream)request.getData(), (int)0x100000);
                inspector = SlimeUtils.jsonToSlime((byte[])byteArray).get();
                if (inspector.field("error_message").valid()) {
                    throw new QueryException("Illegal query: " + inspector.field("error_message").asString() + ", at: " + new String(inspector.field("offending_input").asData(), StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Problem with reading from input-stream", e);
            }
            HashMap<String, String> requestMap = new HashMap<String, String>();
            this.createRequestMapping((Inspector)inspector, requestMap, "");
            requestMap.putAll(request.propertyMap());
            if (requestMap.containsKey("yql") && (requestMap.containsKey("select.where") || requestMap.containsKey("select.grouping"))) {
                throw new QueryException("Illegal query: Query contains both yql- and select-parameter");
            }
            if (requestMap.containsKey("query") && (requestMap.containsKey("select.where") || requestMap.containsKey("select.grouping"))) {
                throw new QueryException("Illegal query: Query contains both query- and select-parameter");
            }
            return requestMap;
        }
        return request.propertyMap();
    }

    public void createRequestMapping(Inspector inspector, Map<String, String> map, String parent) {
        inspector.traverse((key, value) -> {
            String qualifiedKey = parent + key;
            switch (value.type()) {
                case BOOL: {
                    map.put(qualifiedKey, Boolean.toString(value.asBool()));
                    break;
                }
                case DOUBLE: {
                    map.put(qualifiedKey, Double.toString(value.asDouble()));
                    break;
                }
                case LONG: {
                    map.put(qualifiedKey, Long.toString(value.asLong()));
                    break;
                }
                case STRING: {
                    map.put(qualifiedKey, value.asString());
                    break;
                }
                case ARRAY: {
                    map.put(qualifiedKey, value.asString());
                    break;
                }
                case OBJECT: {
                    if (qualifiedKey.equals("select.where") || qualifiedKey.equals("select.grouping")) {
                        map.put(qualifiedKey, value.toString());
                        break;
                    }
                    this.createRequestMapping(value, map, qualifiedKey + ".");
                }
            }
        });
    }

    private final class MeanConnections
    implements Callback {
        private MeanConnections() {
        }

        public void run(Handle h, boolean firstTime) {
            if (firstTime) {
                SearchHandler.this.metric.set(SearchHandler.SEARCH_CONNECTIONS, (Number)0.0, null);
                return;
            }
            Value v = (Value)h;
            SearchHandler.this.metric.set(SearchHandler.SEARCH_CONNECTIONS, (Number)v.getMean(), null);
        }
    }
}

