/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.vespa;

import com.google.inject.Inject;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.ComponentId;
import com.yahoo.component.Version;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.language.Linguistics;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.QueryCanonicalizer;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cache.QrBinaryCacheConfig;
import com.yahoo.search.cache.QrBinaryCacheRegionConfig;
import com.yahoo.search.federation.ProviderConfig;
import com.yahoo.search.federation.http.ConfiguredHTTPProviderSearcher;
import com.yahoo.search.federation.http.Connection;
import com.yahoo.search.federation.vespa.QueryMarshaller;
import com.yahoo.search.federation.vespa.ResultBuilder;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.textserialize.TextSerialize;
import com.yahoo.search.yql.MinimalQueryInserter;
import com.yahoo.statistics.Statistics;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Deprecated
@Provides(value={"Vespa"})
@After(value={"*"})
public class VespaSearcher
extends ConfiguredHTTPProviderSearcher {
    private final ThreadLocal<XMLReader> readerHolder = new ThreadLocal();
    private final Query.Type queryType;
    private final Tuple2<String, Version> segmenterVersion;
    private static final CompoundName select = new CompoundName("select");
    private static final CompoundName streamingUserid = new CompoundName("streaming.userid");
    private static final CompoundName streamingGroupname = new CompoundName("streaming.groupname");
    private static final CompoundName streamingSelection = new CompoundName("streaming.selection");

    public VespaSearcher(ComponentId id, ProviderConfig config, QrBinaryCacheConfig c, QrBinaryCacheRegionConfig r, Statistics statistics) {
        this(id, config, c, r, statistics, null);
    }

    @Inject
    public VespaSearcher(ComponentId id, ProviderConfig config, QrBinaryCacheConfig c, QrBinaryCacheRegionConfig r, Statistics statistics, @Nullable Linguistics linguistics) {
        super(id, config, c, r, statistics);
        this.queryType = this.toQueryType(config.queryType());
        this.segmenterVersion = linguistics == null ? null : linguistics.getVersion(Linguistics.Component.SEGMENTER);
    }

    public VespaSearcher(String idString, String host, int port, String path) {
        super(idString, host, port, path, Statistics.nullImplementation);
        this.queryType = this.toQueryType(ProviderConfig.QueryType.LEGACY);
        this.segmenterVersion = null;
    }

    void addProperty(Map<String, String> queryMap, Query query, CompoundName property) {
        Object o = query.properties().get(property);
        if (o != null) {
            queryMap.put(property.toString(), o.toString());
        }
    }

    @Override
    public Map<String, String> getQueryMap(Query query) {
        Map<String, String> queryMap = this.getQueryMapWithoutHitsOffset(query);
        queryMap.put("offset", Integer.toString(query.getOffset()));
        queryMap.put("hits", Integer.toString(query.getHits()));
        queryMap.put("presentation.format", "xml");
        this.addProperty(queryMap, query, select);
        this.addProperty(queryMap, query, streamingUserid);
        this.addProperty(queryMap, query, streamingGroupname);
        this.addProperty(queryMap, query, streamingSelection);
        return queryMap;
    }

    @Override
    public Map<String, String> getCacheKey(Query q) {
        return this.getQueryMapWithoutHitsOffset(q);
    }

    private Map<String, String> getQueryMapWithoutHitsOffset(Query query) {
        Map<String, String> queryMap = super.getQueryMap(query);
        if (this.queryType == Query.Type.YQL) {
            queryMap.put(MinimalQueryInserter.YQL.toString(), this.marshalQuery(query));
        } else {
            queryMap.put("query", this.marshalQuery(query.getModel().getQueryTree()));
            queryMap.put("type", this.queryType.toString());
        }
        this.addNonExcludedSourceProperties(query, queryMap);
        return queryMap;
    }

    Query.Type toQueryType(ProviderConfig.QueryType.Enum providerQueryType) {
        if (providerQueryType == ProviderConfig.QueryType.LEGACY) {
            return Query.Type.ADVANCED;
        }
        if (providerQueryType == ProviderConfig.QueryType.PROGRAMMATIC) {
            return Query.Type.PROGRAMMATIC;
        }
        if (providerQueryType == ProviderConfig.QueryType.YQL) {
            return Query.Type.YQL;
        }
        if (providerQueryType == ProviderConfig.QueryType.SELECT) {
            return Query.Type.SELECT;
        }
        throw new RuntimeException("Query type " + (Object)((Object)providerQueryType) + " unsupported.");
    }

    public String marshalQuery(Query query) {
        if (this.queryType != Query.Type.YQL) {
            return this.marshalQuery(query.getModel().getQueryTree());
        }
        query.getModel().getQueryTree();
        Query workQuery = query.clone();
        String error = QueryCanonicalizer.canonicalize(workQuery);
        if (error != null) {
            this.getLogger().log(LogLevel.WARNING, "Could not normalize [" + query.toString() + "]: " + error);
            return null;
        }
        this.chooseYqlSources(workQuery.getModel().getSources());
        this.chooseYqlSummaryFields(workQuery.getPresentation().getSummaryFields());
        return workQuery.yqlRepresentation(this.getSegmenterVersion(), false);
    }

    public String marshalQuery(QueryTree root) {
        QueryTree rootClone = root.clone();
        String error = QueryCanonicalizer.canonicalize(rootClone);
        if (error != null) {
            return null;
        }
        return this.marshalRoot(rootClone.getRoot());
    }

    private String marshalRoot(Item root) {
        switch (this.queryType) {
            case ADVANCED: {
                return new QueryMarshaller().marshal(root);
            }
            case PROGRAMMATIC: {
                return TextSerialize.serialize(root);
            }
        }
        throw new RuntimeException("Unsupported query type.");
    }

    private XMLReader getReader() {
        XMLReader reader = this.readerHolder.get();
        if (reader == null) {
            reader = ResultBuilder.createParser();
            this.readerHolder.set(reader);
        }
        return reader;
    }

    @Override
    public void unmarshal(InputStream stream, long contentLength, Result result) {
        ResultBuilder parser = new ResultBuilder(this.getReader());
        Result mResult = parser.parse(new InputSource(stream), result.getQuery());
        result.mergeWith(mResult);
        result.hits().addAll(mResult.hits().asUnorderedHits());
    }

    @Override
    public URI getPingURI(Connection connection) throws MalformedURLException, URISyntaxException {
        return new URL(this.getParameters().getSchema(), connection.getHost(), connection.getPort(), "/status.html").toURI();
    }

    protected Tuple2<String, Version> getSegmenterVersion() {
        return this.segmenterVersion;
    }

    protected void chooseYqlSources(Set<String> sources) {
        sources.clear();
    }

    protected void chooseYqlSummaryFields(Set<String> summaryFields) {
        summaryFields.clear();
    }
}

