/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.vespa;

import com.yahoo.log.LogLevel;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.Relevance;
import com.yahoo.text.Lowercase;
import com.yahoo.text.XML;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@Deprecated
public class ResultBuilder
extends DefaultHandler {
    private static final String ERROR = "error";
    private static final String FIELD = "field";
    private static Logger log = Logger.getLogger(ResultBuilder.class.getName());
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = false;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    private StringBuilder fieldContent;
    private String fieldName;
    private int fieldLevel = 0;
    private boolean hasLiteralTags = false;
    private Map<String, Object> hitFields = new HashMap<String, Object>();
    private String hitType;
    private String hitRelevance;
    private String hitSource;
    private int offset = 0;
    private List<Tag> tagStack = new ArrayList<Tag>();
    private final XMLReader parser;
    private Query query;
    private Result result;
    Deque<ResultPart> location = new ArrayDeque<ResultPart>(10);
    private String currentErrorCode;
    private String currentError;
    private Deque<HitGroup> hitGroups = new ArrayDeque<HitGroup>(5);

    public ResultBuilder() throws RuntimeException {
        this(ResultBuilder.createParser());
    }

    public ResultBuilder(XMLReader parser) {
        this.parser = parser;
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
    }

    public static XMLReader createParser() {
        ClassLoader savedContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SAXParser.class.getClassLoader());
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
            ResultBuilder.setParserFeatures(reader);
            XMLReader xMLReader = reader;
            return xMLReader;
        }
        catch (Exception e) {
            throw new RuntimeException("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedContextClassLoader);
        }
    }

    private static void setParserFeatures(XMLReader reader) {
        try {
            reader.setFeature(NAMESPACES_FEATURE_ID, false);
        }
        catch (SAXException e) {
            log.log(LogLevel.WARNING, "warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
        }
        try {
            reader.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, false);
        }
        catch (SAXException e) {
            log.log(LogLevel.WARNING, "warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
        }
        try {
            reader.setFeature(VALIDATION_FEATURE_ID, false);
        }
        catch (SAXException e) {
            log.log(LogLevel.WARNING, "warning: Parser does not support feature (http://xml.org/sax/features/validation)");
        }
        try {
            reader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, false);
        }
        catch (SAXNotRecognizedException e) {
            log.log(LogLevel.WARNING, "warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema)");
        }
        catch (SAXNotSupportedException e) {
            log.log(LogLevel.WARNING, "warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
        }
        try {
            reader.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, false);
        }
        catch (SAXNotRecognizedException e) {
            log.log(LogLevel.WARNING, "warning: Parser does not recognize feature (http://apache.org/xml/features/validation/dynamic)");
        }
        catch (SAXNotSupportedException e) {
            log.log(LogLevel.WARNING, "warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        this.result = new Result(this.query);
        this.hitGroups.addFirst(this.result.hits());
        this.location.addFirst(ResultPart.ROOT);
    }

    private void reset() {
        this.result = null;
        this.fieldLevel = 0;
        this.hasLiteralTags = false;
        this.tagStack = null;
        this.fieldContent = null;
        this.offset = 0;
        this.currentError = null;
        this.currentErrorCode = null;
        this.hitGroups.clear();
        this.location.clear();
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        switch (this.location.peekFirst()) {
            case HIT: {
                if (this.fieldLevel > 0) {
                    this.tagInField(raw, attrs, FIELD);
                    ++this.offset;
                    return;
                }
                if (!FIELD.equals(raw)) break;
                ++this.fieldLevel;
                this.fieldName = attrs.getValue("name");
                this.fieldContent = new StringBuilder();
                this.hasLiteralTags = false;
                break;
            }
            case ERRORDETAILS: {
                if (this.fieldLevel > 0) {
                    this.tagInField(raw, attrs, ERROR);
                    ++this.offset;
                    return;
                }
                if (!ERROR.equals(raw)) break;
                if (attrs != null) {
                    this.currentErrorCode = attrs.getValue("code");
                    this.currentError = attrs.getValue(ERROR);
                }
                ++this.fieldLevel;
                this.fieldContent = new StringBuilder();
                this.hasLiteralTags = false;
                break;
            }
            case HITGROUP: {
                if ("hit".equals(raw)) {
                    this.startHit(attrs);
                    break;
                }
                if (!"group".equals(raw)) break;
                this.startHitGroup(attrs);
                break;
            }
            case ROOT: {
                if ("hit".equals(raw)) {
                    this.startHit(attrs);
                    break;
                }
                if ("errordetails".equals(raw)) {
                    this.location.addFirst(ResultPart.ERRORDETAILS);
                    break;
                }
                if ("result".equals(raw)) {
                    String total;
                    if (attrs == null || (total = attrs.getValue("total-hit-count")) == null) break;
                    this.result.setTotalHitCount(Long.valueOf(total));
                    break;
                }
                if ("group".equals(raw)) {
                    this.startHitGroup(attrs);
                    break;
                }
                if (!ERROR.equals(raw) || attrs == null) break;
                this.currentErrorCode = attrs.getValue("code");
                this.fieldContent = new StringBuilder();
            }
        }
        ++this.offset;
    }

    private void startHitGroup(Attributes attrs) {
        String source;
        HitGroup g = new HitGroup();
        Set<String> types = g.types();
        if (attrs != null) {
            String groupType = attrs.getValue("type");
            if (groupType != null) {
                for (String s : groupType.split(" ")) {
                    if (s.length() <= 0) continue;
                    types.add(s);
                }
            }
            source = attrs.getValue("source");
        } else {
            source = null;
        }
        g.setId(source != null ? source : "dummy");
        this.hitGroups.peekFirst().add(g);
        this.hitGroups.addFirst(g);
        this.location.addFirst(ResultPart.HITGROUP);
    }

    private void startHit(Attributes attrs) {
        this.hitFields.clear();
        this.location.addFirst(ResultPart.HIT);
        if (attrs != null) {
            this.hitRelevance = attrs.getValue("relevancy");
            this.hitSource = attrs.getValue("source");
            this.hitType = attrs.getValue("type");
        } else {
            this.hitRelevance = null;
            this.hitSource = null;
            this.hitType = null;
        }
    }

    private void tagInField(String tag, Attributes attrs, String enclosingTag) {
        Tag prevTag;
        if (!this.hasLiteralTags) {
            this.hasLiteralTags = true;
            String fieldTillNow = XML.xmlEscape((String)this.fieldContent.toString(), (boolean)false);
            this.fieldContent = new StringBuilder(fieldTillNow);
            this.tagStack = new ArrayList<Tag>();
        }
        if (enclosingTag.equals(tag)) {
            ++this.fieldLevel;
        }
        if (this.tagStack.size() > 0 && (prevTag = this.tagStack.get(this.tagStack.size() - 1)) != null && prevTag.offset + 1 == this.offset) {
            this.fieldContent.append(">");
        }
        this.fieldContent.append("<").append(tag);
        if (attrs != null) {
            int attrCount = attrs.getLength();
            for (int i = 0; i < attrCount; ++i) {
                this.fieldContent.append(" ").append(attrs.getQName(i)).append("=\"").append(XML.xmlEscape((String)attrs.getValue(i), (boolean)true)).append("\"");
            }
        }
        this.tagStack.add(new Tag(tag, this.offset));
    }

    private void endElementInField(String qName, String enclosingTag) {
        Tag prevTag = this.tagStack.get(this.tagStack.size() - 1);
        if (qName.equals(prevTag.name) && this.offset == prevTag.offset + 1) {
            this.fieldContent.append(" />");
        } else {
            this.fieldContent.append("</").append(qName).append('>');
        }
        if (prevTag.name.equals(qName)) {
            this.tagStack.remove(this.tagStack.size() - 1);
        }
    }

    private void endElementInHitField(String qName) {
        if (FIELD.equals(qName) && --this.fieldLevel == 0) {
            Object content = this.hasLiteralTags ? new XMLString(this.fieldContent.toString()) : this.fieldContent.toString();
            this.hitFields.put(this.fieldName, content);
            if ("collapseId".equals(this.fieldName)) {
                this.hitFields.put(this.fieldName, Integer.valueOf(content.toString()));
            }
            this.fieldName = null;
            this.fieldContent = null;
            this.tagStack = null;
        } else {
            Tag prevTag = this.tagStack.get(this.tagStack.size() - 1);
            if (qName.equals(prevTag.name) && this.offset == prevTag.offset + 1) {
                this.fieldContent.append(" />");
            } else {
                this.fieldContent.append("</").append(qName).append('>');
            }
            if (prevTag.name.equals(qName)) {
                this.tagStack.remove(this.tagStack.size() - 1);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.location.peekFirst()) {
            case HIT: 
            case ERRORDETAILS: {
                if (this.fieldLevel <= 0) break;
                if (this.hasLiteralTags) {
                    Tag tag;
                    if (this.tagStack.size() > 0 && (tag = this.tagStack.get(this.tagStack.size() - 1)) != null && tag.offset + 1 == this.offset) {
                        this.fieldContent.append(">");
                    }
                    this.fieldContent.append(XML.xmlEscape((String)new String(ch, start, length), (boolean)false));
                    break;
                }
                this.fieldContent.append(ch, start, length);
                break;
            }
            default: {
                if (this.fieldContent == null) break;
                this.fieldContent.append(ch, start, length);
            }
        }
        ++this.offset;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (this.location.peekFirst()) {
            case HITGROUP: {
                if (!"group".equals(qName)) break;
                this.hitGroups.removeFirst();
                this.location.removeFirst();
                break;
            }
            case HIT: {
                if (this.fieldLevel > 0) {
                    this.endElementInHitField(qName);
                    break;
                }
                if (!"hit".equals(qName)) break;
                Object docId = this.extractDocumentID();
                Hit newHit = new Hit(docId.toString());
                if (this.hitRelevance != null) {
                    newHit.setRelevance(new Relevance(Double.parseDouble(this.hitRelevance)));
                }
                if (this.hitSource != null) {
                    newHit.setSource(this.hitSource);
                }
                if (this.hitType != null) {
                    for (String type : this.hitType.split(" ")) {
                        newHit.types().add(type);
                    }
                }
                for (Map.Entry entry : this.hitFields.entrySet()) {
                    newHit.setField((String)entry.getKey(), entry.getValue());
                }
                this.hitGroups.peekFirst().add(newHit);
                this.location.removeFirst();
                break;
            }
            case ERRORDETAILS: {
                if (this.fieldLevel == 1 && ERROR.equals(qName)) {
                    ErrorMessage error = new ErrorMessage(Integer.valueOf(this.currentErrorCode), this.currentError, this.fieldContent.toString());
                    this.hitGroups.peekFirst().addError(error);
                    this.currentError = null;
                    this.currentErrorCode = null;
                    this.fieldContent = null;
                    this.tagStack = null;
                    this.fieldLevel = 0;
                    break;
                }
                if (this.fieldLevel > 0) {
                    this.endElementInField(qName, ERROR);
                    break;
                }
                if (!"errordetails".equals(qName)) break;
                this.location.removeFirst();
                break;
            }
            case ROOT: {
                if (!ERROR.equals(qName)) break;
                ErrorMessage error = new ErrorMessage(Integer.valueOf(this.currentErrorCode), this.fieldContent.toString());
                this.hitGroups.peekFirst().addError(error);
                this.currentErrorCode = null;
                this.fieldContent = null;
                break;
            }
        }
        ++this.offset;
    }

    private Object extractDocumentID() {
        Object docId = null;
        if (this.hitFields.containsKey("uri")) {
            docId = this.hitFields.get("uri");
        } else {
            String documentId = "documentId";
            if (this.hitFields.containsKey("documentId")) {
                docId = this.hitFields.get("documentId");
            } else {
                String lcDocumentId = Lowercase.toLowerCase((String)"documentId");
                for (Map.Entry<String, Object> e : this.hitFields.entrySet()) {
                    String key = e.getKey();
                    if ("documentId".length() != key.length() || !lcDocumentId.equals(Lowercase.toLowerCase((String)key))) continue;
                    docId = e.getValue();
                    break;
                }
            }
        }
        if (docId == null) {
            docId = "dummy";
            log.info("Results from vespa backend did not contain either uri or documentId");
        }
        return docId;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
    }

    protected void printError(String type, SAXParseException ex) {
        String systemId;
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(type);
        if (ex != null && (systemId = ex.getSystemId()) != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            errorMessage.append(' ').append(systemId);
        }
        errorMessage.append(':').append(ex.getLineNumber()).append(':').append(ex.getColumnNumber()).append(": ").append(ex.getMessage());
        log.log(LogLevel.WARNING, errorMessage.toString());
    }

    public Result parse(String identifier, Query query) {
        this.setQuery(query);
        try {
            this.parser.parse(identifier);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Error parsing result from Vespa", e);
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            }
            e.printStackTrace(System.err);
        }
        Result toReturn = this.result;
        this.reset();
        return toReturn;
    }

    public Result parse(InputSource input, Query query) {
        this.setQuery(query);
        try {
            this.parser.parse(input);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Error parsing result from Vespa", e);
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            }
            e.printStackTrace(System.err);
        }
        Result toReturn = this.result;
        this.reset();
        return toReturn;
    }

    private void setQuery(Query query) {
        this.query = query;
    }

    private static class Tag {
        public final String name;
        public final int offset;

        public Tag(String name, int offset) {
            this.name = name;
            this.offset = offset;
        }

        public String toString() {
            return this.name + '(' + Integer.valueOf(this.offset) + ')';
        }
    }

    private static enum ResultPart {
        ROOT,
        ERRORDETAILS,
        HIT,
        HITGROUP;

    }
}

