/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.http;

import com.google.inject.Inject;
import com.yahoo.component.ComponentId;
import com.yahoo.jdisc.http.CertificateStore;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.search.Query;
import com.yahoo.search.cluster.ClusterSearcher;
import com.yahoo.search.federation.ProviderConfig;
import com.yahoo.search.federation.http.Connection;
import com.yahoo.search.federation.http.GzipDecompressingEntity;
import com.yahoo.search.federation.http.HTTPClientSearcher;
import com.yahoo.search.federation.http.HTTPParameters;
import com.yahoo.search.federation.http.TimeoutException;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.statistics.Counter;
import com.yahoo.statistics.Statistics;
import com.yahoo.text.Utf8;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.DefaultHttpRoutePlanner;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.EntityUtils;

@Deprecated
public abstract class HTTPSearcher
extends ClusterSearcher<Connection> {
    protected static final String YCA_HTTP_HEADER = "Yahoo-App-Auth";
    private static final Charset iso8859Charset = Charset.forName("ISO-8859-1");
    public static final String LOG_PATH = "path";
    public static final String LOG_PORT = "port";
    public static final String LOG_HOST = "host";
    public static final String LOG_IP_ADDRESS = "ip_address";
    public static final String IP_ADDRESS_UNKNOWN = "unknown";
    public static final String LOG_SCHEME = "scheme";
    public static final String LOG_URI = "uri";
    public static final String LOG_PROXY_PORT = "proxy_port";
    public static final String LOG_PROXY_HOST = "proxy_host";
    public static final String LOG_PROXY_TYPE = "proxy_type";
    public static final String LOG_STATUS = "status";
    public static final String LOG_LATENCY_FINISH = "latency_finish";
    public static final String LOG_LATENCY_START = "latency_start";
    public static final String LOG_LATENCY_CONNECT = "latency_connect";
    public static final String LOG_QUERY_PARAM_PREFIX = "query_param_";
    public static final String LOG_HEADER_PREFIX = "header_";
    public static final String LOG_RESPONSE_HEADER_PREFIX = "response_header_";
    public static final String LOG_HITCOUNT = "hit_count";
    public static final String LOG_CONNECT_TIMEOUT_PREFIX = "connect_timeout_";
    public static final String LOG_READ_TIMEOUT_PREFIX = "read_timeout_";
    protected final Logger log = Logger.getLogger(HTTPSearcher.class.getName());
    private HTTPParameters httpParameters;
    private final Counter connectTimeouts;
    protected boolean useCertificate = false;
    private final CertificateStore certificateStore;
    private String certificateApplicationId = null;
    protected HttpHost certificateProxy = null;
    private long certificateTtl = 0L;
    private long certificateRetry = 0L;
    private ClientConnectionManager sharedConnectionManager = null;
    private ThreadLocal<SingleClientConnManager> singleClientConnManagerThreadLocal = null;
    private static final SchemeRegistry schemeRegistry = new SchemeRegistry();

    public HTTPSearcher(ComponentId componentId, List<Connection> connections, String path, Statistics statistics) {
        this(componentId, connections, new HTTPParameters(path), statistics, (CertificateStore)new ThrowingCertificateStore());
    }

    public HTTPSearcher(ComponentId componentId, List<Connection> connections, String path, Statistics statistics, CertificateStore certificateStore) {
        this(componentId, connections, new HTTPParameters(path), statistics, certificateStore);
    }

    public HTTPSearcher(ComponentId componentId, List<Connection> connections, HTTPParameters parameters, Statistics statistics) {
        this(componentId, connections, parameters, statistics, (CertificateStore)new ThrowingCertificateStore());
    }

    @Inject
    public HTTPSearcher(ComponentId componentId, List<Connection> connections, HTTPParameters parameters, Statistics statistics, CertificateStore certificateStore) {
        super(componentId, connections, false);
        String suffix = "_" + this.getId().getName().replace('.', '_');
        this.connectTimeouts = new Counter(LOG_CONNECT_TIMEOUT_PREFIX + suffix, statistics, false);
        parameters.freeze();
        this.httpParameters = parameters;
        this.certificateStore = certificateStore;
        if (parameters.getPersistentConnections()) {
            HttpParams params = parameters.toHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            ConnManagerParams.setTimeout((HttpParams)params, (long)10L);
            this.sharedConnectionManager = new ThreadSafeClientConnManager(params, schemeRegistry);
            Thread connectionPurgerThread = new Thread(() -> {
                long DNSTTLSec = 120L;
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(DNSTTLSec * 1000L);
                            if (this.sharedConnectionManager == null) continue;
                            this.sharedConnectionManager.closeExpiredConnections();
                            DNSTTLSec = Long.valueOf(Security.getProperty("networkaddress.cache.ttl"));
                            if (DNSTTLSec <= 0L) {
                                DNSTTLSec = 120L;
                                continue;
                            }
                            this.sharedConnectionManager.closeIdleConnections(2L * DNSTTLSec, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    break;
                }
            });
            connectionPurgerThread.setDaemon(true);
            connectionPurgerThread.start();
        } else {
            this.singleClientConnManagerThreadLocal = new ThreadLocal();
        }
        this.initializeCertificate(this.httpParameters, certificateStore);
    }

    private void initializeCertificate(HTTPParameters parameters, CertificateStore certificateStore) {
        String applicationId = parameters.getYcaApplicationId();
        String proxy = parameters.getYcaProxy();
        int port = parameters.getYcaPort();
        long ttl = parameters.getYcaTtl();
        long retry = parameters.getYcaRetry();
        if (applicationId != null && !applicationId.trim().isEmpty()) {
            this.initializeCertificate(applicationId, ttl, retry, certificateStore);
        }
        if (parameters.getYcaUseProxy()) {
            this.initializeProxy(proxy, port);
        }
    }

    public HTTPParameters getParameters() {
        return this.httpParameters;
    }

    public Map<String, String> getQueryMap(Query query) {
        return new LinkedHashMap<String, String>();
    }

    private void initializeCertificate(String applicationId, long ttl, long retry, CertificateStore certificateStore) {
        try {
            String certificate = certificateStore.getCertificate(applicationId, ttl, retry);
            if (certificate == null) {
                this.getLogger().log(LogLevel.WARNING, "No certificate found for application '" + applicationId + "'");
                return;
            }
            this.useCertificate = true;
            this.certificateApplicationId = applicationId;
            this.certificateTtl = ttl;
            this.certificateRetry = retry;
            this.getLogger().log(LogLevel.CONFIG, "Got certificate: " + certificate);
        }
        catch (Exception e) {
            this.getLogger().log(LogLevel.WARNING, "Exception while initializing certificate for application '" + applicationId + "' in " + this, e);
        }
    }

    private void initializeProxy(String host, int port) {
        this.certificateProxy = new HttpHost(host, port);
        this.getLogger().log(LogLevel.CONFIG, "Proxy is configured; will use proxy: " + this.certificateProxy);
    }

    protected URI getURI(Query query, Connection connection) throws MalformedURLException, URISyntaxException {
        Hit requestMeta;
        try {
            requestMeta = (Hit)query.properties().get(HTTPClientSearcher.REQUEST_META_CARRIER);
        }
        catch (ClassCastException e) {
            requestMeta = null;
        }
        return this.getURI(query, requestMeta, connection);
    }

    protected URI getURI(Query query, Hit requestMeta, Connection connection) throws MalformedURLException, URISyntaxException {
        StringBuilder parameters = new StringBuilder();
        Map<String, String> queries = this.getQueryMap(query);
        if (queries.size() > 0) {
            Iterator<Map.Entry<String, String>> mapIterator = queries.entrySet().iterator();
            parameters.append("?");
            try {
                while (mapIterator.hasNext()) {
                    Map.Entry<String, String> entry = mapIterator.next();
                    if (requestMeta != null) {
                        requestMeta.setField(LOG_QUERY_PARAM_PREFIX + entry.getKey(), entry.getValue());
                    }
                    parameters.append(entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), this.httpParameters.getInputEncoding()));
                    if (!mapIterator.hasNext()) continue;
                    parameters.append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unknown input encoding set in " + this, e);
            }
        }
        URI uri = new URL(this.httpParameters.getSchema(), connection.getHost(), connection.getPort(), this.getPath() + parameters.toString()).toURI();
        if (requestMeta != null) {
            requestMeta.setField(LOG_URI, uri.toString());
            requestMeta.setField(LOG_SCHEME, uri.getScheme());
            requestMeta.setField(LOG_HOST, uri.getHost());
            requestMeta.setField(LOG_PORT, uri.getPort());
            requestMeta.setField(LOG_PATH, uri.getPath());
        }
        return uri;
    }

    protected String getPath() {
        return this.httpParameters.getPath();
    }

    protected URI getPingURI(Connection connection) throws MalformedURLException, URISyntaxException {
        return new URL(this.httpParameters.getSchema(), connection.getHost(), connection.getPort(), this.getPingPath()).toURI();
    }

    protected String getPingPath() {
        return this.httpParameters.getPath();
    }

    protected void checkPing(HttpResponse response, Pong pong) {
        if (response.getStatusLine().getStatusCode() >= 300) {
            pong.addError(ErrorMessage.createBackendCommunicationError("Got error " + response.getStatusLine().getStatusCode() + " when contacting backend"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pong ping(Ping ping, Connection connection) {
        URI uri = null;
        Pong pong = new Pong();
        HttpResponse response = null;
        if (this.httpParameters.getPingOption() == ProviderConfig.PingOption.DISABLE) {
            return pong;
        }
        try {
            uri = this.getPingURI(connection);
            if (uri == null) {
                pong.addError(ErrorMessage.createIllegalQuery("Ping uri is null"));
            }
            if (uri.getHost() == null) {
                pong.addError(ErrorMessage.createIllegalQuery("Ping uri has no host"));
                uri = null;
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            pong.addError(ErrorMessage.createIllegalQuery("Malformed ping uri '" + uri + "': " + Exceptions.toMessageString((Throwable)e)));
        }
        catch (RuntimeException e) {
            this.log.log(Level.WARNING, "Unexpected exception while attempting to ping " + connection + " using uri '" + uri + "'", e);
            pong.addError(ErrorMessage.createIllegalQuery("Unexpected problem with ping uri '" + uri + "': " + Exceptions.toMessageString((Throwable)e)));
        }
        if (uri == null) {
            return pong;
        }
        pong.setPingInfo("using uri '" + uri + "'");
        try {
            response = this.getPingResponse(uri, ping);
            this.checkPing(response, pong);
        }
        catch (IOException e) {
            pong.addError(ErrorMessage.createBackendCommunicationError("Exception thrown when pinging with url '" + uri + "': " + Exceptions.toMessageString((Throwable)e)));
        }
        catch (TimeoutException e) {
            pong.addError(ErrorMessage.createTimeout("Timeout for ping " + uri + " in " + this + ": " + e.getMessage()));
        }
        catch (RuntimeException e) {
            this.log.log(Level.WARNING, "Unexpected exception while attempting to ping " + connection + " using uri '" + uri + "'", e);
            pong.addError(ErrorMessage.createIllegalQuery("Unexpected problem with ping uri '" + uri + "': " + Exceptions.toMessageString((Throwable)e)));
        }
        finally {
            if (response != null) {
                this.cleanupHttpEntity(response.getEntity());
            }
        }
        return pong;
    }

    private HttpResponse getPingResponse(URI uri, Ping ping) throws IOException {
        long timeLeft = ping.getTimeout();
        int connectionTimeout = (int)(timeLeft / 4L);
        int readTimeout = (int)(timeLeft * 3L / 4L);
        Map<String, String> requestHeaders = null;
        if (this.httpParameters.getPingOption() == ProviderConfig.PingOption.YCA) {
            requestHeaders = this.generateYCAHeaders();
        }
        return this.getResponse(uri, null, requestHeaders, null, connectionTimeout, readTimeout);
    }

    protected HttpEntity getEntity(URI uri, Query query) throws IOException {
        return this.getEntity(uri, null, query);
    }

    protected HttpEntity getEntity(URI uri, Hit requestMeta, Query query) throws IOException {
        if (query.getTimeLeft() <= 0L) {
            throw new TimeoutException("No time left for querying external backend.");
        }
        HttpResponse response = this.getResponse(uri, requestMeta, query);
        StatusLine statusLine = response.getStatusLine();
        if (requestMeta != null) {
            requestMeta.setField(LOG_STATUS, statusLine.getStatusCode());
            HeaderIterator headers = response.headerIterator();
            while (headers.hasNext()) {
                Header h = headers.nextHeader();
                requestMeta.setField(LOG_RESPONSE_HEADER_PREFIX + h.getName(), h.getValue());
            }
        }
        if (statusLine.getStatusCode() >= 300) {
            HttpEntity entity = response.getEntity();
            String message = this.createServerReporterErrorMessage(statusLine, entity);
            this.cleanupHttpEntity(response.getEntity());
            throw new IOException(message);
        }
        return response.getEntity();
    }

    private String createServerReporterErrorMessage(StatusLine statusLine, HttpEntity entity) {
        String message = "Error when trying to connect to HTTP backend: " + statusLine.getStatusCode() + " : " + statusLine.getReasonPhrase();
        try {
            if (entity != null) {
                message = message + "(Message = " + EntityUtils.toString((HttpEntity)entity) + ")";
            }
        }
        catch (Exception e) {
            this.log.log(LogLevel.WARNING, "Could not get message.", e);
        }
        return message;
    }

    protected Hit createRequestMeta() {
        Hit requestMeta = new Hit("logging:" + this.getId().toString());
        requestMeta.setMeta(true);
        requestMeta.types().add("logging");
        return requestMeta;
    }

    protected void cleanupHttpEntity(HttpEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            entity.consumeContent();
        }
        catch (IOException e) {
            this.log.log(LogLevel.getVespaLogLevel((Level)LogLevel.DEBUG), "Not able to consume after processing: " + Exceptions.toMessageString((Throwable)e));
        }
    }

    protected HttpResponse getResponse(URI uri, Query query) throws IOException {
        return this.getResponse(uri, null, query);
    }

    protected HttpResponse getResponse(URI uri, Hit requestMeta, Query query) throws IOException {
        long timeLeft = query.getTimeLeft();
        int connectionTimeout = (int)(timeLeft / 4L);
        int readTimeout = (int)(timeLeft * 3L / 4L);
        connectionTimeout = connectionTimeout <= 0 ? 1 : connectionTimeout;
        readTimeout = readTimeout <= 0 ? 1 : readTimeout;
        HttpEntity reqEntity = this.getRequestEntity(query, requestMeta);
        Map<String, String> reqHeaders = this.getRequestHeaders(query, requestMeta);
        if (reqEntity == null && reqHeaders == null) {
            return this.getResponse(uri, requestMeta, connectionTimeout, readTimeout);
        }
        return this.getResponse(uri, reqEntity, reqHeaders, requestMeta, connectionTimeout, readTimeout);
    }

    protected Map<String, String> getRequestHeaders(Query query, Hit requestMeta) {
        if (this.useCertificate) {
            return this.generateYCAHeaders();
        }
        return null;
    }

    protected HttpEntity getRequestEntity(Query query, Hit requestMeta) {
        return null;
    }

    protected HttpResponse getResponse(URI uri, Hit requestMeta, int connectionTimeout, int readTimeout) throws IOException {
        return this.getResponse(uri, null, null, requestMeta, connectionTimeout, readTimeout);
    }

    protected HttpResponse getResponse(URI uri, HttpEntity reqEntity, Map<String, String> reqHeaders, Hit requestMeta, int connectionTimeout, int readTimeout) throws IOException {
        HttpResponse response;
        HttpParams httpParams = this.httpParameters.toHttpParams(connectionTimeout, readTimeout);
        HttpClient httpClient = this.createClient(httpParams);
        long start = 0L;
        if (this.httpParameters.getEnableProxy() && "http".equals(this.httpParameters.getProxyType())) {
            HttpHost proxy = new HttpHost(this.httpParameters.getProxyHost(), this.httpParameters.getProxyPort(), this.httpParameters.getProxyType());
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (requestMeta != null) {
                requestMeta.setField(LOG_PROXY_TYPE, this.httpParameters.getProxyType());
                requestMeta.setField(LOG_PROXY_HOST, this.httpParameters.getProxyHost());
                requestMeta.setField(LOG_PROXY_PORT, this.httpParameters.getProxyPort());
            }
        }
        HttpUriRequest request = reqEntity == null ? this.createRequest(this.httpParameters.getMethod(), uri) : this.createRequest(this.httpParameters.getMethod(), uri, reqEntity);
        if (reqHeaders != null) {
            for (Map.Entry entry : reqHeaders.entrySet()) {
                if (entry.getValue() == null || this.isAscii((String)entry.getValue())) {
                    request.addHeader((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                byte[] asBytes = Utf8.toBytes((String)((String)entry.getValue()));
                String asLyingString = new String(asBytes, 0, asBytes.length, iso8859Charset);
                request.addHeader((String)entry.getKey(), asLyingString);
            }
        }
        if (requestMeta != null) {
            HeaderIterator headers = request.headerIterator();
            while (headers.hasNext()) {
                Header header = headers.nextHeader();
                requestMeta.setField(LOG_HEADER_PREFIX + header.getName(), header.getValue());
            }
            start = System.currentTimeMillis();
        }
        try {
            BasicHttpContext basicHttpContext = new BasicHttpContext();
            response = httpClient.execute(request, (HttpContext)basicHttpContext);
            if (requestMeta != null) {
                requestMeta.setField(LOG_IP_ADDRESS, this.getIpAddress((HttpContext)basicHttpContext));
            }
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            this.connectTimeouts.increment();
            throw connectTimeoutException;
        }
        long l = System.currentTimeMillis() - start;
        if (requestMeta != null) {
            requestMeta.setField(LOG_LATENCY_START, l);
        }
        this.logResponseLatency(l);
        return response;
    }

    private String getIpAddress(HttpContext context) {
        HttpConnection connection = (HttpConnection)context.getAttribute("http.connection");
        if (connection instanceof HttpInetConnection) {
            InetAddress address = ((HttpInetConnection)connection).getRemoteAddress();
            String hostAddress = address.getHostAddress();
            return hostAddress == null ? IP_ADDRESS_UNKNOWN : hostAddress;
        }
        this.getLogger().log((Level)LogLevel.DEBUG, "Unexpected connection type: " + connection.getClass().getName());
        return IP_ADDRESS_UNKNOWN;
    }

    private boolean isAscii(String value) {
        char[] scanBuffer = new char[value.length()];
        value.getChars(0, value.length(), scanBuffer, 0);
        for (char c : scanBuffer) {
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    protected void logResponseLatency(long latency) {
    }

    protected HttpClient createClient(HttpParams params) {
        if (this.certificateProxy != null) {
            params.setParameter("http.route.default-proxy", (Object)this.certificateProxy);
        }
        return new SearcherHttpClient(this.getConnectionManager(params), params);
    }

    protected HttpUriRequest createRequest(String method, URI uri) {
        return this.createRequest(method, uri, null);
    }

    protected HttpUriRequest createRequest(String method, URI uri, HttpEntity entity) {
        return new SearcherHttpRequest(method, uri);
    }

    protected ClientConnectionManager getConnectionManager(HttpParams params) {
        if (this.sharedConnectionManager != null) {
            return this.sharedConnectionManager;
        }
        SingleClientConnManager singleClientConnManager = this.singleClientConnManagerThreadLocal.get();
        if (singleClientConnManager == null) {
            singleClientConnManager = new SingleClientConnManager(params, schemeRegistry);
            this.singleClientConnManagerThreadLocal.set(singleClientConnManager);
        }
        return singleClientConnManager;
    }

    protected ErrorMessage createMalformedUrlError(Query query, Exception e) {
        return ErrorMessage.createErrorInPluginSearcher("Malformed url in " + this + " for " + query + ": " + Exceptions.toMessageString((Throwable)e));
    }

    private Map<String, String> generateYCAHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String certificate = this.certificateStore.getCertificate(this.certificateApplicationId, this.certificateTtl, this.certificateRetry);
        headers.put(YCA_HTTP_HEADER, certificate);
        return headers;
    }

    public void shutdownConnectionManagers() {
        ClientConnectionManager manager = this.sharedConnectionManager != null ? this.sharedConnectionManager : (ClientConnectionManager)this.singleClientConnManagerThreadLocal.get();
        if (manager != null) {
            manager.shutdown();
        }
    }

    static {
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
    }

    protected static final class ThrowingCertificateStore
    implements CertificateStore {
        protected ThrowingCertificateStore() {
        }

        public String getCertificate(String key, long ttl, long retry) {
            throw new UnsupportedOperationException("A certificate store is not available");
        }
    }

    private static class SearcherHttpRequest
    extends HttpRequestBase {
        String method;

        public SearcherHttpRequest(String method, URI uri) {
            this.method = method;
            this.setURI(uri);
        }

        public String getMethod() {
            return this.method;
        }
    }

    private static class SearcherHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        private final int retries;

        public SearcherHttpRequestRetryHandler(int retries) {
            this.retries = retries;
        }

        public boolean retryRequest(IOException e, int executionCount, HttpContext httpContext) {
            if (e == null) {
                throw new IllegalArgumentException("Exception parameter may not be null");
            }
            if (executionCount > this.retries) {
                return false;
            }
            if (e instanceof NoHttpResponseException) {
                return true;
            }
            if (e instanceof InterruptedIOException) {
                return false;
            }
            if (e instanceof UnknownHostException) {
                return false;
            }
            return !(e instanceof SSLHandshakeException);
        }
    }

    protected static class SearcherHttpClient
    extends DefaultHttpClient {
        private final int retries;

        public SearcherHttpClient(ClientConnectionManager conman, HttpParams params) {
            super(conman, params);
            this.retries = params.getIntParameter("com.yahoo.search.federation.http.retries", 1);
            this.addRequestInterceptor((request, context) -> {
                if (!request.containsHeader("Accept-Encoding")) {
                    request.addHeader("Accept-Encoding", "gzip");
                }
            });
            this.addResponseInterceptor((response, context) -> {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return;
                }
                Header ceheader = entity.getContentEncoding();
                if (ceheader == null) {
                    return;
                }
                for (HeaderElement codec : ceheader.getElements()) {
                    if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                    response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                    return;
                }
            });
        }

        protected HttpRequestExecutor createRequestExecutor() {
            return new HttpRequestExecutor();
        }

        protected HttpRoutePlanner createHttpRoutePlanner() {
            return new DefaultHttpRoutePlanner(this.getConnectionManager().getSchemeRegistry());
        }

        protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
            return new SearcherHttpRequestRetryHandler(this.retries);
        }
    }
}

