/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.http;

import com.yahoo.component.ComponentId;
import com.yahoo.jdisc.http.CertificateStore;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.federation.http.Connection;
import com.yahoo.search.federation.http.HTTPParameters;
import com.yahoo.search.federation.http.HTTPSearcher;
import com.yahoo.search.federation.http.TimeoutException;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.statistics.Statistics;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;

@Deprecated
public abstract class HTTPClientSearcher
extends HTTPSearcher {
    static final CompoundName REQUEST_META_CARRIER = new CompoundName("com.yahoo.search.federation.http.HTTPClientSearcher_requestMeta");
    protected static final Logger log = Logger.getLogger(HTTPClientSearcher.class.getName());

    public HTTPClientSearcher(ComponentId id, List<Connection> connections, String path, Statistics statistics) {
        super(id, connections, path, statistics);
    }

    public HTTPClientSearcher(ComponentId id, List<Connection> connections, String path, Statistics statistics, CertificateStore certificateStore) {
        super(id, connections, path, statistics, certificateStore);
    }

    public HTTPClientSearcher(ComponentId id, List<Connection> connections, HTTPParameters parameters, Statistics statistics) {
        super(id, connections, parameters, statistics);
    }

    public HTTPClientSearcher(ComponentId id, List<Connection> connections, HTTPParameters parameters, Statistics statistics, CertificateStore certificateStore) {
        super(id, connections, parameters, statistics, certificateStore);
    }

    @Override
    public Result robustSearch(Query query, Execution execution, Connection connection) {
        return this.search(query, execution, connection);
    }

    @Override
    public Result search(Query query, Execution execution, Connection connection) {
        Hit requestMeta = this.doHttpRequest(query, connection);
        Result result = execution.search(query);
        result.hits().add(requestMeta);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hit doHttpRequest(Query query, Connection connection) {
        HttpEntity entity;
        URI uri;
        Hit requestMeta = this.createRequestMeta();
        query.properties().set(REQUEST_META_CARRIER, requestMeta);
        query.trace("Created request information hit", false, 9);
        try {
            uri = this.getURI(query, connection);
        }
        catch (MalformedURLException e) {
            query.errors().add(this.createMalformedUrlError(query, e));
            return requestMeta;
        }
        catch (URISyntaxException e) {
            query.errors().add(this.createMalformedUrlError(query, e));
            return requestMeta;
        }
        try {
            if (query.getTraceLevel() >= 1) {
                query.trace("Fetching " + uri.toString(), false, 1);
            }
            entity = this.getEntity(uri, requestMeta, query);
        }
        catch (IOException e) {
            query.errors().add(ErrorMessage.createBackendCommunicationError("Error when trying to connect to HTTP backend in " + this + " using " + connection + " for " + query + ": " + Exceptions.toMessageString((Throwable)e)));
            return requestMeta;
        }
        catch (TimeoutException e) {
            query.errors().add(ErrorMessage.createTimeout("HTTP traffic timed out in " + this + " for " + query + ": " + e.getMessage()));
            return requestMeta;
        }
        if (entity == null) {
            query.errors().add(ErrorMessage.createBackendCommunicationError("No result from connecting to HTTP backend in " + this + " using " + connection + " for " + query));
            return requestMeta;
        }
        try {
            query = this.handleResponse(entity, query);
        }
        catch (IOException e) {
            query.errors().add(ErrorMessage.createBackendCommunicationError("Error when trying to consume input in " + this + ": " + Exceptions.toMessageString((Throwable)e)));
        }
        finally {
            this.cleanupHttpEntity(entity);
        }
        return requestMeta;
    }

    @Override
    public Result search(Query query, Execution execution, ErrorMessage error) {
        query.errors().add(error);
        return execution.search(query);
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution, Connection connection) {
    }

    public Query handleResponse(InputStream inputStream, long contentLength, Query query) throws IOException {
        throw new UnsupportedOperationException("handleResponse must be implemented by " + this);
    }

    public Query handleResponse(HttpEntity entity, Query query) throws IOException {
        long len = entity.getContentLength();
        if (query.getTraceLevel() >= 4) {
            query.trace("Received " + len + " bytes response in " + this, false, 4);
        }
        if ((query = this.handleResponse(entity.getContent(), len, query)).getTraceLevel() >= 2) {
            query.trace("Handled " + len + " bytes response in " + this, false, 2);
        }
        return query;
    }

    @Override
    protected boolean shouldRetry(Query query, Result result) {
        return false;
    }

    public abstract Map<String, String> getCacheKey(Query var1);

    @Override
    public Map<String, String> getQueryMap(Query query) {
        LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>();
        if (this.getServiceName().isEmpty()) {
            return queryMap;
        }
        for (Map.Entry objectProperty : query.properties().listProperties("service." + this.getServiceName()).entrySet()) {
            queryMap.put((String)objectProperty.getKey(), objectProperty.getValue().toString());
        }
        return queryMap;
    }

    protected String getServiceName() {
        return "";
    }
}

