/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

@Deprecated
public class GzipDecompressingEntity
extends HttpEntityWrapper {
    private final Resources resources = new Resources();

    public GzipDecompressingEntity(HttpEntity entity) throws IllegalStateException, IOException {
        super(entity);
        GZIPInputStream gz = new GZIPInputStream(entity.getContent());
        try (BufferedInputStream zipStream = new BufferedInputStream(gz);){
            this.resources.drain(zipStream);
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        final ByteBuffer buff = ByteBuffer.wrap(this.resources.buffer, 0, this.resources.total);
        return new InputStream(){

            @Override
            public int available() throws IOException {
                return buff.remaining();
            }

            @Override
            public int read() throws IOException {
                if (buff.hasRemaining()) {
                    return buff.get() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] b) throws IOException {
                if (!buff.hasRemaining()) {
                    return -1;
                }
                int len = b.length;
                if (len > buff.remaining()) {
                    len = buff.remaining();
                }
                buff.get(b, 0, len);
                return len;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (!buff.hasRemaining()) {
                    return -1;
                }
                if (len > buff.remaining()) {
                    len = buff.remaining();
                }
                buff.get(b, off, len);
                return len;
            }

            @Override
            public long skip(long n) throws IOException {
                if (!buff.hasRemaining()) {
                    return -1L;
                }
                if (n > (long)buff.remaining()) {
                    n = buff.remaining();
                }
                buff.position(buff.position() + (int)n);
                return n;
            }
        };
    }

    public long getContentLength() {
        return this.resources.total;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.resources.buffer, 0, this.resources.total);
    }

    private static class Resources {
        byte[] buffer = new byte[65536];
        int total = 0;

        Resources() {
        }

        void drain(InputStream zipStream) throws IOException {
            int numRead = zipStream.read(this.buffer, this.total, this.buffer.length);
            while (numRead != -1) {
                this.total += numRead;
                if (this.total + 65536 > this.buffer.length) {
                    this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + numRead);
                }
                numRead = zipStream.read(this.buffer, this.total, this.buffer.length - this.total);
            }
        }
    }
}

