/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.FastSearcher;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.yolean.Exceptions;
import java.util.concurrent.Callable;

class Pinger
implements Callable<Pong> {
    private final Node node;
    private final ClusterMonitor<Node> clusterMonitor;
    private final FS4ResourcePool fs4ResourcePool;

    public Pinger(Node node, ClusterMonitor<Node> clusterMonitor, FS4ResourcePool fs4ResourcePool) {
        this.node = node;
        this.clusterMonitor = clusterMonitor;
        this.fs4ResourcePool = fs4ResourcePool;
    }

    @Override
    public Pong call() {
        try {
            Pong pong = FastSearcher.ping(new Ping(this.clusterMonitor.getConfiguration().getRequestTimeout()), this.fs4ResourcePool.getBackend(this.node.hostname(), this.node.fs4port()), this.node.toString());
            if (pong.activeDocuments().isPresent()) {
                this.node.setActiveDocuments(pong.activeDocuments().get());
            }
            return pong;
        }
        catch (RuntimeException e) {
            return new Pong(ErrorMessage.createBackendCommunicationError("Exception when pinging " + this.node + ": " + Exceptions.toMessageString((Throwable)e)));
        }
    }
}

