/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class Node {
    private final int key;
    private final String hostname;
    private final int fs4port;
    final int group;
    private final AtomicBoolean working = new AtomicBoolean(true);
    private final AtomicLong activeDocuments = new AtomicLong(0L);

    public Node(int key, String hostname, int fs4port, int group) {
        this.key = key;
        this.hostname = hostname;
        this.fs4port = fs4port;
        this.group = group;
    }

    public int key() {
        return this.key;
    }

    public String hostname() {
        return this.hostname;
    }

    public int fs4port() {
        return this.fs4port;
    }

    public int group() {
        return this.group;
    }

    public void setWorking(boolean working) {
        this.working.lazySet(working);
    }

    public boolean isWorking() {
        return this.working.get();
    }

    void setActiveDocuments(long activeDocuments) {
        this.activeDocuments.set(activeDocuments);
    }

    public long getActiveDocuments() {
        return this.activeDocuments.get();
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.fs4port);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!Objects.equals(this.hostname, other.hostname)) {
            return false;
        }
        return Objects.equals(this.fs4port, other.fs4port);
    }

    public String toString() {
        return "search node " + this.hostname + ":" + this.fs4port + " in group " + this.group;
    }
}

