/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadBalancer {
    private static final Logger log = Logger.getLogger(LoadBalancer.class.getName());
    private final List<GroupSchedule> scoreboard;
    private int needle = 0;

    public LoadBalancer(SearchCluster searchCluster, boolean roundRobin) {
        if (searchCluster == null) {
            this.scoreboard = null;
            return;
        }
        this.scoreboard = new ArrayList<GroupSchedule>(searchCluster.groups().size());
        for (Group group : searchCluster.orderedGroups()) {
            this.scoreboard.add(new GroupSchedule(group));
        }
        if (!roundRobin) {
            Collections.shuffle(this.scoreboard);
        }
    }

    public Optional<Group> takeGroup(Set<Integer> rejectedGroups) {
        if (this.scoreboard == null) {
            return Optional.empty();
        }
        return this.allocateNextGroup(rejectedGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseGroup(Group group) {
        LoadBalancer loadBalancer = this;
        synchronized (loadBalancer) {
            for (GroupSchedule sched : this.scoreboard) {
                if (sched.group.id() != group.id()) continue;
                sched.adjustScore(-1);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Group> allocateNextGroup(Set<Integer> rejectedGroups) {
        LoadBalancer loadBalancer = this;
        synchronized (loadBalancer) {
            GroupSchedule bestSchedule = null;
            int bestIndex = this.needle;
            int index = this.needle;
            for (int i = 0; i < this.scoreboard.size(); ++i) {
                GroupSchedule sched = this.scoreboard.get(index);
                if ((rejectedGroups == null || !rejectedGroups.contains(sched.group.id())) && sched.isPreferredOver(bestSchedule)) {
                    bestSchedule = sched;
                    bestIndex = index;
                }
                index = this.nextScoreboardIndex(index);
            }
            this.needle = this.nextScoreboardIndex(bestIndex);
            Group ret = null;
            if (bestSchedule != null) {
                bestSchedule.adjustScore(1);
                ret = bestSchedule.group;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Offering <" + ret + "> for query connection");
            }
            return Optional.ofNullable(ret);
        }
    }

    private int nextScoreboardIndex(int current) {
        int next = current + 1;
        if (next >= this.scoreboard.size()) {
            next %= this.scoreboard.size();
        }
        return next;
    }

    private static class GroupSchedule {
        private final Group group;
        private int score;

        public GroupSchedule(Group group) {
            this.group = group;
            this.score = 0;
        }

        public boolean isPreferredOver(GroupSchedule other) {
            if (other == null) {
                return true;
            }
            if (this.group.hasSufficientCoverage() != other.group.hasSufficientCoverage()) {
                return this.group.hasSufficientCoverage();
            }
            return this.score < other.score;
        }

        public void adjustScore(int amount) {
            this.score += amount;
            if (this.score < 0) {
                log.warning("Double free of query target group detected");
                this.score = 0;
            }
        }
    }
}

