/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.fs4.QueryPacket;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.CloseableInvoker;
import com.yahoo.search.dispatch.ResponseMonitor;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InterleavedSearchInvoker
extends SearchInvoker
implements ResponseMonitor<SearchInvoker> {
    private static final Logger log = Logger.getLogger(InterleavedSearchInvoker.class.getName());
    private final Set<SearchInvoker> invokers = Collections.newSetFromMap(new IdentityHashMap());
    private final VespaBackEndSearcher searcher;
    private final SearchCluster searchCluster;
    private final LinkedBlockingQueue<SearchInvoker> availableForProcessing;
    private Query query;
    private boolean adaptiveTimeoutCalculated = false;
    private long adaptiveTimeoutMin = 0L;
    private long adaptiveTimeoutMax = 0L;
    private long deadline = 0L;
    private Result result = null;
    private long answeredDocs = 0L;
    private long answeredActiveDocs = 0L;
    private long answeredSoonActiveDocs = 0L;
    private int askedNodes = 0;
    private int answeredNodes = 0;
    private boolean timedOut = false;
    private boolean trimResult = false;

    public InterleavedSearchInvoker(Collection<SearchInvoker> invokers, VespaBackEndSearcher searcher, SearchCluster searchCluster) {
        super(Optional.empty());
        this.invokers.addAll(invokers);
        this.searcher = searcher;
        this.searchCluster = searchCluster;
        this.availableForProcessing = this.newQueue();
    }

    @Override
    protected void sendSearchRequest(Query query, QueryPacket queryPacket) throws IOException {
        this.query = query;
        this.invokers.forEach(invoker -> invoker.setMonitor(this));
        this.deadline = this.currentTime() + query.getTimeLeft();
        int originalHits = query.getHits();
        int originalOffset = query.getOffset();
        query.setHits(query.getHits() + query.getOffset());
        query.setOffset(0);
        this.trimResult = originalHits != query.getHits() || originalOffset != query.getOffset();
        for (SearchInvoker invoker2 : this.invokers) {
            invoker2.sendSearchRequest(query, null);
            ++this.askedNodes;
        }
        query.setHits(originalHits);
        query.setOffset(originalOffset);
    }

    @Override
    protected Result getSearchResult(CacheKey cacheKey, Execution execution) throws IOException {
        long nextTimeout = this.query.getTimeLeft();
        try {
            while (!this.invokers.isEmpty() && nextTimeout >= 0L) {
                SearchInvoker invoker = this.availableForProcessing.poll(nextTimeout, TimeUnit.MILLISECONDS);
                if (invoker == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Search timed out with " + this.askedNodes + " requests made, " + this.answeredNodes + " responses received");
                    }
                    break;
                }
                this.invokers.remove(invoker);
                this.mergeResult(invoker.getSearchResult(cacheKey, execution));
                nextTimeout = this.nextTimeout();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for search results", e);
        }
        if (this.result == null) {
            this.result = new Result(this.query);
        }
        this.insertTimeoutErrors();
        this.result.setCoverage(this.createCoverage());
        this.trimResult(execution);
        Result ret = this.result;
        this.result = null;
        return ret;
    }

    private void trimResult(Execution execution) {
        if (this.trimResult) {
            if (this.result.getHitOrderer() != null) {
                this.searcher.fill(this.result, "attributeprefetch", execution);
            }
            this.result.hits().trim(this.query.getOffset(), this.query.getHits());
        }
    }

    private void insertTimeoutErrors() {
        for (SearchInvoker invoker : this.invokers) {
            Optional<Integer> dk = invoker.distributionKey();
            String message = dk.isPresent() ? "Backend communication timeout on node with distribution-key " + dk.get() : "Backend communication timeout";
            this.result.hits().addError(ErrorMessage.createBackendCommunicationError(message));
            invoker.getErrorCoverage().ifPresent(this::collectCoverage);
            this.timedOut = true;
        }
    }

    private long nextTimeout() {
        long nextAdaptive;
        DispatchConfig config = this.searchCluster.dispatchConfig();
        double minimumCoverage = config.minSearchCoverage();
        if (this.askedNodes == this.answeredNodes || minimumCoverage >= 100.0) {
            return this.query.getTimeLeft();
        }
        int minimumResponses = (int)Math.ceil((double)this.askedNodes * minimumCoverage / 100.0);
        if (this.answeredNodes < minimumResponses) {
            return this.query.getTimeLeft();
        }
        long timeLeft = this.query.getTimeLeft();
        if (!this.adaptiveTimeoutCalculated) {
            this.adaptiveTimeoutMin = (long)((double)timeLeft * config.minWaitAfterCoverageFactor());
            this.adaptiveTimeoutMax = (long)((double)timeLeft * config.maxWaitAfterCoverageFactor());
            this.adaptiveTimeoutCalculated = true;
        }
        long now = this.currentTime();
        int pendingQueries = this.askedNodes - this.answeredNodes;
        double missWidth = (100.0 - config.minSearchCoverage()) * (double)this.askedNodes / 100.0 - 1.0;
        double slopedWait = this.adaptiveTimeoutMin;
        if (pendingQueries > 1 && missWidth > 0.0) {
            slopedWait += (double)((this.adaptiveTimeoutMax - this.adaptiveTimeoutMin) * (long)(pendingQueries - 1)) / missWidth;
        }
        if (now + (nextAdaptive = (long)slopedWait) >= this.deadline) {
            return this.deadline - now;
        }
        this.deadline = now + nextAdaptive;
        return nextAdaptive;
    }

    private void mergeResult(Result partialResult) {
        this.collectCoverage(partialResult.getCoverage(true));
        if (this.result == null) {
            this.result = partialResult;
            return;
        }
        this.result.mergeWith(partialResult);
        this.result.hits().addAll(partialResult.hits().asUnorderedHits());
    }

    private void collectCoverage(Coverage source) {
        this.answeredDocs += source.getDocs();
        this.answeredActiveDocs += source.getActive();
        this.answeredSoonActiveDocs += source.getSoonActive();
        ++this.answeredNodes;
    }

    private Coverage createCoverage() {
        this.adjustDegradedCoverage();
        Coverage coverage = new Coverage(this.answeredDocs, this.answeredActiveDocs, this.answeredNodes, 1);
        coverage.setNodesTried(this.askedNodes);
        coverage.setSoonActive(this.answeredSoonActiveDocs);
        if (this.timedOut) {
            coverage.setDegradedReason(this.adaptiveTimeoutCalculated ? 4 : 2);
        }
        return coverage;
    }

    private void adjustDegradedCoverage() {
        if (this.askedNodes == this.answeredNodes) {
            return;
        }
        int notAnswered = this.askedNodes - this.answeredNodes;
        if (this.adaptiveTimeoutCalculated) {
            this.answeredActiveDocs += (long)notAnswered * this.answeredActiveDocs / (long)this.answeredNodes;
            this.answeredSoonActiveDocs += (long)notAnswered * this.answeredSoonActiveDocs / (long)this.answeredNodes;
        } else if (this.askedNodes > this.answeredNodes) {
            int searchableCopies = (int)this.searchCluster.dispatchConfig().searchableCopies();
            int missingNodes = notAnswered - (searchableCopies - 1);
            if (this.answeredNodes > 0) {
                this.answeredActiveDocs += (long)missingNodes * this.answeredActiveDocs / (long)this.answeredNodes;
                this.answeredSoonActiveDocs += (long)missingNodes * this.answeredSoonActiveDocs / (long)this.answeredNodes;
                this.timedOut = true;
            }
        }
    }

    @Override
    protected void release() {
        if (!this.invokers.isEmpty()) {
            this.invokers.forEach(CloseableInvoker::close);
            this.invokers.clear();
        }
    }

    @Override
    public void responseAvailable(SearchInvoker from) {
        if (this.availableForProcessing != null) {
            this.availableForProcessing.add(from);
        }
    }

    @Override
    protected void setMonitor(ResponseMonitor<SearchInvoker> monitor) {
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    protected LinkedBlockingQueue<SearchInvoker> newQueue() {
        return new LinkedBlockingQueue<SearchInvoker>();
    }
}

