/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

import com.yahoo.container.protect.Error;
import com.yahoo.search.cluster.BaseNodeMonitor;
import com.yahoo.search.cluster.MonitorConfiguration;
import com.yahoo.search.result.ErrorMessage;

public class TrafficNodeMonitor<T>
extends BaseNodeMonitor<T> {
    private boolean atStartUp = true;

    public TrafficNodeMonitor(T node, MonitorConfiguration configuration, boolean internal) {
        super(internal);
        this.node = node;
        this.configuration = configuration;
    }

    @Override
    public T getNode() {
        return (T)this.node;
    }

    @Override
    public void failed(ErrorMessage error) {
        this.respondedAt = this.now();
        if (error.getCode() == Error.BACKEND_COMMUNICATION_ERROR.code) {
            this.setWorking(false, "Connection failure: " + error.toString());
        } else if (error.getCode() == Error.NO_ANSWER_WHEN_PINGING_NODE.code) {
            if (this.respondedAt - this.succeededAt > 10000L) {
                this.setWorking(false, "Not working for 10 s: " + error.toString());
            }
        } else {
            this.succeededAt = this.respondedAt;
        }
    }

    @Override
    public void responded() {
        this.succeededAt = this.respondedAt = this.now();
        this.atStartUp = false;
        if (!this.isWorking) {
            this.setWorking(true, "Responds correctly");
        }
    }

    @Override
    protected synchronized void setWorking(boolean working, String explanation) {
        if (this.isWorking == working) {
            return;
        }
        explanation = explanation == null ? "" : ": " + explanation;
        if (working) {
            log.info("Putting " + this.node + " in service" + explanation);
        } else {
            if (!this.atStartUp || !this.isInternal()) {
                log.warning("Taking " + this.node + " out of service" + explanation);
            }
            this.failedAt = this.now();
        }
        this.isWorking = working;
    }
}

