/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cache;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import java.util.HashSet;
import java.util.Set;

public final class QrBinaryCacheConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "bd21034db0c9009b60151f6d465d1fcd";
    public static final String CONFIG_DEF_NAME = "qr-binary-cache";
    public static final String CONFIG_DEF_NAMESPACE = "search.cache";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.cache", "block_size int default=256", "buffer_size int default=64", "assertions_disabled bool default=false", "use_direct_buffers bool default=true", "pooled_byte_arrays int default=1000", "cache_size int default=0", "profiling_enabled bool default=false", "lock_verification_enabled bool default=false"};
    private final IntegerNode block_size;
    private final IntegerNode buffer_size;
    private final BooleanNode assertions_disabled;
    private final BooleanNode use_direct_buffers;
    private final IntegerNode pooled_byte_arrays;
    private final IntegerNode cache_size;
    private final BooleanNode profiling_enabled;
    private final BooleanNode lock_verification_enabled;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public QrBinaryCacheConfig(Builder builder) {
        this(builder, true);
    }

    private QrBinaryCacheConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr-binary-cache must be initialized: " + builder.__uninitialized);
        }
        this.block_size = builder.block_size == null ? new IntegerNode(256) : new IntegerNode(builder.block_size.intValue());
        this.buffer_size = builder.buffer_size == null ? new IntegerNode(64) : new IntegerNode(builder.buffer_size.intValue());
        this.assertions_disabled = builder.assertions_disabled == null ? new BooleanNode(false) : new BooleanNode(builder.assertions_disabled.booleanValue());
        this.use_direct_buffers = builder.use_direct_buffers == null ? new BooleanNode(true) : new BooleanNode(builder.use_direct_buffers.booleanValue());
        this.pooled_byte_arrays = builder.pooled_byte_arrays == null ? new IntegerNode(1000) : new IntegerNode(builder.pooled_byte_arrays.intValue());
        this.cache_size = builder.cache_size == null ? new IntegerNode(0) : new IntegerNode(builder.cache_size.intValue());
        this.profiling_enabled = builder.profiling_enabled == null ? new BooleanNode(false) : new BooleanNode(builder.profiling_enabled.booleanValue());
        this.lock_verification_enabled = builder.lock_verification_enabled == null ? new BooleanNode(false) : new BooleanNode(builder.lock_verification_enabled.booleanValue());
    }

    public int block_size() {
        return this.block_size.value();
    }

    public int buffer_size() {
        return this.buffer_size.value();
    }

    public boolean assertions_disabled() {
        return this.assertions_disabled.value();
    }

    public boolean use_direct_buffers() {
        return this.use_direct_buffers.value();
    }

    public int pooled_byte_arrays() {
        return this.pooled_byte_arrays.value();
    }

    public int cache_size() {
        return this.cache_size.value();
    }

    public boolean profiling_enabled() {
        return this.profiling_enabled.value();
    }

    public boolean lock_verification_enabled() {
        return this.lock_verification_enabled.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrBinaryCacheConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer block_size = null;
        private Integer buffer_size = null;
        private Boolean assertions_disabled = null;
        private Boolean use_direct_buffers = null;
        private Integer pooled_byte_arrays = null;
        private Integer cache_size = null;
        private Boolean profiling_enabled = null;
        private Boolean lock_verification_enabled = null;

        public Builder() {
        }

        public Builder(QrBinaryCacheConfig config) {
            this.block_size(config.block_size());
            this.buffer_size(config.buffer_size());
            this.assertions_disabled(config.assertions_disabled());
            this.use_direct_buffers(config.use_direct_buffers());
            this.pooled_byte_arrays(config.pooled_byte_arrays());
            this.cache_size(config.cache_size());
            this.profiling_enabled(config.profiling_enabled());
            this.lock_verification_enabled(config.lock_verification_enabled());
        }

        private Builder override(Builder __superior) {
            if (__superior.block_size != null) {
                this.block_size(__superior.block_size);
            }
            if (__superior.buffer_size != null) {
                this.buffer_size(__superior.buffer_size);
            }
            if (__superior.assertions_disabled != null) {
                this.assertions_disabled(__superior.assertions_disabled);
            }
            if (__superior.use_direct_buffers != null) {
                this.use_direct_buffers(__superior.use_direct_buffers);
            }
            if (__superior.pooled_byte_arrays != null) {
                this.pooled_byte_arrays(__superior.pooled_byte_arrays);
            }
            if (__superior.cache_size != null) {
                this.cache_size(__superior.cache_size);
            }
            if (__superior.profiling_enabled != null) {
                this.profiling_enabled(__superior.profiling_enabled);
            }
            if (__superior.lock_verification_enabled != null) {
                this.lock_verification_enabled(__superior.lock_verification_enabled);
            }
            return this;
        }

        public Builder block_size(int __value) {
            this.block_size = __value;
            return this;
        }

        private Builder block_size(String __value) {
            return this.block_size(Integer.valueOf(__value));
        }

        public Builder buffer_size(int __value) {
            this.buffer_size = __value;
            return this;
        }

        private Builder buffer_size(String __value) {
            return this.buffer_size(Integer.valueOf(__value));
        }

        public Builder assertions_disabled(boolean __value) {
            this.assertions_disabled = __value;
            return this;
        }

        private Builder assertions_disabled(String __value) {
            return this.assertions_disabled(Boolean.valueOf(__value));
        }

        public Builder use_direct_buffers(boolean __value) {
            this.use_direct_buffers = __value;
            return this;
        }

        private Builder use_direct_buffers(String __value) {
            return this.use_direct_buffers(Boolean.valueOf(__value));
        }

        public Builder pooled_byte_arrays(int __value) {
            this.pooled_byte_arrays = __value;
            return this;
        }

        private Builder pooled_byte_arrays(String __value) {
            return this.pooled_byte_arrays(Integer.valueOf(__value));
        }

        public Builder cache_size(int __value) {
            this.cache_size = __value;
            return this;
        }

        private Builder cache_size(String __value) {
            return this.cache_size(Integer.valueOf(__value));
        }

        public Builder profiling_enabled(boolean __value) {
            this.profiling_enabled = __value;
            return this;
        }

        private Builder profiling_enabled(String __value) {
            return this.profiling_enabled(Boolean.valueOf(__value));
        }

        public Builder lock_verification_enabled(boolean __value) {
            this.lock_verification_enabled = __value;
            return this;
        }

        private Builder lock_verification_enabled(String __value) {
            return this.lock_verification_enabled(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrBinaryCacheConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrBinaryCacheConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrBinaryCacheConfig.CONFIG_DEF_NAMESPACE;
        }

        public QrBinaryCacheConfig build() {
            return new QrBinaryCacheConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

