/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search;

import com.yahoo.collections.ListMap;
import com.yahoo.net.URI;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.response.DataList;
import com.yahoo.protect.Validator;
import com.yahoo.search.Query;
import com.yahoo.search.query.context.QueryContext;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.HitOrderer;
import com.yahoo.search.result.HitSortOrderer;
import com.yahoo.search.result.Templating;
import com.yahoo.search.statistics.ElapsedTime;
import java.util.Iterator;

public final class Result
extends Response
implements Cloneable {
    private HitGroup hits;
    private long totalHitCount;
    private long deepHitCount;
    private ElapsedTime timeAccountant = new ElapsedTime();
    private Coverage coverage = null;
    private ListMap<String, String> headers = null;
    private final Templating templating;

    public Result(Query query) {
        this(query, new HitGroup("toplevel"));
    }

    public Result(Query query, HitGroup hits) {
        super((Request)query);
        if (query == null) {
            throw new NullPointerException("The query reference in a result cannot be null");
        }
        this.hits = hits;
        hits.setQuery(query);
        if (query.getRanking().getSorting() != null) {
            this.setHitOrderer(new HitSortOrderer(query.getRanking().getSorting()));
        }
        this.templating = new Templating(this);
    }

    public Result(Query query, ErrorMessage errorMessage) {
        this(query);
        this.hits.addError(errorMessage);
    }

    public void mergeWith(Result result) {
        if (this.templating.usesDefaultTemplate()) {
            this.templating.setRenderer(result.templating.getRenderer());
        }
        this.totalHitCount += result.getTotalHitCount();
        this.deepHitCount += result.getDeepHitCount();
        this.timeAccountant.merge(result.getElapsedTime());
        boolean create = true;
        if (result.getCoverage(!create) != null || this.getCoverage(!create) != null) {
            this.getCoverage(create).merge(result.getCoverage(create));
        }
    }

    public void mergeWithAfterFill(Result result) {
        this.timeAccountant.merge(result.getElapsedTime());
    }

    public int getHitCount() {
        return this.hits.size();
    }

    public int getConcreteHitCount() {
        return this.hits.getConcreteSize();
    }

    public long getTotalHitCount() {
        return this.totalHitCount;
    }

    public long getDeepHitCount() {
        if (this.deepHitCount < this.totalHitCount) {
            return this.totalHitCount;
        }
        return this.deepHitCount;
    }

    public void setTotalHitCount(long totalHitCount) {
        this.totalHitCount = totalHitCount;
    }

    public void setDeepHitCount(long deepHitCount) {
        this.deepHitCount = deepHitCount;
    }

    public ElapsedTime getElapsedTime() {
        return this.timeAccountant;
    }

    public void setElapsedTime(ElapsedTime t) {
        this.timeAccountant = t;
    }

    public boolean isCached() {
        return this.hits.isCached();
    }

    public boolean isFilled(String summaryClass) {
        return this.hits.isFilled(summaryClass);
    }

    public Query getQuery() {
        return this.hits.getQuery();
    }

    public void setQuery(Query query) {
        this.hits.setQuery(query);
    }

    public void setHitOrderer(HitOrderer hitOrderer) {
        this.hits.setOrderer(hitOrderer);
    }

    public HitOrderer getHitOrderer() {
        return this.hits.getOrderer();
    }

    public void setDeletionBreaksOrdering(boolean flag) {
        this.hits.setDeletionBreaksOrdering(flag);
    }

    public boolean getDeletionBreaksOrdering() {
        return this.hits.getDeletionBreaksOrdering();
    }

    public void analyzeHits() {
        this.hits.analyze();
    }

    public HitGroup hits() {
        return this.hits;
    }

    public DataList<?> data() {
        return this.hits;
    }

    public void setHits(HitGroup hits) {
        Validator.ensureNotNull((String)("The top-level hit group of " + this), (Object)hits);
        this.hits = hits;
    }

    public Result clone() {
        Result resultClone = (Result)super.clone();
        resultClone.hits = this.hits.clone();
        resultClone.getTemplating().setRenderer(null);
        resultClone.setElapsedTime(new ElapsedTime());
        return resultClone;
    }

    public String toString() {
        if (this.hits.getError() != null) {
            return "Result: " + (Object)((Object)this.hits.getErrorHit().errors().iterator().next());
        }
        return "Result (" + this.getConcreteHitCount() + " of total " + this.getTotalHitCount() + " hits)";
    }

    public void trace(String name) {
        if (this.hits().getQuery().getTraceLevel() < 5) {
            return;
        }
        StringBuilder hitBuffer = new StringBuilder(name);
        hitBuffer.append(" returns:\n");
        int counter = 0;
        Iterator<Hit> i = this.hits.unorderedIterator();
        while (i.hasNext()) {
            Hit hit = i.next();
            if (hit.isMeta()) continue;
            hitBuffer.append("  #: ");
            hitBuffer.append(counter);
            this.traceExtraHitProperties(hitBuffer, hit);
            hitBuffer.append(", relevancy: ");
            hitBuffer.append(hit.getRelevance());
            hitBuffer.append(", source: ");
            hitBuffer.append(hit.getSource());
            hitBuffer.append(", uri: ");
            URI uri = hit.getId();
            if (uri != null) {
                hitBuffer.append(uri.getHost());
            } else {
                hitBuffer.append("(no uri)");
            }
            hitBuffer.append("\n");
            ++counter;
        }
        if (counter == 0) {
            hitBuffer.append("(no hits)\n");
        }
        this.hits.getQuery().trace(hitBuffer.toString(), false, 5);
    }

    protected void traceExtraHitProperties(StringBuilder hitBuffer, Hit hit) {
    }

    public QueryContext getContext(boolean create) {
        return this.getQuery().getContext(create);
    }

    public void setCoverage(Coverage coverage) {
        this.coverage = coverage;
    }

    public Coverage getCoverage(boolean create) {
        if (this.coverage == null && create) {
            this.coverage = new Coverage(0L, 0L, 0, this.hits().size() == 0 ? 0 : 1);
        }
        return this.coverage;
    }

    public ListMap<String, String> getHeaders(boolean create) {
        if (this.headers == null && create) {
            this.headers = new ListMap();
        }
        return this.headers;
    }

    @Deprecated
    public Templating getTemplating() {
        return this.templating;
    }
}

