/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.templates;

import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.prelude.hitfield.JSONString;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.prelude.templates.Context;
import com.yahoo.prelude.templates.DefaultTemplateSet;
import com.yahoo.prelude.templates.FormattingOptions;
import com.yahoo.search.Result;
import com.yahoo.search.pagetemplates.model.Renderer;
import com.yahoo.search.pagetemplates.model.Source;
import com.yahoo.search.pagetemplates.result.SectionHitGroup;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.StructuredData;
import com.yahoo.text.XML;
import com.yahoo.text.XMLWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

@Deprecated
public class TiledTemplateSet
extends DefaultTemplateSet {
    private FormattingOptions hitOptionsForProvider;
    private FormattingOptions hitOptions = new FormattingOptions();

    public TiledTemplateSet() {
        this("tiled");
    }

    public TiledTemplateSet(String templateName) {
        super(templateName);
        this.hitOptions.formatFieldAsAttribute("provider", "provider");
        this.hitOptions.setFieldNotToRender("provider");
        this.hitOptionsForProvider = new FormattingOptions();
        this.hitOptionsForProvider.formatFieldAsAttribute("provider", "name");
        this.hitOptionsForProvider.formatFieldAsAttribute("scheme", "scheme");
        this.hitOptionsForProvider.formatFieldAsAttribute("host", "host");
        this.hitOptionsForProvider.formatFieldAsAttribute("port", "port");
        this.hitOptionsForProvider.formatFieldAsAttribute("path", "path");
        this.hitOptionsForProvider.formatFieldAsAttribute("status", "result");
        this.hitOptionsForProvider.formatFieldWithSubtype("latency_connect", "latency", "type", "connect");
        this.hitOptionsForProvider.formatFieldWithSubtype("latency_start", "latency", "type", "start");
        this.hitOptionsForProvider.formatFieldWithSubtype("latency_finish", "latency", "type", "finish");
        this.hitOptionsForProvider.formatFieldWithSubtype("query_param_", "parameter", "name");
        this.hitOptionsForProvider.formatFieldWithSubtype("header_", "header", "name");
        this.hitOptionsForProvider.formatFieldWithSubtype("response_header_", "response-header", "name");
        this.hitOptionsForProvider.formatFieldWithSubtype("count_first", "count", "type", "first");
        this.hitOptionsForProvider.formatFieldWithSubtype("count_last", "count", "type", "last");
        this.hitOptionsForProvider.formatFieldWithSubtype("count_total", "count", "type", "total");
        this.hitOptionsForProvider.formatFieldWithSubtype("count_deep", "count", "type", "deep");
        this.hitOptionsForProvider.formatFieldWithSubtype("queryattrs_xorronum", "queryattrs", "name", "xorronum");
        this.hitOptionsForProvider.formatFieldWithSubtype("queryattrs_RankFeaturesRewriterAttr", "queryattrs", "name", "RankFeaturesRewriterAttr");
        this.hitOptionsForProvider.formatFieldWithSubtype("queryattrs_intlannotator", "queryattrs", "name", "intlannotator");
        this.hitOptionsForProvider.formatFieldWithSubtype("queryattrs_category", "queryattrs", "name", "category");
        this.hitOptionsForProvider.formatFieldWithSubtype("wordcounts_", "wordcounts", "word");
        this.hitOptionsForProvider.setFieldNotToRender("provider");
    }

    @Override
    public XMLWriter wrapWriter(Writer writer) {
        return new XMLWriter((Writer)super.wrapWriter(writer));
    }

    @Override
    public void header(Context context, XMLWriter writer) throws IOException {
        Result result = (Result)context.get("result");
        writer.xmlHeader(this.getRequestedEncoding(result.getQuery()));
        writer.openTag("result").attribute("version", (Object)"1.0");
        writer.attribute("layout", result.hits().getField("layout"));
        TiledTemplateSet.renderCoverageAttributes(result.getCoverage(false), writer);
        writer.closeStartTag();
        this.renderSectionContent(result.hits(), writer);
    }

    @Override
    protected void renderHitAttributes(Hit hit, XMLWriter writer) throws IOException {
        if (hit instanceof HitGroup) {
            String type = hit.types().stream().collect(Collectors.joining(" "));
            if ("group".equals(type)) {
                type = String.valueOf(hit.getField("type"));
            }
            writer.attribute("type", (Object)type);
        } else {
            writer.attribute("type", (Object)hit.types().stream().collect(Collectors.joining(" ")));
        }
        if (hit.getRelevance() != null) {
            writer.attribute("relevance", (Object)hit.getRelevance());
        }
        writer.attribute("source", (Object)hit.getSource());
        for (Map.Entry<String, String> attr : this.hitOptions.fieldsAsAttributes()) {
            Object val = hit.getField(attr.getKey());
            if (val == null) continue;
            writer.attribute(attr.getValue(), (Object)String.valueOf(val));
        }
    }

    @Override
    protected void renderField(Context context, Hit hit, Map.Entry<String, Object> entry, XMLWriter writer) throws IOException {
        String fieldName = entry.getKey();
        if (!this.shouldRenderField(hit, fieldName)) {
            return;
        }
        writer.openTag(fieldName);
        this.renderFieldContent(context, hit, fieldName, writer);
        writer.closeTag();
    }

    @Override
    protected void renderHitFields(Context context, Hit hit, XMLWriter writer) throws IOException {
        this.renderId(hit.getId(), writer);
        Iterator<Map.Entry<String, Object>> it = hit.fieldIterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (!this.hitOptions.shouldRenderField(entry.getKey())) continue;
            this.renderField(context, hit, entry, writer);
        }
    }

    @Override
    protected boolean shouldRenderField(Hit hit, String fieldName) {
        if (fieldName.equals("relevancy")) {
            return false;
        }
        return !fieldName.equals("collapseId");
    }

    @Override
    public void hit(Context context, XMLWriter writer) throws IOException {
        Hit hit = (Hit)context.get("hit");
        if (hit.isMeta() && hit.types().contains("logging")) {
            this.renderProvider(context, hit, writer);
        } else {
            super.hit(context, writer);
        }
    }

    @Override
    protected void renderHitGroup(HitGroup hit, Context context, XMLWriter writer) throws IOException {
        if (hit.types().contains("section")) {
            this.renderSection(hit, writer);
        } else if (hit.types().contains("meta")) {
            writer.openTag("meta");
            writer.closeStartTag();
        } else {
            super.renderHitGroup(hit, context, writer);
        }
    }

    protected void renderSection(HitGroup hit, XMLWriter writer) throws IOException {
        writer.openTag("section");
        writer.attribute("id", (Object)hit.getDisplayId());
        writer.attribute("layout", hit.getField("layout"));
        writer.attribute("region", hit.getField("region"));
        writer.attribute("placement", hit.getField("placement"));
        writer.closeStartTag();
        this.renderSectionContent(hit, writer);
    }

    protected void renderSectionContent(HitGroup hit, XMLWriter writer) throws IOException {
        if (hit instanceof SectionHitGroup) {
            SectionHitGroup sectionGroup = (SectionHitGroup)hit;
            for (Source source : sectionGroup.sources()) {
                writer.openTag("source").attribute("url", (Object)source.getUrl());
                this.renderParameters(source.parameters(), writer);
                writer.closeTag();
            }
            for (Renderer renderer : sectionGroup.renderers()) {
                writer.openTag("renderer").attribute("for", (Object)renderer.getRendererFor()).attribute("name", (Object)renderer.getName());
                this.renderParameters(renderer.parameters(), writer);
                writer.closeTag();
            }
        }
    }

    private void renderParameters(Map<String, String> parameters, XMLWriter writer) throws IOException {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            writer.openTag("parameter").attribute("name", (Object)parameter.getKey()).content((Object)parameter.getValue(), false).closeTag();
        }
    }

    protected void renderProvider(Context context, Hit hit, XMLWriter writer) throws IOException {
        writer.openTag("provider");
        this.renderProviderHitAttributes(hit, writer);
        writer.closeStartTag();
        this.renderProviderHitFields(context, hit, writer);
    }

    protected void renderProviderHitAttributes(Hit hit, XMLWriter writer) throws IOException {
        for (Map.Entry<String, String> attr : this.hitOptionsForProvider.fieldsAsAttributes()) {
            writer.attribute(attr.getValue(), hit.getField(attr.getKey()));
        }
    }

    protected void renderProviderHitFields(Context context, Hit hit, XMLWriter writer) throws IOException {
        this.renderId(hit.getId(), writer);
        Iterator<Map.Entry<String, Object>> it = hit.fieldIterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (this.hitOptionsForProvider.getAttributeName(entry.getKey()) != null || !this.hitOptionsForProvider.shouldRenderField(entry.getKey())) continue;
            this.renderProviderField(context, hit, entry, writer);
        }
    }

    protected void renderProviderField(Context context, Hit hit, Map.Entry<String, Object> entry, XMLWriter writer) throws IOException {
        String name = entry.getKey();
        FormattingOptions.SubtypeField subtypeField = this.hitOptionsForProvider.getSubtype(name);
        if (subtypeField == null) {
            subtypeField = this.hitOptionsForProvider.getSubtypeWithPrefix(name);
        }
        if (subtypeField != null) {
            writer.openTag(subtypeField.tagName);
            if (subtypeField.attributeValue != null) {
                writer.attribute(subtypeField.attributeName, (Object)subtypeField.attributeValue);
            } else if (subtypeField instanceof FormattingOptions.SubtypeFieldWithPrefix) {
                writer.attribute(subtypeField.attributeName, (Object)name.substring(((FormattingOptions.SubtypeFieldWithPrefix)subtypeField).prefixLength));
            }
        } else {
            writer.openTag(name);
        }
        writer.escapedContent(this.asXML(hit.getField(name)), false).closeTag();
    }

    private String asXML(Object value) {
        if (value == null) {
            return "(null)";
        }
        if (value instanceof HitField) {
            return ((HitField)value).quotedContent(false);
        }
        if (value instanceof StructuredData || value instanceof XMLString || value instanceof JSONString) {
            return value.toString();
        }
        return XML.xmlEscape((String)value.toString(), (boolean)false, (char)'\u001f');
    }

    public String toString() {
        return "tiled result template";
    }
}

