/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.templates;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.net.URI;
import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.prelude.hitfield.JSONString;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.prelude.templates.Context;
import com.yahoo.prelude.templates.UserTemplate;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.result.HitRenderer;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.Relevance;
import com.yahoo.search.result.StructuredData;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8String;
import com.yahoo.text.XML;
import com.yahoo.text.XMLWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

@Deprecated
public class DefaultTemplateSet
extends UserTemplate<XMLWriter> {
    private static final Utf8String RESULT = new Utf8String("result");
    private static final Utf8String GROUP = new Utf8String("group");
    private static final Utf8String ID = new Utf8String("id");
    private static final Utf8String FIELD = new Utf8String("field");
    private static final Utf8String HIT = new Utf8String("hit");
    private static final Utf8String ERROR = new Utf8String("error");
    private static final Utf8String TOTAL_HIT_COUNT = new Utf8String("total-hit-count");
    private static final Utf8String QUERY_TIME = new Utf8String("querytime");
    private static final Utf8String SUMMARY_FETCH_TIME = new Utf8String("summaryfetchtime");
    private static final Utf8String SEARCH_TIME = new Utf8String("searchtime");
    private static final Utf8String NAME = new Utf8String("name");
    private static final Utf8String CODE = new Utf8String("code");
    private static final Utf8String COVERAGE_DOCS = new Utf8String("coverage-docs");
    private static final Utf8String COVERAGE_NODES = new Utf8String("coverage-nodes");
    private static final Utf8String COVERAGE_FULL = new Utf8String("coverage-full");
    private static final Utf8String COVERAGE = new Utf8String("coverage");
    private static final Utf8String RESULTS_FULL = new Utf8String("results-full");
    private static final Utf8String RESULTS = new Utf8String("results");
    private static final Utf8String TYPE = new Utf8String("type");
    private static final Utf8String RELEVANCY = new Utf8String("relevancy");
    private static final Utf8String SOURCE = new Utf8String("source");
    private final CopyOnWriteHashMap<String, Utf8String> fieldNameMap = new CopyOnWriteHashMap();

    protected DefaultTemplateSet(String name) {
        super(name, "text/xml", "utf-8");
    }

    public DefaultTemplateSet() {
        this("default");
    }

    @Override
    public XMLWriter wrapWriter(Writer writer) {
        return XMLWriter.from((Writer)writer, (int)10, (int)-1);
    }

    @Override
    public void header(Context context, XMLWriter writer) throws IOException {
        Result result = (Result)context.get("result");
        context.setUtf8Output("utf-8".equalsIgnoreCase(this.getRequestedEncoding(result.getQuery())));
        writer.xmlHeader(this.getRequestedEncoding(result.getQuery()));
        writer.openTag(RESULT).attribute(TOTAL_HIT_COUNT, String.valueOf(result.getTotalHitCount()));
        DefaultTemplateSet.renderCoverageAttributes(result.getCoverage(false), writer);
        this.renderTime(writer, result);
        writer.closeStartTag();
    }

    private void renderTime(XMLWriter writer, Result result) {
        if (!result.getQuery().getPresentation().getTiming()) {
            return;
        }
        String threeDecimals = "%.3f";
        double milli = 0.001;
        long now = System.currentTimeMillis();
        long searchTime = now - result.getElapsedTime().first();
        double searchSeconds = (double)searchTime * 0.001;
        if (result.getElapsedTime().firstFill() != 0L) {
            long queryTime = result.getElapsedTime().weightedSearchTime();
            long summaryFetchTime = result.getElapsedTime().weightedFillTime();
            double querySeconds = (double)queryTime * 0.001;
            double summarySeconds = (double)summaryFetchTime * 0.001;
            writer.attribute(QUERY_TIME, String.format("%.3f", querySeconds));
            writer.attribute(SUMMARY_FETCH_TIME, String.format("%.3f", summarySeconds));
        }
        writer.attribute(SEARCH_TIME, String.format("%.3f", searchSeconds));
    }

    @Override
    public void footer(Context context, XMLWriter writer) throws IOException {
        writer.closeTag();
    }

    @Override
    public void hit(Context context, XMLWriter writer) throws IOException {
        Hit hit = (Hit)context.get("hit");
        if (hit instanceof HitGroup) {
            this.renderHitGroup((HitGroup)hit, context, writer);
        } else {
            writer.openTag(HIT);
            this.renderHitAttributes(hit, writer);
            writer.closeStartTag();
            this.renderHitFields(context, hit, writer);
        }
    }

    @Override
    public void hitFooter(Context context, XMLWriter writer) throws IOException {
        writer.closeTag();
    }

    @Override
    public void error(Context context, XMLWriter writer) {
        ErrorMessage error = ((Result)context.get("result")).hits().getError();
        writer.openTag(ERROR).attribute(CODE, (long)error.getCode()).content((Object)error.getMessage(), false).closeTag();
    }

    @Override
    public void noHits(Context context, XMLWriter writer) {
    }

    protected static void renderCoverageAttributes(Coverage coverage, XMLWriter writer) {
        if (coverage == null) {
            return;
        }
        writer.attribute(COVERAGE_DOCS, coverage.getDocs());
        writer.attribute(COVERAGE_NODES, (long)coverage.getNodes());
        writer.attribute(COVERAGE_FULL, coverage.getFull());
        writer.attribute(COVERAGE, (long)coverage.getResultPercentage());
        writer.attribute(RESULTS_FULL, (long)coverage.getFullResultSets());
        writer.attribute(RESULTS, (long)coverage.getResultSets());
    }

    protected void renderHitAttributes(Hit hit, XMLWriter writer) throws IOException {
        writer.attribute(TYPE, hit.types().stream().collect(Collectors.joining(" ")));
        if (hit.getRelevance() != null) {
            writer.attribute(RELEVANCY, hit.getRelevance().toString());
        }
        writer.attribute(SOURCE, hit.getSource());
    }

    protected void renderHitGroup(HitGroup hit, Context context, XMLWriter writer) throws IOException {
        if (!HitRenderer.renderHeader(hit, writer)) {
            if (hit.types().contains("grouphit")) {
                this.renderHitGroupOfTypeGroupHit(context, hit, writer);
            } else {
                this.renderGroup(hit, writer);
            }
        }
    }

    protected void renderGroup(HitGroup hit, XMLWriter writer) throws IOException {
        writer.openTag(GROUP);
        this.renderHitAttributes(hit, writer);
        writer.closeStartTag();
    }

    protected void renderHitGroupOfTypeGroupHit(Context context, HitGroup hit, XMLWriter writer) throws IOException {
        writer.openTag(HIT);
        this.renderHitAttributes(hit, writer);
        this.renderId(hit.getId(), writer);
        writer.closeStartTag();
    }

    protected void renderId(URI uri, XMLWriter writer) {
        if (uri != null) {
            writer.openTag(ID).content((Object)uri.stringValue(), false).closeTag();
        }
    }

    protected void renderHitFields(Context context, Hit hit, XMLWriter writer) throws IOException {
        this.renderSyntheticRelevancyField(hit, writer);
        Iterator<Map.Entry<String, Object>> it = hit.fieldIterator();
        while (it.hasNext()) {
            this.renderField(context, hit, it.next(), writer);
        }
    }

    private void renderSyntheticRelevancyField(Hit hit, XMLWriter writer) {
        String relevancyFieldName = "relevancy";
        Relevance relevance = hit.getRelevance();
        if (this.shouldRenderField(hit, "relevancy") && relevance != null) {
            this.renderSimpleField("relevancy", relevance, writer);
        }
    }

    protected void renderField(Context context, Hit hit, Map.Entry<String, Object> entry, XMLWriter writer) throws IOException {
        String fieldName = entry.getKey();
        if (!this.shouldRenderField(hit, fieldName)) {
            return;
        }
        if (fieldName.startsWith("$")) {
            return;
        }
        this.writeOpenFieldElement(fieldName, writer);
        this.renderFieldContent(context, hit, fieldName, writer);
        this.writeCloseFieldElement(writer);
    }

    private void writeOpenFieldElement(String fieldName, XMLWriter writer) {
        Utf8String utf8 = (Utf8String)this.fieldNameMap.get((Object)fieldName);
        if (utf8 == null) {
            utf8 = new Utf8String(fieldName);
            this.fieldNameMap.put((Object)fieldName, (Object)utf8);
        }
        writer.openTag(FIELD).attribute(NAME, (AbstractUtf8Array)utf8);
        writer.closeStartTag();
    }

    private void writeCloseFieldElement(XMLWriter writer) {
        writer.closeTag();
    }

    protected void renderFieldContent(Context context, Hit hit, String name, XMLWriter writer) {
        writer.escapedContent(this.asXML(hit.getField(name)), false);
    }

    private String asXML(Object value) {
        if (value == null) {
            return "(null)";
        }
        if (value instanceof HitField) {
            return ((HitField)value).quotedContent(false);
        }
        if (value instanceof StructuredData || value instanceof XMLString || value instanceof JSONString) {
            return value.toString();
        }
        return XML.xmlEscape((String)value.toString(), (boolean)false, (char)'\u001f');
    }

    private void renderSimpleField(String fieldName, Object fieldValue, XMLWriter writer) {
        this.writeOpenFieldElement(fieldName, writer);
        writer.content((Object)fieldValue.toString(), false);
        this.writeCloseFieldElement(writer);
    }

    protected boolean shouldRenderField(Hit hit, String fieldName) {
        return true;
    }
}

