/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.HasIndexItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.TreeMap;

@After(value={"rawQuery", "PhraseReplacement"})
@Before(value={"transformedQuery"})
@Provides(value={"MixedRecallRewrite"})
@Deprecated
public class IndexCombinatorSearcher
extends Searcher {
    public static final String MIXED_RECALL_REWRITE = "MixedRecallRewrite";
    private final ArrayComparator comparator = new ArrayComparator();

    @Override
    public Result search(Query query, Execution execution) {
        String oldQuery;
        Item root = query.getModel().getQueryTree().getRoot();
        IndexFacts.Session session = execution.context().getIndexFacts().newSession(query);
        String string = oldQuery = query.getTraceLevel() >= 2 ? root.toString() : "";
        if (root instanceof BlockItem || root instanceof PhraseItem) {
            root = this.convertSinglePhraseOrBlock(root, session);
        } else if (root instanceof CompositeItem) {
            root = this.rewrite((CompositeItem)root, session);
        }
        query.getModel().getQueryTree().setRoot(root);
        if (query.getTraceLevel() >= 2 && !oldQuery.equals(root.toString())) {
            query.trace("Rewriting for mixed recall between indices and attributes", true, 2);
        }
        return execution.search(query);
    }

    private RewriteStrategies chooseRewriteStrategy(CompositeItem c, IndexFacts.Session session) {
        if (c instanceof OrItem) {
            return RewriteStrategies.FLAT;
        }
        if (!(c instanceof AndItem)) {
            return RewriteStrategies.NONE;
        }
        TreeMap<Index.Attribute[], Integer> m = new TreeMap<Index.Attribute[], Integer>(this.comparator);
        ListIterator<Item> i = c.getItemIterator();
        while (i.hasNext()) {
            Index.Attribute[] attributes;
            Item j = (Item)i.next();
            if (!(j instanceof BlockItem) && !(j instanceof PhraseItem) || (attributes = this.getIndices((HasIndexItem)((Object)j), session)) == null) continue;
            Integer count = (Integer)m.get(attributes);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            m.put(attributes, count);
        }
        if (m.size() == 0) {
            return RewriteStrategies.NONE;
        }
        int singles = 0;
        int pairs = 0;
        int higher = 0;
        block5: for (Integer i2 : m.values()) {
            switch (i2) {
                case 1: {
                    ++singles;
                    continue block5;
                }
                case 2: {
                    pairs += 2;
                    continue block5;
                }
            }
            ++higher;
        }
        if (higher == 0 && pairs + singles <= 2) {
            return RewriteStrategies.EXPENSIVE_AND;
        }
        return RewriteStrategies.CHEAP_AND;
    }

    private CompositeItem rewriteNot(NotItem not, IndexFacts.Session session) {
        Item positive = not.getItem(0);
        if (positive instanceof BlockItem || positive instanceof PhraseItem) {
            positive = this.convertSinglePhraseOrBlock(positive, session);
            not.setItem(0, positive);
        } else if (positive instanceof CompositeItem) {
            CompositeItem c = (CompositeItem)positive;
            positive = this.rewrite(c, session);
            not.setItem(0, positive);
        }
        int length = not.getItemCount();
        for (int i = 1; i < length; ++i) {
            Item exclusion = not.getItem(i);
            if (exclusion instanceof BlockItem || exclusion instanceof PhraseItem) {
                exclusion = this.convertSinglePhraseOrBlock(exclusion, session);
                not.setItem(i, exclusion);
                continue;
            }
            if (!(exclusion instanceof CompositeItem)) continue;
            CompositeItem c = (CompositeItem)exclusion;
            switch (this.chooseRewriteStrategy(c, session)) {
                case NONE: {
                    c = this.traverse(c, session);
                    break;
                }
                case CHEAP_AND: 
                case EXPENSIVE_AND: {
                    c = this.cheapTransform(c, session);
                    break;
                }
                default: {
                    c = this.flatTransform(c, session);
                }
            }
            not.setItem(i, c);
        }
        return not;
    }

    private Item rewrite(CompositeItem c, IndexFacts.Session session) {
        if (c instanceof NotItem) {
            c = this.rewriteNot((NotItem)c, session);
            return c;
        }
        switch (this.chooseRewriteStrategy(c, session)) {
            case NONE: {
                c = this.traverse(c, session);
                break;
            }
            case CHEAP_AND: {
                c = this.cheapTransform(c, session);
                break;
            }
            case EXPENSIVE_AND: {
                c = this.expensiveTransform((AndItem)c, session);
                break;
            }
            case FLAT: {
                c = this.flatTransform(c, session);
                break;
            }
        }
        return c;
    }

    private CompositeItem traverse(CompositeItem c, IndexFacts.Session session) {
        int length = c.getItemCount();
        for (int i = 0; i < length; ++i) {
            Item word = c.getItem(i);
            if (!(word instanceof CompositeItem) || word instanceof PhraseItem || word instanceof BlockItem) continue;
            c.setItem(i, this.rewrite((CompositeItem)word, session));
        }
        return c;
    }

    private CompositeItem expensiveTransform(AndItem c, IndexFacts.Session session) {
        int[] indices = new int[2];
        int items = 0;
        int length = c.getItemCount();
        Index.Attribute[][] names = new Index.Attribute[2][];
        OrItem result = null;
        for (int i = 0; i < length; ++i) {
            Item word = c.getItem(i);
            if (word instanceof BlockItem || word instanceof PhraseItem) {
                Index.Attribute[] attributes = this.getIndices((HasIndexItem)((Object)word), session);
                if (attributes == null) continue;
                names[items] = attributes;
                indices[items++] = i;
                continue;
            }
            if (!(word instanceof CompositeItem)) continue;
            c.setItem(i, this.rewrite((CompositeItem)word, session));
        }
        switch (items) {
            case 1: {
                result = this.linearAnd(c, names[0], indices[0]);
                break;
            }
            case 2: {
                result = this.quadraticAnd(c, names[0], names[1], indices[0], indices[1]);
                break;
            }
            default: {
                this.getLogger().log(LogLevel.WARNING, "Unexpected number of items for mixed recall, got " + items + ", expected 1 or 2.");
            }
        }
        return result;
    }

    private Index.Attribute[] getIndices(HasIndexItem block, IndexFacts.Session session) {
        return session.getIndex(block.getIndexName()).getMatchGroup();
    }

    private OrItem linearAnd(AndItem c, Index.Attribute[] names, int brancherIndex) {
        OrItem or = new OrItem();
        for (int i = 0; i < names.length; ++i) {
            AndItem duck = (AndItem)c.clone();
            Item b = this.retarget(duck.getItem(brancherIndex), names[i]);
            duck.setItem(brancherIndex, b);
            or.addItem(duck);
        }
        return or;
    }

    private OrItem quadraticAnd(AndItem c, Index.Attribute[] firstNames, Index.Attribute[] secondNames, int firstBrancher, int secondBrancher) {
        OrItem or = new OrItem();
        for (int i = 0; i < firstNames.length; ++i) {
            for (int j = 0; j < secondNames.length; ++j) {
                AndItem duck = (AndItem)c.clone();
                Item b = this.retarget(duck.getItem(firstBrancher), firstNames[i]);
                duck.setItem(firstBrancher, b);
                b = this.retarget(duck.getItem(secondBrancher), secondNames[j]);
                duck.setItem(secondBrancher, b);
                or.addItem(duck);
            }
        }
        return or;
    }

    private CompositeItem flatTransform(CompositeItem c, IndexFacts.Session session) {
        int maxIndex;
        for (int i = maxIndex = c.getItemCount() - 1; i >= 0; --i) {
            Item word = c.getItem(i);
            if (word instanceof BlockItem || word instanceof PhraseItem) {
                Index.Attribute[] attributes = this.getIndices((HasIndexItem)((Object)word), session);
                if (attributes == null) continue;
                c.removeItem(i);
                for (Index.Attribute name : attributes) {
                    Item term = word.clone();
                    Item forNewIndex = this.retarget(term, name);
                    c.addItem(forNewIndex);
                }
                continue;
            }
            if (!(word instanceof CompositeItem)) continue;
            c.setItem(i, this.rewrite((CompositeItem)word, session));
        }
        return c;
    }

    private CompositeItem cheapTransform(CompositeItem c, IndexFacts.Session session) {
        if (c instanceof OrItem) {
            return this.flatTransform(c, session);
        }
        int length = c.getItemCount();
        for (int i = 0; i < length; ++i) {
            Item j = c.getItem(i);
            if (j instanceof BlockItem || j instanceof PhraseItem) {
                Index.Attribute[] attributes = this.getIndices((HasIndexItem)((Object)j), session);
                if (attributes == null) continue;
                OrItem or = this.searchAllForItem(j, attributes);
                c.setItem(i, or);
                continue;
            }
            if (!(j instanceof CompositeItem)) continue;
            c.setItem(i, this.rewrite((CompositeItem)j, session));
        }
        return c;
    }

    private OrItem searchAllForItem(Item word, Index.Attribute[] attributes) {
        OrItem or = new OrItem();
        for (Index.Attribute name : attributes) {
            Item term = word.clone();
            term = this.retarget(term, name);
            or.addItem(term);
        }
        return or;
    }

    private Item retarget(Item word, Index.Attribute newIndex) {
        if (word instanceof PhraseItem && !newIndex.isTokenizedContent()) {
            PhraseItem asPhrase = (PhraseItem)word;
            WordItem newWord = new WordItem(asPhrase.getIndexedString(), newIndex.name, false);
            return newWord;
        }
        if (word instanceof IndexedItem) {
            word.setIndexName(newIndex.name);
        } else if (word instanceof CompositeItem) {
            CompositeItem asComposite = (CompositeItem)word;
            ListIterator<Item> i = asComposite.getItemIterator();
            while (i.hasNext()) {
                Item segment = (Item)i.next();
                segment.setIndexName(newIndex.name);
            }
        }
        return word;
    }

    private Item convertSinglePhraseOrBlock(Item item, IndexFacts.Session session) {
        Index.Attribute[] attributes = this.getIndices((HasIndexItem)((Object)item), session);
        if (attributes == null) {
            return item;
        }
        OrItem newItem = this.searchAllForItem(item, attributes);
        return newItem;
    }

    private static enum RewriteStrategies {
        NONE,
        CHEAP_AND,
        EXPENSIVE_AND,
        FLAT;

    }

    private static class ArrayComparator
    implements Comparator<Index.Attribute[]> {
        private ArrayComparator() {
        }

        @Override
        public int compare(Index.Attribute[] o1, Index.Attribute[] o2) {
            if (o1.length < o2.length) {
                return -1;
            }
            if (o1.length > o2.length) {
                return 1;
            }
            int limit = o1.length;
            for (int i = 0; i < limit; ++i) {
                int r = o1[i].name.compareTo(o2[i].name);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }
    }
}

